/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.deployment;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Clock;
import java.time.Instant;
import pl.touk.nussknacker.engine.api.deployment.DeployedScenarioData;
import pl.touk.nussknacker.engine.api.deployment.DeploymentManager;
import pl.touk.nussknacker.engine.api.deployment.ProcessActionType$;
import pl.touk.nussknacker.engine.api.deployment.ProcessState;
import pl.touk.nussknacker.engine.api.deployment.ProcessStateDefinitionManager;
import pl.touk.nussknacker.engine.api.deployment.StateStatus;
import pl.touk.nussknacker.engine.api.deployment.simple.SimpleProcessStateDefinitionManager$;
import pl.touk.nussknacker.engine.api.deployment.simple.SimpleStateStatus$;
import pl.touk.nussknacker.engine.api.process.ProcessId;
import pl.touk.nussknacker.engine.api.process.ProcessName;
import pl.touk.nussknacker.engine.api.process.VersionId;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.engine.deployment.DeploymentData;
import pl.touk.nussknacker.engine.deployment.ExternalDeploymentId;
import pl.touk.nussknacker.engine.deployment.User;
import pl.touk.nussknacker.restmodel.process.ProcessIdWithName;
import pl.touk.nussknacker.restmodel.processdetails;
import pl.touk.nussknacker.restmodel.validation.ValidationResults;
import pl.touk.nussknacker.ui.api.ListenerApiUser$;
import pl.touk.nussknacker.ui.db.entity.CommentEntityData;
import pl.touk.nussknacker.ui.db.entity.ProcessActionEntityData;
import pl.touk.nussknacker.ui.db.entity.ProcessActionId;
import pl.touk.nussknacker.ui.listener.Comment;
import pl.touk.nussknacker.ui.listener.ProcessChangeEvent;
import pl.touk.nussknacker.ui.listener.ProcessChangeListener;
import pl.touk.nussknacker.ui.process.deployment.DeploymentManagerDispatcher;
import pl.touk.nussknacker.ui.process.deployment.DeploymentService;
import pl.touk.nussknacker.ui.process.deployment.DeploymentServiceImpl$;
import pl.touk.nussknacker.ui.process.deployment.LoggedUserConversions$;
import pl.touk.nussknacker.ui.process.deployment.ObsoleteStateDetector$;
import pl.touk.nussknacker.ui.process.deployment.ScenarioResolver;
import pl.touk.nussknacker.ui.process.exception.DeployingInvalidScenarioError$;
import pl.touk.nussknacker.ui.process.exception.ProcessIllegalAction$;
import pl.touk.nussknacker.ui.process.repository.DBIOActionRunner;
import pl.touk.nussknacker.ui.process.repository.DbProcessActionRepository;
import pl.touk.nussknacker.ui.process.repository.DeploymentComment;
import pl.touk.nussknacker.ui.process.repository.DeploymentComment$;
import pl.touk.nussknacker.ui.process.repository.FetchingProcessRepository;
import pl.touk.nussknacker.ui.process.repository.FetchingProcessRepository$FetchProcessesDetailsQuery$;
import pl.touk.nussknacker.ui.process.repository.ProcessDBQueryRepository;
import pl.touk.nussknacker.ui.process.repository.ProcessDBQueryRepository$;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.security.api.NussknackerInternalUser$;
import pl.touk.nussknacker.ui.validation.ProcessValidation;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.Tuple4;
import scala.collection.Iterable;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.concurrent.Await$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;
import scala.util.control.NonFatal$;
import slick.dbio.DBIOAction;
import slick.dbio.DBIOAction$;
import slick.dbio.Effect;
import slick.dbio.NoStream;

@ScalaSignature(bytes="\u0006\u0001\u0011Mb\u0001B\u0011#\u0001=B\u0001\u0002\u0012\u0001\u0003\u0002\u0003\u0006I!\u0012\u0005\t\u0011\u0002\u0011\t\u0011)A\u0005\u0013\"A\u0011\r\u0001B\u0001B\u0003%!\r\u0003\u0005f\u0001\t\u0005\t\u0015!\u0003g\u0011!I\u0007A!A!\u0002\u0013Q\u0007\u0002\u00039\u0001\u0005\u0003\u0005\u000b\u0011B9\t\u0011Q\u0004!\u0011!Q\u0001\nUD\u0001b\u001f\u0001\u0003\u0002\u0003\u0006I\u0001 \u0005\b\u0003\u0013\u0001A\u0011AA\u0006\u0011\u001d\ty\u0002\u0001C\u0001\u0003CAq!!#\u0001\t\u0003\nY\tC\u0004\u0002H\u0002!\t%!3\t\u000f\u0005u\b\u0001\"\u0005\u0002\u0000\"9!\u0011\b\u0001\u0005\n\tm\u0002b\u0002B \u0001\u0011%!\u0011\t\u0005\b\u0005s\u0003A\u0011\u0002B^\u0011\u001d\u0011y\u000e\u0001C\u0005\u0005CDqAa>\u0001\t\u0013\u0011I\u0010C\u0004\u0004\u001a\u0001!\tba\u0007\t\u000f\rU\u0002\u0001\"\u0003\u00048!911\r\u0001\u0005B\r\u0015\u0004bBB9\u0001\u0011\u000531\u000f\u0005\b\u0007G\u0002A\u0011BBD\u0011\u001d\u0019i\u000b\u0001C\u0005\u0007_Cqa!1\u0001\t\u0013\u0019\u0019\rC\u0004\u0004V\u0002!Iaa6\t\u000f\r5\b\u0001\"\u0003\u0004p\"9Aq\u0002\u0001\u0005\u0002\u0011Eq!\u0003C\nE\u0005\u0005\t\u0012\u0001C\u000b\r!\t#%!A\t\u0002\u0011]\u0001bBA\u0005=\u0011\u0005A\u0011\u0004\u0005\n\t7q\u0012\u0013!C\u0001\t;\u0011Q\u0003R3qY>LX.\u001a8u'\u0016\u0014h/[2f\u00136\u0004HN\u0003\u0002$I\u0005QA-\u001a9m_flWM\u001c;\u000b\u0005\u00152\u0013a\u00029s_\u000e,7o\u001d\u0006\u0003O!\n!!^5\u000b\u0005%R\u0013a\u00038vgN\\g.Y2lKJT!a\u000b\u0017\u0002\tQ|Wo\u001b\u0006\u0002[\u0005\u0011\u0001\u000f\\\u0002\u0001'\u0011\u0001\u0001G\u000e\u001e\u0011\u0005E\"T\"\u0001\u001a\u000b\u0003M\nQa]2bY\u0006L!!\u000e\u001a\u0003\r\u0005s\u0017PU3g!\t9\u0004(D\u0001#\u0013\tI$EA\tEKBdw._7f]R\u001cVM\u001d<jG\u0016\u0004\"a\u000f\"\u000e\u0003qR!!\u0010 \u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005}\u0002\u0015\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003\u0005\u000b1aY8n\u0013\t\u0019EHA\u0006MCjLHj\\4hS:<\u0017A\u00033jgB\fGo\u00195feB\u0011qGR\u0005\u0003\u000f\n\u00121\u0004R3qY>LX.\u001a8u\u001b\u0006t\u0017mZ3s\t&\u001c\b/\u0019;dQ\u0016\u0014\u0018!\u00059s_\u000e,7o\u001d*fa>\u001c\u0018\u000e^8ssB\u0019!*T(\u000e\u0003-S!\u0001\u0014\u0013\u0002\u0015I,\u0007o\\:ji>\u0014\u00180\u0003\u0002O\u0017\nIb)\u001a;dQ&tw\r\u0015:pG\u0016\u001c8OU3q_NLGo\u001c:z!\t\u0001fL\u0004\u0002R7:\u0011!\u000b\u0017\b\u0003'Zk\u0011\u0001\u0016\u0006\u0003+:\na\u0001\u0010:p_Rt\u0014\"A,\u0002\u0005\u0011\u0014\u0017BA-[\u0003\u0011)H/\u001b7\u000b\u0003]K!\u0001X/\u0002'\u0011\u0013\u0015jT!di&|g.\u00138ti\u0006t7-Z:\u000b\u0005eS\u0016BA0a\u0005\t!%I\u0003\u0002];\u0006\u0001\u0012m\u0019;j_:\u0014V\r]8tSR|'/\u001f\t\u0004\u0015\u000e|\u0015B\u00013L\u0005e!%\r\u0015:pG\u0016\u001c8/Q2uS>t'+\u001a9pg&$xN]=\u0002\u0015\u0011\u0014\u0017n\u001c*v]:,'\u000f\u0005\u0002KO&\u0011\u0001n\u0013\u0002\u0011\t\nKu*Q2uS>t'+\u001e8oKJ\f\u0011\u0003\u001d:pG\u0016\u001c8OV1mS\u0012\fG/[8o!\tYg.D\u0001m\u0015\tig%\u0001\u0006wC2LG-\u0019;j_:L!a\u001c7\u0003#A\u0013xnY3tgZ\u000bG.\u001b3bi&|g.\u0001\ttG\u0016t\u0017M]5p%\u0016\u001cx\u000e\u001c<feB\u0011qG]\u0005\u0003g\n\u0012\u0001cU2f]\u0006\u0014\u0018n\u001c*fg>dg/\u001a:\u0002+A\u0014xnY3tg\u000eC\u0017M\\4f\u0019&\u001cH/\u001a8feB\u0011a/_\u0007\u0002o*\u0011\u0001PJ\u0001\tY&\u001cH/\u001a8fe&\u0011!p\u001e\u0002\u0016!J|7-Z:t\u0007\"\fgnZ3MSN$XM\\3s\u0003\u0015\u0019Gn\\2l!\ri\u0018QA\u0007\u0002}*\u0019q0!\u0001\u0002\tQLW.\u001a\u0006\u0003\u0003\u0007\tAA[1wC&\u0019\u0011q\u0001@\u0003\u000b\rcwnY6\u0002\rqJg.\u001b;?)I\ti!a\u0004\u0002\u0012\u0005M\u0011QCA\f\u00033\tY\"!\b\u0011\u0005]\u0002\u0001\"\u0002#\n\u0001\u0004)\u0005\"\u0002%\n\u0001\u0004I\u0005\"B1\n\u0001\u0004\u0011\u0007\"B3\n\u0001\u00041\u0007\"B5\n\u0001\u0004Q\u0007\"\u00029\n\u0001\u0004\t\b\"\u0002;\n\u0001\u0004)\bbB>\n!\u0003\u0005\r\u0001`\u0001\u0015O\u0016$H)\u001a9m_f,GmU2f]\u0006\u0014\u0018n\\:\u0015\t\u0005\r\u0012q\f\u000b\u0005\u0003K\t)\u0006\u0005\u0004\u0002(\u00055\u0012\u0011G\u0007\u0003\u0003SQ1!a\u000b3\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003_\tIC\u0001\u0004GkR,(/\u001a\t\u0007\u0003g\ti$a\u0011\u000f\t\u0005U\u0012\u0011\b\b\u0004'\u0006]\u0012\"A\u001a\n\u0007\u0005m\"'A\u0004qC\u000e\\\u0017mZ3\n\t\u0005}\u0012\u0011\t\u0002\u0005\u0019&\u001cHOC\u0002\u0002<I\u0002B!!\u0012\u0002R5\u0011\u0011q\t\u0006\u0004G\u0005%#\u0002BA&\u0003\u001b\n1!\u00199j\u0015\r\ty\u0005K\u0001\u0007K:<\u0017N\\3\n\t\u0005M\u0013q\t\u0002\u0015\t\u0016\u0004Hn\\=fIN\u001bWM\\1sS>$\u0015\r^1\t\u000f\u0005]#\u0002q\u0001\u0002Z\u0005\u0011Qm\u0019\t\u0005\u0003O\tY&\u0003\u0003\u0002^\u0005%\"\u0001E#yK\u000e,H/[8o\u0007>tG/\u001a=u\u0011\u001d\t\tG\u0003a\u0001\u0003G\na\u0002\u001d:pG\u0016\u001c8/\u001b8h)f\u0004X\r\u0005\u0003\u0002f\u0005\re\u0002BA4\u0003\u007frA!!\u001b\u0002|9!\u00111NA<\u001d\u0011\ti'!\u001e\u000f\t\u0005=\u00141\u000f\b\u0004'\u0006E\u0014\"A\u0017\n\u0005-b\u0013BA\u0015+\u0013\r\tI\bK\u0001\ne\u0016\u001cH/\\8eK2L1!JA?\u0015\r\tI\bK\u0005\u0005\u0003w\t\tIC\u0002&\u0003{JA!!\"\u0002\b\nq\u0001K]8dKN\u001c\u0018N\\4UsB,'\u0002BA\u001e\u0003\u0003\u000bQbY1oG\u0016d\u0007K]8dKN\u001cHCBAG\u0003W\u000b9\f\u0006\u0004\u0002\u0010\u0006]\u0015\u0011\u0016\t\u0007\u0003O\ti#!%\u0011\u0007E\n\u0019*C\u0002\u0002\u0016J\u0012A!\u00168ji\"9\u0011\u0011T\u0006A\u0004\u0005m\u0015\u0001B;tKJ\u0004B!!(\u0002&6\u0011\u0011q\u0014\u0006\u0005\u0003\u0017\n\tKC\u0002\u0002$\u001a\n\u0001b]3dkJLG/_\u0005\u0005\u0003O\u000byJ\u0001\u0006M_\u001e<W\rZ+tKJDq!a\u0016\f\u0001\b\tI\u0006C\u0004\u0002..\u0001\r!a,\u0002\u0013A\u0014xnY3tg&#\u0007\u0003BAY\u0003gk!!!!\n\t\u0005U\u0016\u0011\u0011\u0002\u0012!J|7-Z:t\u0013\u0012<\u0016\u000e\u001e5OC6,\u0007bBA]\u0017\u0001\u0007\u00111X\u0001\u0012I\u0016\u0004Hn\\=nK:$8i\\7nK:$\b#B\u0019\u0002>\u0006\u0005\u0017bAA`e\t1q\n\u001d;j_:\u00042ASAb\u0013\r\t)m\u0013\u0002\u0012\t\u0016\u0004Hn\\=nK:$8i\\7nK:$\u0018A\u00053fa2|\u0017\u0010\u0015:pG\u0016\u001c8/Q:z]\u000e$\u0002\"a3\u0002b\u0006\u0015\u00181 \u000b\u0007\u0003\u001b\fi.a8\u0011\r\u0005\u001d\u0012QFAh!\u0019\t9#!\f\u0002RB)\u0011'!0\u0002TB!\u0011Q[Am\u001b\t\t9NC\u0002$\u0003\u001bJA!a7\u0002X\n!R\t\u001f;fe:\fG\u000eR3qY>LX.\u001a8u\u0013\u0012Dq!!'\r\u0001\b\tY\nC\u0004\u0002X1\u0001\u001d!!\u0017\t\u000f\u0005\rH\u00021\u0001\u00020\u0006\t\u0002O]8dKN\u001c\u0018\nZ,ji\"t\u0015-\\3\t\u000f\u0005\u001dH\u00021\u0001\u0002j\u0006i1/\u0019<fa>Lg\u000e\u001e)bi\"\u0004R!MA_\u0003W\u0004B!!<\u0002v:!\u0011q^Ay!\t\u0019&'C\u0002\u0002tJ\na\u0001\u0015:fI\u00164\u0017\u0002BA|\u0003s\u0014aa\u0015;sS:<'bAAze!9\u0011\u0011\u0018\u0007A\u0002\u0005m\u0016\u0001\u0006<bY&$\u0017\r^3CK\u001a|'/\u001a#fa2|\u0017\u0010\u0006\u0004\u0003\u0002\t%!q\u0005\u000b\u0007\u0005\u0007\u0011)Aa\u0002\u0011\r\u0005\u001d\u0012QFA\"\u0011\u001d\tI*\u0004a\u0002\u00037Cq!a\u0016\u000e\u0001\b\tI\u0006C\u0004\u0003\f5\u0001\rA!\u0004\u0002\u001dA\u0014xnY3tg\u0012+G/Y5mgB1!q\u0002B\u000b\u00057qA!!\u001b\u0003\u0012%!!1CA?\u00039\u0001(o\\2fgN$W\r^1jYNLAAa\u0006\u0003\u001a\t\u0011\")Y:f!J|7-Z:t\t\u0016$\u0018-\u001b7t\u0015\u0011\u0011\u0019\"! \u0011\t\tu!1E\u0007\u0003\u0005?QAA!\t\u0002N\u0005q1-\u00198p]&\u001c\u0017\r\\4sCBD\u0017\u0002\u0002B\u0013\u0005?\u0011\u0001cQ1o_:L7-\u00197Qe>\u001cWm]:\t\u000f\t%R\u00021\u0001\u0003,\u0005A\u0011m\u0019;j_:LE\r\u0005\u0003\u0003.\tURB\u0001B\u0018\u0015\u0011\u0011\tDa\r\u0002\r\u0015tG/\u001b;z\u0015\t9f%\u0003\u0003\u00038\t=\"a\u0004)s_\u000e,7o]!di&|g.\u00133\u0002\u001fY\fG.\u001b3bi\u0016\u0004&o\\2fgN$B!!%\u0003>!9!1\u0002\bA\u0002\t5\u0011aK2iK\u000e\\7)\u00198QKJ4wN]7BGRLwN\\!oI\u0006#G-\u00138Qe><'/Z:t\u0003\u000e$\u0018n\u001c8\u0016\t\t\r#Q\u000b\u000b\u000b\u0005\u000b\u0012\u0019Ia#\u0003*\nMF\u0003\u0003B$\u0005k\u0012yH!!\u0011\r\u0005\u001d\u0012Q\u0006B%!-\t$1\nB(\u0005W\u00119Ga\u001d\n\u0007\t5#G\u0001\u0004UkBdW\r\u000e\t\u0007\u0005\u001f\u0011)B!\u0015\u0011\t\tM#Q\u000b\u0007\u0001\t\u001d\u00119f\u0004b\u0001\u00053\u0012!\u0001U*\u0012\t\tm#\u0011\r\t\u0004c\tu\u0013b\u0001B0e\t9aj\u001c;iS:<\u0007cA\u0019\u0003d%\u0019!Q\r\u001a\u0003\u0007\u0005s\u0017\u0010E\u00032\u0003{\u0013I\u0007\u0005\u0003\u0003l\t=TB\u0001B7\u0015\r)\u0013\u0011J\u0005\u0005\u0005c\u0012iGA\u0005WKJ\u001c\u0018n\u001c8JIB)\u0011'!0\u0002d!I!qO\b\u0002\u0002\u0003\u000f!\u0011P\u0001\u000bKZLG-\u001a8dK\u0012\n\u0004C\u0002B\b\u0005w\u0012\t&\u0003\u0003\u0003~\te!!\u0007)s_\u000e,7o]*iCB,g)\u001a;dQN#(/\u0019;fOfDq!!'\u0010\u0001\b\tY\nC\u0004\u0002X=\u0001\u001d!!\u0017\t\u000f\u00055v\u00021\u0001\u0003\u0006B!!1\u000eBD\u0013\u0011\u0011II!\u001c\u0003\u0013A\u0013xnY3tg&#\u0007b\u0002BG\u001f\u0001\u0007!qR\u0001\u000bC\u000e$\u0018n\u001c8UsB,\u0007\u0003\u0002BI\u0005GsAAa%\u0003 :!!Q\u0013BO\u001d\u0011\u00119Ja'\u000f\t\u0005-$\u0011T\u0005\u0004\u0003\u001fB\u0013\u0002BA&\u0003\u001bJ1aIA%\u0013\u0011\u0011\t+a\u0012\u0002#A\u0013xnY3tg\u0006\u001bG/[8o)f\u0004X-\u0003\u0003\u0003&\n\u001d&!\u0005)s_\u000e,7o]!di&|g\u000eV=qK*!!\u0011UA$\u0011\u001d\u0011Yk\u0004a\u0001\u0005[\u000bQdZ3u-\u0016\u00148/[8o\u001f:<\u0006.[2i\u0003\u000e$\u0018n\u001c8Jg\u0012{g.\u001a\t\bc\t=&q\nB4\u0013\r\u0011\tL\r\u0002\n\rVt7\r^5p]FBqA!.\u0010\u0001\u0004\u00119,\u0001\u000ehKR\u0014U/\u001b7e\u0013:4w\u000e\u0015:pG\u0016\u001c8/\u001b8h)f\u0004X\rE\u00042\u0005_\u0013yEa\u001d\u00025\rDWmY6J]B\u0013xn\u001a:fgN<\u0016\u000e\u001e5M_\u000e\\\u0017N\\4\u0016\t\tu&1\u001a\u000b\u000b\u0005\u007f\u0013\tN!6\u0003X\nmG\u0003\u0003Ba\u0005\u0007\u0014iMa4\u0011\r\u0005\u001d\u0012Q\u0006B\u0016\u0011%\u0011)\rEA\u0001\u0002\b\u00119-\u0001\u0006fm&$WM\\2fII\u0002bAa\u0004\u0003|\t%\u0007\u0003\u0002B*\u0005\u0017$qAa\u0016\u0011\u0005\u0004\u0011I\u0006C\u0004\u0002\u001aB\u0001\u001d!a'\t\u000f\u0005]\u0003\u0003q\u0001\u0002Z!9!1\u0002\tA\u0002\tM\u0007C\u0002B\b\u0005+\u0011I\rC\u0004\u0003\u000eB\u0001\rAa$\t\u000f\te\u0007\u00031\u0001\u0003h\u0005Qb/\u001a:tS>twJ\\,iS\u000eD\u0017i\u0019;j_:L5\u000fR8oK\"9!Q\u001c\tA\u0002\tM\u0014a\u00062vS2$\u0017J\u001c4p!J|7-Z:t\u0013:<G+\u001f9f\u0003\u0001\u001a\u0007.Z2l\u0013\u001a\u001c\u0015M\u001c)fe\u001a|'/\\!di&|gn\u00148Qe>\u001cWm]:\u0016\t\t\r(q\u001e\u000b\u0007\u0005K\u0014\tPa=\u0015\t\u0005E%q\u001d\u0005\n\u0005S\f\u0012\u0011!a\u0002\u0005W\f!\"\u001a<jI\u0016t7-\u001a\u00134!\u0019\u0011yAa\u001f\u0003nB!!1\u000bBx\t\u001d\u00119&\u0005b\u0001\u00053BqA!$\u0012\u0001\u0004\u0011y\tC\u0004\u0003\fE\u0001\rA!>\u0011\r\t=!Q\u0003Bw\u0003y\u0019\u0007.Z2l\u0013\u001a\u001c\u0015M\u001c)fe\u001a|'/\\!di&|g.\u00138Ti\u0006$X-\u0006\u0003\u0003|\u000e\u001dA\u0003\u0003B\u007f\u0007\u0013\u0019Yaa\u0004\u0015\t\u0005E%q \u0005\n\u0007\u0003\u0011\u0012\u0011!a\u0002\u0007\u0007\t!\"\u001a<jI\u0016t7-\u001a\u00135!\u0019\u0011yAa\u001f\u0004\u0006A!!1KB\u0004\t\u001d\u00119F\u0005b\u0001\u00053BqA!$\u0013\u0001\u0004\u0011y\tC\u0004\u0003\fI\u0001\ra!\u0004\u0011\r\t=!QCB\u0003\u0011\u001d\u0019\tB\u0005a\u0001\u0007'\t!\u0001]:\u0011\t\u0005\u00153QC\u0005\u0005\u0007/\t9E\u0001\u0007Qe>\u001cWm]:Ti\u0006$X-A\u000bqe\u0016\u0004\u0018M]3EKBdw._7f]R$\u0015\r^1\u0015\r\ru11EB\u0016!\u0011\t)na\b\n\t\r\u0005\u0012q\u001b\u0002\u000f\t\u0016\u0004Hn\\=nK:$H)\u0019;b\u0011\u001d\tIj\u0005a\u0001\u0007K\u0001B!!6\u0004(%!1\u0011FAl\u0005\u0011)6/\u001a:\t\u000f\r52\u00031\u0001\u00040\u0005aA-\u001a9m_flWM\u001c;JIB!\u0011Q[B\u0019\u0013\u0011\u0019\u0019$a6\u0003\u0019\u0011+\u0007\u000f\\8z[\u0016tG/\u00133\u0002II,h\u000eR3qY>LX.\u001a8u\u0003\u000e$\u0018n\u001c8XSRDgj\u001c;jM&\u001c\u0017\r^5p]N,Ba!\u000f\u0004DQq11HB+\u0007/\u001aIfa\u0017\u0004`\r\u0005D\u0003BB\u001f\u0007\u0017\"baa\u0010\u0004H\r%\u0003CBA\u0014\u0003[\u0019\t\u0005\u0005\u0003\u0003T\r\rCaBB#)\t\u0007!\u0011\f\u0002\u0002)\"9\u0011\u0011\u0014\u000bA\u0004\u0005m\u0005bBA,)\u0001\u000f\u0011\u0011\f\u0005\t\u0007\u001b\"B\u00111\u0001\u0004P\u0005I!/\u001e8BGRLwN\u001c\t\u0006c\rE3qH\u0005\u0004\u0007'\u0012$\u0001\u0003\u001fcs:\fW.\u001a \t\u000f\t5E\u00031\u0001\u0003\u0010\"9!\u0011\u0006\u000bA\u0002\t-\u0002bBAr)\u0001\u0007\u0011q\u0016\u0005\b\u0007;\"\u0002\u0019\u0001B4\u0003u1XM]:j_:|en\u00165jG\"\f5\r^5p]&\u001bHi\u001c8f\u001fB$\bbBA])\u0001\u0007\u00111\u0018\u0005\b\u0005;$\u0002\u0019\u0001B:\u0003=9W\r\u001e)s_\u000e,7o]*uCR,G\u0003BB4\u0007_\"ba!\u001b\u0004l\r5\u0004CBA\u0014\u0003[\u0019\u0019\u0002C\u0004\u0002\u001aV\u0001\u001d!a'\t\u000f\u0005]S\u0003q\u0001\u0002Z!9\u00111]\u000bA\u0002\u0005=\u0016aF4fi&sG/\u001a:oC2\u0004&o\\2fgN\u001cF/\u0019;f)\u0011\u0019)ha\u001f\u0015\r\r%4qOB=\u0011\u001d\tIJ\u0006a\u0002\u00037Cq!a\u0016\u0017\u0001\b\tI\u0006C\u0004\u0003\fY\u0001\ra! 1\t\r}41\u0011\t\u0007\u0005\u001f\u0011)b!!\u0011\t\tM31\u0011\u0003\r\u0007\u000b\u001bY(!A\u0001\u0002\u000b\u0005!\u0011\f\u0002\u0004?\u0012\nDCBBE\u0007/\u001b\u0019\u000b\u0006\u0003\u0004\f\u000eEE\u0003BBG\u0007\u001f\u0003B\u0001\u00150\u0004\u0014!9\u0011qK\fA\u0004\u0005e\u0003\u0002CBJ/\u0011\u0005\ra!&\u0002C\rDWmY6Ti\u0006$Xm\u00165f]:{\u0017J\u001c)s_\u001e\u0014Xm]:BGRLwN\\:\u0011\u000bE\u001a\tf!$\t\u000f\t-q\u00031\u0001\u0004\u001aB\"11TBP!\u0019\u0011yA!\u0006\u0004\u001eB!!1KBP\t1\u0019\tka&\u0002\u0002\u0003\u0005)\u0011\u0001B-\u0005\ryFE\r\u0005\b\u0007K;\u0002\u0019ABT\u0003UIg\u000e\u0015:pOJ,7o]!di&|g\u000eV=qKN\u0004b!!<\u0004*\n=\u0015\u0002BBV\u0003s\u00141aU3u\u0003u\u0019\u0007.Z2l'R\fG/Z%o\t\u0016\u0004Hn\\=nK:$X*\u00198bO\u0016\u0014H\u0003BBY\u0007k#Ba!$\u00044\"9\u0011q\u000b\rA\u0004\u0005e\u0003b\u0002B\u00061\u0001\u00071q\u0017\u0019\u0005\u0007s\u001bi\f\u0005\u0004\u0003\u0010\tU11\u0018\t\u0005\u0005'\u001ai\f\u0002\u0007\u0004@\u000eU\u0016\u0011!A\u0001\u0006\u0003\u0011IFA\u0002`IM\na\u0003\u001d:pG\u0016\u001c8\u000fR1uC\u0016C\u0018n\u001d;Pe\u001a\u000b\u0017\u000e\\\u000b\u0005\u0007\u000b\u001cY\r\u0006\u0004\u0004H\u000e571\u001b\t\u0005!z\u001bI\r\u0005\u0003\u0003T\r-GaBB#3\t\u0007!\u0011\f\u0005\b\u0007\u001fL\u0002\u0019ABi\u00031i\u0017-\u001f2f!J|7-Z:t!\u0015\t\u0014QXBe\u0011\u001d\ti+\u0007a\u0001\u0005\u000b\u000b!cZ3u'R\fG/\u001a$s_6,enZ5oKR11\u0011\\Bq\u0007W$Baa7\u0004`B1\u0011qEA\u0017\u0007;\u0004R!MA_\u0007'Aq!a\u0016\u001b\u0001\b\tI\u0006C\u0004\u0004dj\u0001\ra!:\u0002#\u0011,\u0007\u000f\\8z[\u0016tG/T1oC\u001e,'\u000f\u0005\u0003\u0002F\r\u001d\u0018\u0002BBu\u0003\u000f\u0012\u0011\u0003R3qY>LX.\u001a8u\u001b\u0006t\u0017mZ3s\u0011\u001d\t\u0019O\u0007a\u0001\u0003_\u000bQ\u0003[1oI2,g)\u001b8jg\",G\r\u0015:pG\u0016\u001c8\u000f\u0006\u0004\u0004r\u000e}H1\u0002\u000b\u0005\u0007g\u001ci\u0010\u0005\u0003Q=\u000eU\b#B\u0019\u0002>\u000e]\b\u0003\u0002B\b\u0007sLAaa?\u0003\u001a\ti\u0001K]8dKN\u001c\u0018i\u0019;j_:Dq!a\u0016\u001c\u0001\b\tI\u0006C\u0004\u0003\fm\u0001\r\u0001\"\u00011\t\u0011\rAq\u0001\t\u0007\u0005\u001f\u0011)\u0002\"\u0002\u0011\t\tMCq\u0001\u0003\r\t\u0013\u0019y0!A\u0001\u0002\u000b\u0005!\u0011\f\u0002\u0004?\u0012\"\u0004b\u0002C\u00077\u0001\u00071Q\\\u0001\raJ|7-Z:t'R\fG/Z\u0001\u001cS:4\u0018\r\\5eCR,\u0017J\u001c)s_\u001e\u0014Xm]:BGRLwN\\:\u0015\u0005\u0005E\u0015!\u0006#fa2|\u00170\\3oiN+'O^5dK&k\u0007\u000f\u001c\t\u0003oy\u0019\"A\b\u0019\u0015\u0005\u0011U\u0011a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$\u0003(\u0006\u0002\u0005 )\u001aA\u0010\"\t,\u0005\u0011\r\u0002\u0003\u0002C\u0013\t_i!\u0001b\n\u000b\t\u0011%B1F\u0001\nk:\u001c\u0007.Z2lK\u0012T1\u0001\"\f3\u0003)\tgN\\8uCRLwN\\\u0005\u0005\tc!9CA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\u0004")
public class DeploymentServiceImpl
implements DeploymentService,
LazyLogging {
    private final DeploymentManagerDispatcher dispatcher;
    private final FetchingProcessRepository<DBIOAction> processRepository;
    private final DbProcessActionRepository<DBIOAction> actionRepository;
    private final DBIOActionRunner dbioRunner;
    private final ProcessValidation processValidation;
    private final ScenarioResolver scenarioResolver;
    private final ProcessChangeListener processChangeListener;
    private final Clock clock;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static Clock $lessinit$greater$default$8() {
        return DeploymentServiceImpl$.MODULE$.$lessinit$greater$default$8();
    }

    private Logger logger$lzycompute() {
        DeploymentServiceImpl deploymentServiceImpl = this;
        synchronized (deploymentServiceImpl) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    @Override
    public Future<List<DeployedScenarioData>> getDeployedScenarios(String processingType, ExecutionContext ec) {
        NussknackerInternalUser$ userFetchingDataFromRepository = NussknackerInternalUser$.MODULE$;
        Some x$1 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Some x$2 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)false));
        Some x$3 = new Some((Object)BoxesRunTime.boxToBoolean((boolean)true));
        Some x$4 = new Some((Object)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{processingType})));
        Option<Seq<String>> x$5 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$4();
        Option<Seq<ProcessName>> x$6 = FetchingProcessRepository$FetchProcessesDetailsQuery$.MODULE$.apply$default$6();
        return this.dbioRunner.run(this.processRepository.fetchProcessesDetails(new FetchingProcessRepository.FetchProcessesDetailsQuery((Option<Object>)x$1, (Option<Object>)x$2, (Option<Object>)x$3, x$5, (Option<Seq<String>>)x$4, x$6), processdetails.ProcessShapeFetchStrategy$.FetchCanonical$.MODULE$, (LoggedUser)userFetchingDataFromRepository, ec)).flatMap((Function1 & Serializable & scala.Serializable)deployedProcesses -> Future$.MODULE$.sequence((TraversableOnce)deployedProcesses.flatMap((Function1 & Serializable & scala.Serializable)details -> {
            Iterable iterable;
            processdetails.ProcessAction lastDeployAction = (processdetails.ProcessAction)details.lastDeployedAction().get();
            User deployingUser = new User(lastDeployAction.user(), lastDeployAction.user());
            DeploymentData deploymentData = this.prepareDeploymentData(deployingUser, "");
            Try deployedScenarioDataTry = $this.scenarioResolver.resolveScenario((CanonicalProcess)details.json(), details.processCategory()).map((Function1 & Serializable & scala.Serializable)resolvedScenario -> new DeployedScenarioData(details.toEngineProcessVersion(), deploymentData, resolvedScenario));
            Try try_ = deployedScenarioDataTry;
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable exception = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(45).append("Exception during resolving deployed scenario ").append(details.id()).toString(), exception);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                iterable = Option$.MODULE$.option2Iterable((Option)None$.MODULE$);
            } else if (try_ instanceof Success) {
                Success success = (Success)try_;
                DeployedScenarioData value = (DeployedScenarioData)success.value();
                iterable = Option$.MODULE$.option2Iterable((Option)new Some((Object)Future$.MODULE$.successful((Object)value)));
            } else {
                throw new MatchError((Object)try_);
            }
            return iterable;
        }, List$.MODULE$.canBuildFrom()), List$.MODULE$.canBuildFrom(), ec).map((Function1 & Serializable & scala.Serializable)dataList -> dataList, ec), ec);
    }

    @Override
    public Future<BoxedUnit> cancelProcess(ProcessIdWithName processId, Option<DeploymentComment> deploymentComment, LoggedUser user, ExecutionContext ec) {
        Enumeration.Value actionType = ProcessActionType$.MODULE$.Cancel();
        return this.checkCanPerformActionAndAddInProgressAction(processId.id(), actionType, (Function1)(Function1 & Serializable & scala.Serializable)x$1 -> x$1.lastDeployedAction().map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.processVersionId()), (Function1)(Function1 & Serializable & scala.Serializable)x$3 -> None$.MODULE$, (processdetails.ProcessShapeFetchStrategy)processdetails.ProcessShapeFetchStrategy$.NotFetch$.MODULE$, user, ec).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            processdetails.BaseProcessDetails processDetails = (processdetails.BaseProcessDetails)tuple4._1();
            ProcessActionId actionId = (ProcessActionId)tuple4._2();
            Option versionOnWhichActionIsDone = (Option)tuple4._3();
            Option buildInfoProcessIngType = (Option)tuple4._4();
            Future future = this.runDeploymentActionWithNotifications(actionType, actionId, processId, (Option<VersionId>)versionOnWhichActionIsDone, deploymentComment, (Option<String>)buildInfoProcessIngType, (Function0 & Serializable & scala.Serializable)() -> $this.dispatcher.deploymentManager(processDetails.processingType()).cancel(processId.name(), LoggedUserConversions$.MODULE$.LoggedUserOps(user).toManagerUser()), user, ec);
            return future;
        }, ec);
    }

    @Override
    public Future<Future<Option<ExternalDeploymentId>>> deployProcessAsync(ProcessIdWithName processIdWithName, Option<String> savepointPath, Option<DeploymentComment> deploymentComment, LoggedUser user, ExecutionContext ec) {
        Enumeration.Value actionType = ProcessActionType$.MODULE$.Deploy();
        return this.checkCanPerformActionAndAddInProgressAction(processIdWithName.id(), actionType, (Function1)(Function1 & Serializable & scala.Serializable)d -> new Some((Object)d.processVersionId()), (Function1)(Function1 & Serializable & scala.Serializable)d -> new Some((Object)d.processingType()), (processdetails.ProcessShapeFetchStrategy)processdetails.ProcessShapeFetchStrategy$.FetchCanonical$.MODULE$, user, ec).flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple4 tuple4 = x0$1;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            processdetails.BaseProcessDetails processDetails = (processdetails.BaseProcessDetails)tuple4._1();
            ProcessActionId actionId = (ProcessActionId)tuple4._2();
            Option versionOnWhichActionIsDone = (Option)tuple4._3();
            Option buildInfoProcessIngType = (Option)tuple4._4();
            Future future = this.validateBeforeDeploy((processdetails.BaseProcessDetails<CanonicalProcess>)processDetails, actionId, user, ec).transformWith((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Future future;
                Try try_ = x0$2;
                if (try_ instanceof Failure) {
                    Failure failure = (Failure)try_;
                    Throwable ex = failure.exception();
                    future = $this.dbioRunner.runInTransaction($this.actionRepository.removeAction(actionId)).transform((Function1 & Serializable & scala.Serializable)x$4 -> new Failure(ex), ec);
                } else if (try_ instanceof Success) {
                    Success success = (Success)try_;
                    DeployedScenarioData validationResult = (DeployedScenarioData)success.value();
                    Future deploymentFuture = this.runDeploymentActionWithNotifications(actionType, actionId, processIdWithName, (Option<VersionId>)versionOnWhichActionIsDone, deploymentComment, (Option<String>)buildInfoProcessIngType, (Function0 & Serializable & scala.Serializable)() -> $this.dispatcher.deploymentManager(processDetails.processingType()).deploy(validationResult.processVersion(), validationResult.deploymentData(), validationResult.resolvedScenario(), savepointPath), user, ec);
                    future = Future$.MODULE$.successful(deploymentFuture);
                } else {
                    throw new MatchError((Object)try_);
                }
                return future;
            }, ec);
            return future;
        }, ec);
    }

    public Future<DeployedScenarioData> validateBeforeDeploy(processdetails.BaseProcessDetails<CanonicalProcess> processDetails, ProcessActionId actionId, LoggedUser user, ExecutionContext ec) {
        this.validateProcess(processDetails);
        DeploymentManager deploymentManager = this.dispatcher.deploymentManager(processDetails.processingType());
        return Future$.MODULE$.fromTry(this.scenarioResolver.resolveScenario((CanonicalProcess)processDetails.json(), processDetails.processCategory())).map((Function1 & Serializable & scala.Serializable)resolvedCanonicalProcess -> {
            DeploymentData deploymentData = this.prepareDeploymentData(LoggedUserConversions$.MODULE$.LoggedUserOps(user).toManagerUser(), actionId.value().toString());
            return new Tuple2(resolvedCanonicalProcess, (Object)deploymentData);
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$5 -> {
            Tuple2 tuple2 = x$5;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            CanonicalProcess resolvedCanonicalProcess = (CanonicalProcess)tuple2._1();
            DeploymentData deploymentData = (DeploymentData)tuple2._2();
            Future future = deploymentManager.validate(processDetails.toEngineProcessVersion(), deploymentData, resolvedCanonicalProcess).map((Function1 & Serializable & scala.Serializable)_ -> new DeployedScenarioData(processDetails.toEngineProcessVersion(), deploymentData, resolvedCanonicalProcess), ec);
            return future;
        }, ec);
    }

    private void validateProcess(processdetails.BaseProcessDetails<CanonicalProcess> processDetails) {
        ValidationResults.ValidationResult validationResult = this.processValidation.processingTypeValidationWithTypingInfo((CanonicalProcess)processDetails.json(), processDetails.processingType(), processDetails.processCategory());
        if (validationResult.hasErrors()) {
            throw DeployingInvalidScenarioError$.MODULE$;
        }
    }

    private <PS> Future<Tuple4<processdetails.BaseProcessDetails<PS>, ProcessActionId, Option<VersionId>, Option<String>>> checkCanPerformActionAndAddInProgressAction(ProcessId processId, Enumeration.Value actionType, Function1<processdetails.BaseProcessDetails<PS>, Option<VersionId>> getVersionOnWhichActionIsDone, Function1<processdetails.BaseProcessDetails<PS>, Option<String>> getBuildInfoProcessingType, processdetails.ProcessShapeFetchStrategy<PS> evidence$1, LoggedUser user, ExecutionContext ec) {
        return this.dbioRunner.run(this.processRepository.fetchLatestProcessDetailsForProcessId(processId, evidence$1, user, ec)).flatMap((Function1 & Serializable & scala.Serializable)processDetailsOpt -> $this.dbioRunner.run(this.processDataExistOrFail((Option)processDetailsOpt, processId)).map((Function1 & Serializable & scala.Serializable)processDetails -> {
            this.checkIfCanPerformActionOnProcess(actionType, (processdetails.BaseProcessDetails)processDetails, evidence$1);
            BoxedUnit x$6 = BoxedUnit.UNIT;
            Option versionOnWhichActionIsDone = (Option)getVersionOnWhichActionIsDone.apply(processDetails);
            Option buildInfoProcessIngType = (Option)getBuildInfoProcessingType.apply(processDetails);
            return new Tuple4(processDetails, (Object)x$6, (Object)versionOnWhichActionIsDone, (Object)buildInfoProcessIngType);
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$7 -> {
            Tuple4 tuple4 = x$7;
            if (tuple4 == null) {
                throw new MatchError((Object)tuple4);
            }
            processdetails.BaseProcessDetails processDetails = (processdetails.BaseProcessDetails)tuple4._1();
            Option versionOnWhichActionIsDone = (Option)tuple4._3();
            Option buildInfoProcessIngType = (Option)tuple4._4();
            Future future = this.checkInProgressWithLocking(processDetails, actionType, (Option<VersionId>)versionOnWhichActionIsDone, (Option<String>)buildInfoProcessIngType, evidence$1, user, ec).map((Function1 & Serializable & scala.Serializable)actionId -> new Tuple4((Object)processDetails, actionId, (Object)versionOnWhichActionIsDone, (Object)buildInfoProcessIngType), ec);
            return future;
        }, ec), ec);
    }

    private <PS> Future<ProcessActionId> checkInProgressWithLocking(processdetails.BaseProcessDetails<PS> processDetails, Enumeration.Value actionType, Option<VersionId> versionOnWhichActionIsDone, Option<String> buildInfoProcessIngType, processdetails.ProcessShapeFetchStrategy<PS> evidence$2, LoggedUser user, ExecutionContext ec) {
        return this.dbioRunner.runInTransaction(this.actionRepository.lockActionsTable().flatMap((Function1 & Serializable & scala.Serializable)_ -> $this.actionRepository.getInProgressActionTypes(processDetails.processId()).flatMap((Function1 & Serializable & scala.Serializable)inProgressActionTypes -> this.getProcessState(processDetails, (Set<Enumeration.Value>)inProgressActionTypes, (Function0<DBIOAction<ProcessState, NoStream, Effect.All>>)(Function0 & Serializable & scala.Serializable)() -> this.checkStateInDeploymentManager(processDetails, ec), ec).map((Function1 & Serializable & scala.Serializable)processState -> {
            this.checkIfCanPerformActionInState(actionType, processDetails, (ProcessState)processState, evidence$2);
            BoxedUnit x$8 = BoxedUnit.UNIT;
            return new Tuple2(processState, (Object)x$8);
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> {
            Tuple2 tuple2 = x$9;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            DBIOAction dBIOAction = $this.actionRepository.addInProgressAction(processDetails.processId(), actionType, versionOnWhichActionIsDone, buildInfoProcessIngType, user).map((Function1 & Serializable & scala.Serializable)actionId -> actionId, ec);
            return dBIOAction;
        }, ec), ec), ec));
    }

    private <PS> void checkIfCanPerformActionOnProcess(Enumeration.Value actionType, processdetails.BaseProcessDetails<PS> processDetails, processdetails.ProcessShapeFetchStrategy<PS> evidence$3) {
        if (processDetails.isArchived()) {
            throw ProcessIllegalAction$.MODULE$.archived(actionType, processDetails.idWithName());
        }
        if (processDetails.isSubprocess()) {
            throw ProcessIllegalAction$.MODULE$.subprocess(actionType, processDetails.idWithName());
        }
    }

    private <PS> void checkIfCanPerformActionInState(Enumeration.Value actionType, processdetails.BaseProcessDetails<PS> processDetails, ProcessState ps, processdetails.ProcessShapeFetchStrategy<PS> evidence$4) {
        if (!ps.allowedActions().contains((Object)actionType)) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Action: {} on process: {} not allowed in {} state", new Object[]{actionType, processDetails.name(), ps.status()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            throw ProcessIllegalAction$.MODULE$.apply(actionType, processDetails.idWithName(), ps);
        }
    }

    public DeploymentData prepareDeploymentData(User user, String deploymentId) {
        return new DeploymentData(deploymentId, user, Predef$.MODULE$.Map().empty());
    }

    private <T> Future<T> runDeploymentActionWithNotifications(Enumeration.Value actionType, ProcessActionId actionId, ProcessIdWithName processIdWithName, Option<VersionId> versionOnWhichActionIsDoneOpt, Option<DeploymentComment> deploymentComment, Option<String> buildInfoProcessIngType, Function0<Future<T>> runAction, LoggedUser user, ExecutionContext ec) {
        pl.touk.nussknacker.ui.listener.User listenerUser = ListenerApiUser$.MODULE$.apply(user);
        Future actionFuture = (Future)runAction.apply();
        String actionString = new StringBuilder(11).append(actionType.toString().toLowerCase()).append(" (id: ").append(actionId.value()).append(") of ").append(processIdWithName.name()).toString();
        return actionFuture.transformWith((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Future future;
            Try try_ = x0$1;
            if (try_ instanceof Failure) {
                BoxedUnit boxedUnit;
                Failure failure = (Failure)try_;
                Throwable failure2 = failure.exception();
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error(new StringBuilder(30).append("Action: ").append(actionString).append(" finished with failure").toString(), failure2);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                Instant performedAt = $this.clock.instant();
                $this.processChangeListener.handle((ProcessChangeEvent)new ProcessChangeEvent.OnDeployActionFailed(processIdWithName.id(), failure2), ec, listenerUser);
                future = $this.dbioRunner.runInTransaction($this.actionRepository.markActionAsFailed(actionId, processIdWithName.id(), actionType, versionOnWhichActionIsDoneOpt, performedAt, failure2.getMessage(), buildInfoProcessIngType, user)).transform((Function1 & Serializable & scala.Serializable)x$10 -> new Failure(failure2), ec);
            } else if (try_ instanceof Success) {
                Success success = (Success)try_;
                Object result = success.value();
                future = ((Future)versionOnWhichActionIsDoneOpt.map((Function1 & Serializable & scala.Serializable)versionOnWhichActionIsDone -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Finishing {}", new Object[]{actionString});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    Instant performedAt = $this.clock.instant();
                    Option comment = deploymentComment.map((Function1 & Serializable & scala.Serializable)x$11 -> x$11.toComment(actionType));
                    $this.processChangeListener.handle((ProcessChangeEvent)new ProcessChangeEvent.OnDeployActionSuccess(processIdWithName.id(), versionOnWhichActionIsDone, comment, performedAt, actionType), ec, listenerUser);
                    return $this.dbioRunner.runInTransaction($this.actionRepository.markActionAsFinished(actionId, processIdWithName.id(), actionType, (VersionId)versionOnWhichActionIsDone, performedAt, (Option<Comment>)comment, buildInfoProcessIngType, user));
                }).getOrElse((Function0 & Serializable & scala.Serializable)() -> {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isInfoEnabled()) {
                        this.logger().underlying().info("Action {} finished for action without version id - skipping listener notification", new Object[]{actionString});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    return $this.dbioRunner.runInTransaction($this.actionRepository.removeAction(actionId));
                })).map((Function1 & Serializable & scala.Serializable)x$12 -> result, ec);
            } else {
                throw new MatchError((Object)try_);
            }
            return future;
        }, ec);
    }

    @Override
    public Future<ProcessState> getProcessState(ProcessIdWithName processIdWithName, LoggedUser user, ExecutionContext ec) {
        return this.dbioRunner.run(this.processRepository.fetchLatestProcessDetailsForProcessId(processIdWithName.id(), processdetails.ProcessShapeFetchStrategy$.NotFetch$.MODULE$, user, ec).flatMap((Function1 & Serializable & scala.Serializable)processDetailsOpt -> this.processDataExistOrFail((Option)processDetailsOpt, processIdWithName.id()).flatMap((Function1 & Serializable & scala.Serializable)processDetails -> $this.actionRepository.getInProgressActionTypes(processDetails.processId()).flatMap((Function1 & Serializable & scala.Serializable)inProgressActionTypes -> this.getProcessState((processdetails.BaseProcessDetails<?>)processDetails, (Set<Enumeration.Value>)inProgressActionTypes, (Function0<DBIOAction<ProcessState, NoStream, Effect.All>>)(Function0 & Serializable & scala.Serializable)() -> this.checkStateInDeploymentManager((processdetails.BaseProcessDetails<?>)processDetails, ec), ec).map((Function1 & Serializable & scala.Serializable)result -> result, ec), ec), ec), ec));
    }

    @Override
    public Future<ProcessState> getInternalProcessState(processdetails.BaseProcessDetails<?> processDetails, LoggedUser user, ExecutionContext ec) {
        return this.dbioRunner.run(this.actionRepository.getInProgressActionTypes(processDetails.processId()).flatMap((Function1 & Serializable & scala.Serializable)inProgressActionTypes -> this.getProcessState(processDetails, (Set<Enumeration.Value>)inProgressActionTypes, (Function0<DBIOAction<ProcessState, NoStream, Effect.All>>)(Function0 & Serializable & scala.Serializable)() -> {
            BoxedUnit boxedUnit;
            DeploymentManager manager = $this.dispatcher.deploymentManager(processDetails.processingType());
            StateStatus status = manager.processStateDefinitionManager().mapActionToStatus(processDetails.lastAction().map((Function1 & Serializable & scala.Serializable)x$13 -> x$13.action()));
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Status for: '{}' is: {} (last action: {})", new Object[]{processDetails.name(), status, processDetails.lastAction().map((Function1 & Serializable & scala.Serializable)x$14 -> x$14.action())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            ProcessStateDefinitionManager qual$1 = manager.processStateDefinitionManager();
            StateStatus x$1 = status;
            Option x$2 = qual$1.processState$default$2();
            Option x$3 = qual$1.processState$default$3();
            Option x$4 = qual$1.processState$default$4();
            Option x$5 = qual$1.processState$default$5();
            List x$6 = qual$1.processState$default$6();
            return DBIOAction$.MODULE$.successful((Object)qual$1.processState(x$1, x$2, x$3, x$4, x$5, x$6));
        }, ec).map((Function1 & Serializable & scala.Serializable)result -> result, ec), ec));
    }

    private DBIOAction<ProcessState, NoStream, Effect.All> getProcessState(processdetails.BaseProcessDetails<?> processDetails, Set<Enumeration.Value> inProgressActionTypes, Function0<DBIOAction<ProcessState, NoStream, Effect.All>> checkStateWhenNoInProgressActions, ExecutionContext ec) {
        DBIOAction dBIOAction;
        DeploymentManager manager = this.dispatcher.deploymentManager(processDetails.processingType());
        if (inProgressActionTypes.contains((Object)ProcessActionType$.MODULE$.Deploy())) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Status for: '{}' is: {}", new Object[]{processDetails.name(), SimpleStateStatus$.MODULE$.DuringCancel()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            ProcessStateDefinitionManager qual$1 = manager.processStateDefinitionManager();
            StateStatus x$1 = SimpleStateStatus$.MODULE$.DuringDeploy();
            Option x$2 = qual$1.processState$default$2();
            Option x$3 = qual$1.processState$default$3();
            Option x$4 = qual$1.processState$default$4();
            Option x$5 = qual$1.processState$default$5();
            List x$6 = qual$1.processState$default$6();
            dBIOAction = DBIOAction$.MODULE$.successful((Object)qual$1.processState(x$1, x$2, x$3, x$4, x$5, x$6));
        } else if (inProgressActionTypes.contains((Object)ProcessActionType$.MODULE$.Cancel())) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Status for: '{}' is: {}", new Object[]{processDetails.name(), SimpleStateStatus$.MODULE$.DuringCancel()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            ProcessStateDefinitionManager qual$2 = manager.processStateDefinitionManager();
            StateStatus x$7 = SimpleStateStatus$.MODULE$.DuringCancel();
            Option x$8 = qual$2.processState$default$2();
            Option x$9 = qual$2.processState$default$3();
            Option x$10 = qual$2.processState$default$4();
            Option x$11 = qual$2.processState$default$5();
            List x$12 = qual$2.processState$default$6();
            dBIOAction = DBIOAction$.MODULE$.successful((Object)qual$2.processState(x$7, x$8, x$9, x$10, x$11, x$12));
        } else {
            dBIOAction = (DBIOAction)checkStateWhenNoInProgressActions.apply();
        }
        return dBIOAction;
    }

    private DBIOAction<ProcessState, NoStream, Effect.All> checkStateInDeploymentManager(processdetails.BaseProcessDetails<?> processDetails, ExecutionContext ec) {
        DeploymentManager manager = this.dispatcher.deploymentManager(processDetails.processingType());
        return DBIOAction$.MODULE$.from(this.getStateFromEngine(manager, processDetails.idWithName(), ec)).flatMap((Function1 & Serializable & scala.Serializable)state -> this.handleFinishedProcess(processDetails, (Option<ProcessState>)state, ec).map((Function1 & Serializable & scala.Serializable)cancelActionOpt -> {
            BoxedUnit boxedUnit;
            Option lastAction = cancelActionOpt.orElse((Function0 & Serializable & scala.Serializable)() -> processDetails.lastAction());
            ProcessState finalState = ObsoleteStateDetector$.MODULE$.handleObsoleteStatus((Option<ProcessState>)state, (Option<processdetails.ProcessAction>)lastAction);
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Status for: '{}' is: {} (from engine: {}, last action: {})", new Object[]{processDetails.name(), finalState.status(), state.map((Function1 & Serializable & scala.Serializable)x$15 -> x$15.status()), lastAction.map((Function1 & Serializable & scala.Serializable)x$16 -> x$16.action())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return finalState;
        }, ec), ec);
    }

    private <T> DBIOAction<T, NoStream, Effect.All> processDataExistOrFail(Option<T> maybeProcess, ProcessId processId) {
        DBIOAction dBIOAction;
        Option<T> option = maybeProcess;
        if (option instanceof Some) {
            Some some = (Some)option;
            Object processData = some.value();
            dBIOAction = DBIOAction$.MODULE$.successful(processData);
        } else if (None$.MODULE$.equals(option)) {
            dBIOAction = DBIOAction$.MODULE$.failed((Throwable)new ProcessDBQueryRepository.ProcessNotFoundError(((Object)BoxesRunTime.boxToLong((long)processId.value())).toString()));
        } else {
            throw new MatchError(option);
        }
        return dBIOAction;
    }

    private Future<Option<ProcessState>> getStateFromEngine(DeploymentManager deploymentManager, ProcessIdWithName processIdWithName, ExecutionContext ec) {
        return deploymentManager.findJobStatus(processIdWithName.name()).recover((PartialFunction)new scala.Serializable(this, processIdWithName){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ DeploymentServiceImpl $outer;
            private final ProcessIdWithName processIdWithName$4;

            public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                Object object;
                A1 A1 = x1;
                Option option = NonFatal$.MODULE$.unapply(A1);
                if (!option.isEmpty()) {
                    BoxedUnit boxedUnit;
                    Throwable e = (Throwable)option.get();
                    if (this.$outer.logger().underlying().isWarnEnabled()) {
                        this.$outer.logger().underlying().warn(new StringBuilder(26).append("Failed to get status of ").append(this.processIdWithName$4).append(": ").append(e.getMessage()).toString(), e);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    object = new Some((Object)SimpleProcessStateDefinitionManager$.MODULE$.processState(SimpleStateStatus$.MODULE$.FailedToGet(), SimpleProcessStateDefinitionManager$.MODULE$.processState$default$2(), SimpleProcessStateDefinitionManager$.MODULE$.processState$default$3(), SimpleProcessStateDefinitionManager$.MODULE$.processState$default$4(), SimpleProcessStateDefinitionManager$.MODULE$.processState$default$5(), SimpleProcessStateDefinitionManager$.MODULE$.processState$default$6()));
                } else {
                    object = function1.apply(x1);
                }
                return (B1)object;
            }

            public final boolean isDefinedAt(Throwable x1) {
                Throwable throwable = x1;
                Option option = NonFatal$.MODULE$.unapply(throwable);
                boolean bl = !option.isEmpty();
                return bl;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.processIdWithName$4 = processIdWithName$4;
            }
        }, ec);
    }

    private DBIOAction<Option<processdetails.ProcessAction>, NoStream, Effect.All> handleFinishedProcess(processdetails.BaseProcessDetails<?> processDetails, Option<ProcessState> processState, ExecutionContext ec) {
        NussknackerInternalUser$ user = NussknackerInternalUser$.MODULE$;
        pl.touk.nussknacker.ui.listener.User listenerUser = ListenerApiUser$.MODULE$.apply((LoggedUser)user);
        return (DBIOAction)processState.filter((Function1 & Serializable & scala.Serializable)x$17 -> BoxesRunTime.boxToBoolean((boolean)DeploymentServiceImpl.$anonfun$handleFinishedProcess$1(x$17))).flatMap((Function1 & Serializable & scala.Serializable)x$18 -> processDetails.lastDeployedAction().map((Function1 & Serializable & scala.Serializable)lastDeployedAction -> {
            Comment finishedComment = DeploymentComment$.MODULE$.unsafe("Scenario finished").toComment(ProcessActionType$.MODULE$.Cancel());
            $this.processChangeListener.handle((ProcessChangeEvent)new ProcessChangeEvent.OnFinished(processDetails.processId(), lastDeployedAction.processVersionId()), ec, listenerUser);
            return $this.actionRepository.addInstantAction(processDetails.processId(), lastDeployedAction.processVersionId(), ProcessActionType$.MODULE$.Cancel(), (Option<Comment>)new Some((Object)finishedComment), (Option<String>)None$.MODULE$, (LoggedUser)user).map((Function1 & Serializable & scala.Serializable)a -> new Some((Object)ProcessDBQueryRepository$.MODULE$.toProcessAction((Tuple2<ProcessActionEntityData, Option<CommentEntityData>>)new Tuple2(a, (Object)None$.MODULE$))), ec);
        })).getOrElse((Function0 & Serializable & scala.Serializable)() -> DBIOAction$.MODULE$.successful((Object)None$.MODULE$));
    }

    @Override
    public void invalidateInProgressActions() {
        Await$.MODULE$.result(this.dbioRunner.run(this.actionRepository.deleteInProgressActions()), (Duration)new package.DurationInt(package$.MODULE$.DurationInt(10)).seconds());
    }

    public static final /* synthetic */ boolean $anonfun$handleFinishedProcess$1(ProcessState x$17) {
        return x$17.status().isFinished();
    }

    public DeploymentServiceImpl(DeploymentManagerDispatcher dispatcher, FetchingProcessRepository<DBIOAction> processRepository, DbProcessActionRepository<DBIOAction> actionRepository, DBIOActionRunner dbioRunner, ProcessValidation processValidation, ScenarioResolver scenarioResolver, ProcessChangeListener processChangeListener, Clock clock) {
        this.dispatcher = dispatcher;
        this.processRepository = processRepository;
        this.actionRepository = actionRepository;
        this.dbioRunner = dbioRunner;
        this.processValidation = processValidation;
        this.scenarioResolver = scenarioResolver;
        this.processChangeListener = processChangeListener;
        this.clock = clock;
        LazyLogging.$init$((LazyLogging)this);
    }
}

