/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.nussknacker.ui.process.test;

import com.carrotsearch.sizeof.RamUsageEstimator;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import pl.touk.nussknacker.engine.ModelData;
import pl.touk.nussknacker.engine.api.expression.ExpressionTypingInfo;
import pl.touk.nussknacker.engine.api.test.ScenarioTestData;
import pl.touk.nussknacker.engine.canonicalgraph.CanonicalProcess;
import pl.touk.nussknacker.engine.definition.TestInfoProvider;
import pl.touk.nussknacker.engine.definition.TestingCapabilities;
import pl.touk.nussknacker.engine.testmode.TestProcess;
import pl.touk.nussknacker.restmodel.displayedgraph.DisplayableProcess;
import pl.touk.nussknacker.restmodel.process.ProcessIdWithName;
import pl.touk.nussknacker.restmodel.validation.ValidationResults;
import pl.touk.nussknacker.ui.api.TestDataSettings;
import pl.touk.nussknacker.ui.process.deployment.ScenarioTestExecutorService;
import pl.touk.nussknacker.ui.process.processingtypedata.ProcessingTypeDataProvider;
import pl.touk.nussknacker.ui.process.test.RawScenarioTestData;
import pl.touk.nussknacker.ui.process.test.ResultsWithCounts;
import pl.touk.nussknacker.ui.process.test.ScenarioTestDataSerDe;
import pl.touk.nussknacker.ui.process.test.ScenarioTestService$;
import pl.touk.nussknacker.ui.processreport.NodeCount;
import pl.touk.nussknacker.ui.processreport.ProcessCounter;
import pl.touk.nussknacker.ui.processreport.RawCount;
import pl.touk.nussknacker.ui.security.api.LoggedUser;
import pl.touk.nussknacker.ui.uiresolving.UIProcessResolving;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Map$;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.util.Either;

@ScalaSignature(bytes="\u0006\u0001\t=r!\u0002\n\u0014\u0011\u0003\u0001c!\u0002\u0012\u0014\u0011\u0003\u0019\u0003\"\u0002\u0016\u0002\t\u0003Y\u0003\"\u0002\u0017\u0002\t\u0003ic\u0001\u0002\u0012\u0014\u0001=B\u0001B\u000f\u0003\u0003\u0002\u0003\u0006Ia\u000f\u0005\t\u0013\u0012\u0011\t\u0011)A\u0005\u0015\"A\u0001\u000b\u0002B\u0001B\u0003%\u0011\u000b\u0003\u0005U\t\t\u0005\t\u0015!\u0003V\u0011!YFA!A!\u0002\u0013a\u0006\u0002\u00032\u0005\u0005\u0003\u0005\u000b\u0011B2\t\u000b)\"A\u0011A5\t\u000bA$A\u0011A9\t\r}$A\u0011AA\u0001\u0011\u001d\ti\u0004\u0002C\u0001\u0003\u007fAq!a*\u0005\t\u0013\tI\u000bC\u0004\u0002:\u0012!I!a/\t\u000f\u0005]H\u0001\"\u0003\u0002z\u0006\u00192kY3oCJLw\u000eV3tiN+'O^5dK*\u0011A#F\u0001\u0005i\u0016\u001cHO\u0003\u0002\u0017/\u00059\u0001O]8dKN\u001c(B\u0001\r\u001a\u0003\t)\u0018N\u0003\u0002\u001b7\u0005Ya.^:tW:\f7m[3s\u0015\taR$\u0001\u0003u_V\\'\"\u0001\u0010\u0002\u0005Ad7\u0001\u0001\t\u0003C\u0005i\u0011a\u0005\u0002\u0014'\u000e,g.\u0019:j_R+7\u000f^*feZL7-Z\n\u0003\u0003\u0011\u0002\"!\n\u0015\u000e\u0003\u0019R\u0011aJ\u0001\u0006g\u000e\fG.Y\u0005\u0003S\u0019\u0012a!\u00118z%\u00164\u0017A\u0002\u001fj]&$h\bF\u0001!\u0003\u0015\t\u0007\u000f\u001d7z)-q#\u0011\u0004B\u0014\u0005S\u0011YC!\f\u0011\u0005\u0005\"1c\u0001\u0003%aA\u0011\u0011\u0007O\u0007\u0002e)\u00111\u0007N\u0001\rg\u000e\fG.\u00197pO\u001eLgn\u001a\u0006\u0003kY\n\u0001\u0002^=qKN\fg-\u001a\u0006\u0002o\u0005\u00191m\\7\n\u0005e\u0012$a\u0003'bufdunZ4j]\u001e\f\u0011\u0003^3ti&sgm\u001c)s_ZLG-\u001a:t!\rat(Q\u0007\u0002{)\u0011a(F\u0001\u0013aJ|7-Z:tS:<G/\u001f9fI\u0006$\u0018-\u0003\u0002A{\tQ\u0002K]8dKN\u001c\u0018N\\4UsB,G)\u0019;b!J|g/\u001b3feB\u0011!iR\u0007\u0002\u0007*\u0011A)R\u0001\u000bI\u00164\u0017N\\5uS>t'B\u0001$\u001a\u0003\u0019)gnZ5oK&\u0011\u0001j\u0011\u0002\u0011)\u0016\u001cH/\u00138g_B\u0013xN^5eKJ\f\u0001\u0003^3ti\u0012\u000bG/Y*fiRLgnZ:\u0011\u0005-sU\"\u0001'\u000b\u00055;\u0012aA1qS&\u0011q\n\u0014\u0002\u0011)\u0016\u001cH\u000fR1uCN+G\u000f^5oON\fQc]2f]\u0006\u0014\u0018n\u001c+fgR$\u0015\r^1TKJ$U\r\u0005\u0002\"%&\u00111k\u0005\u0002\u0016'\u000e,g.\u0019:j_R+7\u000f\u001e#bi\u0006\u001cVM\u001d#f\u0003A\u0001(o\\2fgN\u0014Vm]8mm&tw\r\u0005\u0002W36\tqK\u0003\u0002Y/\u0005YQ/\u001b:fg>dg/\u001b8h\u0013\tQvK\u0001\nV\u0013B\u0013xnY3tgJ+7o\u001c7wS:<\u0017A\u00049s_\u000e,7o]\"pk:$XM\u001d\t\u0003;\u0002l\u0011A\u0018\u0006\u0003?^\tQ\u0002\u001d:pG\u0016\u001c8O]3q_J$\u0018BA1_\u00059\u0001&o\\2fgN\u001cu.\u001e8uKJ\f1\u0003^3ti\u0016CXmY;u_J\u001cVM\u001d<jG\u0016\u0004\"\u0001Z4\u000e\u0003\u0015T!AZ\u000b\u0002\u0015\u0011,\u0007\u000f\\8z[\u0016tG/\u0003\u0002iK\nY2kY3oCJLw\u000eV3ti\u0016CXmY;u_J\u001cVM\u001d<jG\u0016$rA\f6lY6tw\u000eC\u0003;\u0017\u0001\u00071\bC\u0003J\u0017\u0001\u0007!\nC\u0003Q\u0017\u0001\u0007\u0011\u000bC\u0003U\u0017\u0001\u0007Q\u000bC\u0003\\\u0017\u0001\u0007A\fC\u0003c\u0017\u0001\u00071-\u0001\fhKR$Vm\u001d;j]\u001e\u001c\u0015\r]1cS2LG/[3t)\t\u0011X\u000f\u0005\u0002Cg&\u0011Ao\u0011\u0002\u0014)\u0016\u001cH/\u001b8h\u0007\u0006\u0004\u0018MY5mSRLWm\u001d\u0005\u0006m2\u0001\ra^\u0001\u0013I&\u001c\b\u000f\\1zC\ndW\r\u0015:pG\u0016\u001c8\u000f\u0005\u0002y{6\t\u0011P\u0003\u0002{w\u0006qA-[:qY\u0006LX\rZ4sCBD'B\u0001?\u001a\u0003%\u0011Xm\u001d;n_\u0012,G.\u0003\u0002\u007fs\n\u0011B)[:qY\u0006L\u0018M\u00197f!J|7-Z:t\u000319WM\\3sCR,G)\u0019;b)\u0019\t\u0019!!\r\u00024AA\u0011QAA\u000b\u00037\tYC\u0004\u0003\u0002\b\u0005Ea\u0002BA\u0005\u0003\u001fi!!a\u0003\u000b\u0007\u00055q$\u0001\u0004=e>|GOP\u0005\u0002O%\u0019\u00111\u0003\u0014\u0002\u000fA\f7m[1hK&!\u0011qCA\r\u0005\u0019)\u0015\u000e\u001e5fe*\u0019\u00111\u0003\u0014\u0011\t\u0005u\u0011Q\u0005\b\u0005\u0003?\t\t\u0003E\u0002\u0002\n\u0019J1!a\t'\u0003\u0019\u0001&/\u001a3fM&!\u0011qEA\u0015\u0005\u0019\u0019FO]5oO*\u0019\u00111\u0005\u0014\u0011\u0007\u0005\ni#C\u0002\u00020M\u00111CU1x'\u000e,g.\u0019:j_R+7\u000f\u001e#bi\u0006DQA^\u0007A\u0002]Dq!!\u000e\u000e\u0001\u0004\t9$\u0001\buKN$8+Y7qY\u0016\u001c\u0016N_3\u0011\u0007\u0015\nI$C\u0002\u0002<\u0019\u00121!\u00138u\u0003-\u0001XM\u001d4pe6$Vm\u001d;\u0016\t\u0005\u0005\u00131\f\u000b\u000b\u0003\u0007\nI)a&\u0002\u001a\u0006uECBA#\u0003[\n9\b\u0005\u0004\u0002H\u00055\u0013\u0011K\u0007\u0003\u0003\u0013R1!a\u0013'\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0005\u0003\u001f\nIE\u0001\u0004GkR,(/\u001a\t\u0006C\u0005M\u0013qK\u0005\u0004\u0003+\u001a\"!\u0005*fgVdGo],ji\"\u001cu.\u001e8ugB!\u0011\u0011LA.\u0019\u0001!q!!\u0018\u000f\u0005\u0004\tyFA\u0001U#\u0011\t\t'a\u001a\u0011\u0007\u0015\n\u0019'C\u0002\u0002f\u0019\u0012qAT8uQ&tw\rE\u0002&\u0003SJ1!a\u001b'\u0005\r\te.\u001f\u0005\b\u0003_r\u00019AA9\u0003\t)7\r\u0005\u0003\u0002H\u0005M\u0014\u0002BA;\u0003\u0013\u0012\u0001#\u0012=fGV$\u0018n\u001c8D_:$X\r\u001f;\t\u000f\u0005ed\u0002q\u0001\u0002|\u0005!Qo]3s!\u0011\ti(!\"\u000e\u0005\u0005}$bA'\u0002\u0002*\u0019\u00111Q\f\u0002\u0011M,7-\u001e:jifLA!a\"\u0002\u0000\tQAj\\4hK\u0012,6/\u001a:\t\u000f\u0005-e\u00021\u0001\u0002\u000e\u0006Q\u0011\u000eZ,ji\"t\u0015-\\3\u0011\t\u0005=\u00151S\u0007\u0003\u0003#S!AF>\n\t\u0005U\u0015\u0011\u0013\u0002\u0012!J|7-Z:t\u0013\u0012<\u0016\u000e\u001e5OC6,\u0007\"\u0002<\u000f\u0001\u00049\bbBAN\u001d\u0001\u0007\u00111F\u0001\fe\u0006<H+Z:u\t\u0006$\u0018\rC\u0004\u0002 :\u0001\r!!)\u00025Q,7\u000f\u001e*fgVdGo\u001d,be&\f'\r\\3F]\u000e|G-\u001a:\u0011\u000f\u0015\n\u0019+a\u001a\u0002X%\u0019\u0011Q\u0015\u0014\u0003\u0013\u0019+hn\u0019;j_:\f\u0014A\u0005;p\u0007\u0006twN\\5dC2\u0004&o\\2fgN$B!a+\u00028B!\u0011QVAZ\u001b\t\tyKC\u0002\u00022\u0016\u000babY1o_:L7-\u00197he\u0006\u0004\b.\u0003\u0003\u00026\u0006=&\u0001E\"b]>t\u0017nY1m!J|7-Z:t\u0011\u00151x\u00021\u0001x\u0003u\t7o]3siR+7\u000f\u001e*fgVdGo]!sK:{G\u000fV8p\u0005&<G\u0003BA_\u0003\u000b\u0004b!a\u0012\u0002N\u0005}\u0006cA\u0013\u0002B&\u0019\u00111\u0019\u0014\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003\u000f\u0004\u0002\u0019AAe\u0003-!Xm\u001d;SKN,H\u000e^:1\t\u0005-\u00171\u001f\t\u0007\u0003\u001b\fY/!=\u000f\t\u0005=\u0017Q\u001d\b\u0005\u0003#\f\tO\u0004\u0003\u0002T\u0006}g\u0002BAk\u0003;tA!a6\u0002\\:!\u0011\u0011BAm\u0013\u0005q\u0012B\u0001\u000f\u001e\u0013\tQ2$\u0003\u0002G3%\u0019\u00111]#\u0002\u0011Q,7\u000f^7pI\u0016LA!a:\u0002j\u0006YA+Z:u!J|7-Z:t\u0015\r\t\u0019/R\u0005\u0005\u0003[\fyOA\u0006UKN$(+Z:vYR\u001c(\u0002BAt\u0003S\u0004B!!\u0017\u0002t\u0012a\u0011Q_Ac\u0003\u0003\u0005\tQ!\u0001\u0002`\t\u0019q\fJ\u0019\u0002\u001b\r|W\u000e];uK\u000e{WO\u001c;t)\u0019\tYPa\u0002\u0003\fAA\u0011QDA\u007f\u00037\u0011\t!\u0003\u0003\u0002\u0000\u0006%\"aA'baB\u0019QLa\u0001\n\u0007\t\u0015aLA\u0005O_\u0012,7i\\;oi\"9!\u0011B\tA\u0002\u0005-\u0016!C2b]>t\u0017nY1m\u0011\u001d\u0011i!\u0005a\u0001\u0005\u001f\tqA]3tk2$8\u000f\r\u0003\u0003\u0012\tU\u0001CBAg\u0003W\u0014\u0019\u0002\u0005\u0003\u0002Z\tUA\u0001\u0004B\f\u0005\u0017\t\t\u0011!A\u0003\u0002\u0005}#aA0%e!9!1D\u0002A\u0002\tu\u0011!\u00039s_ZLG-\u001a:t!\u0011atHa\b\u0011\t\t\u0005\"1E\u0007\u0002\u000b&\u0019!QE#\u0003\u00135{G-\u001a7ECR\f\u0007\"B%\u0004\u0001\u0004Q\u0005\"\u0002+\u0004\u0001\u0004)\u0006\"B.\u0004\u0001\u0004a\u0006\"\u00022\u0004\u0001\u0004\u0019\u0007")
public class ScenarioTestService
implements LazyLogging {
    private final ProcessingTypeDataProvider<TestInfoProvider> testInfoProviders;
    private final TestDataSettings testDataSettings;
    private final ScenarioTestDataSerDe scenarioTestDataSerDe;
    private final UIProcessResolving processResolving;
    private final ProcessCounter processCounter;
    private final ScenarioTestExecutorService testExecutorService;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    public static ScenarioTestService apply(ProcessingTypeDataProvider<ModelData> processingTypeDataProvider, TestDataSettings testDataSettings, UIProcessResolving uIProcessResolving, ProcessCounter processCounter, ScenarioTestExecutorService scenarioTestExecutorService) {
        return ScenarioTestService$.MODULE$.apply(processingTypeDataProvider, testDataSettings, uIProcessResolving, processCounter, scenarioTestExecutorService);
    }

    private Logger logger$lzycompute() {
        ScenarioTestService scenarioTestService = this;
        synchronized (scenarioTestService) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public TestingCapabilities getTestingCapabilities(DisplayableProcess displayableProcess) {
        TestInfoProvider testInfoProvider = this.testInfoProviders.forTypeUnsafe(displayableProcess.processingType());
        CanonicalProcess canonical = this.toCanonicalProcess(displayableProcess);
        return testInfoProvider.getTestingCapabilities(canonical);
    }

    public Either<String, RawScenarioTestData> generateData(DisplayableProcess displayableProcess, int testSampleSize) {
        TestInfoProvider testInfoProvider = this.testInfoProviders.forTypeUnsafe(displayableProcess.processingType());
        CanonicalProcess canonical = this.toCanonicalProcess(displayableProcess);
        return package$.MODULE$.Either().cond(testSampleSize <= this.testDataSettings.maxSamplesCount(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {}, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(37).append("Too many samples requested, limit is ").append($this.testDataSettings.maxSamplesCount()).toString()).flatMap((Function1 & Serializable & scala.Serializable)_ -> testInfoProvider.generateTestData(canonical, testSampleSize).toRight((Function0 & Serializable & scala.Serializable)() -> "Test data could not be generated for scenario").flatMap((Function1 & Serializable & scala.Serializable)generatedData -> $this.scenarioTestDataSerDe.serializeTestData((ScenarioTestData)generatedData).map((Function1 & Serializable & scala.Serializable)rawTestData -> rawTestData)));
    }

    public <T> Future<ResultsWithCounts<T>> performTest(ProcessIdWithName idWithName, DisplayableProcess displayableProcess, RawScenarioTestData rawTestData, Function1<Object, T> testResultsVariableEncoder, ExecutionContext ec, LoggedUser user) {
        return ((Future)this.scenarioTestDataSerDe.prepareTestData(rawTestData).fold((Function1 & Serializable & scala.Serializable)error -> Future$.MODULE$.failed((Throwable)new IllegalArgumentException((String)error)), (Function1 & Serializable & scala.Serializable)result -> Future$.MODULE$.successful(result))).map((Function1 & Serializable & scala.Serializable)scenarioTestData -> {
            CanonicalProcess canonical = this.toCanonicalProcess(displayableProcess);
            return new Tuple2(scenarioTestData, (Object)canonical);
        }, ec).flatMap((Function1 & Serializable & scala.Serializable)x$2 -> {
            Tuple2 tuple2 = x$2;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            ScenarioTestData scenarioTestData = (ScenarioTestData)tuple2._1();
            CanonicalProcess canonical = (CanonicalProcess)tuple2._2();
            Future future = $this.testExecutorService.testProcess(idWithName, canonical, displayableProcess.category(), scenarioTestData, testResultsVariableEncoder, user, ec).flatMap((Function1 & Serializable & scala.Serializable)testResults -> this.assertTestResultsAreNotTooBig((TestProcess.TestResults<?>)testResults).map((Function1 & Serializable & scala.Serializable)_ -> new ResultsWithCounts(testResults, this.computeCounts(canonical, (TestProcess.TestResults<?>)testResults)), ec), ec);
            return future;
        }, ec);
    }

    private CanonicalProcess toCanonicalProcess(DisplayableProcess displayableProcess) {
        ValidationResults.ValidationResult validationResult = this.processResolving.validateBeforeUiResolving(displayableProcess);
        return this.processResolving.resolveExpressions(displayableProcess, (Map<String, Map<String, ExpressionTypingInfo>>)validationResult.typingInfo());
    }

    private Future<BoxedUnit> assertTestResultsAreNotTooBig(TestProcess.TestResults<?> testResults) {
        Future future;
        long testDataResultApproxByteSize = RamUsageEstimator.sizeOf(testResults);
        if (testDataResultApproxByteSize > (long)this.testDataSettings.resultsMaxBytes()) {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isInfoEnabled()) {
                this.logger().underlying().info("Test data limit exceeded. Approximate test data size: {}, but limit is: {}", new Object[]{BoxesRunTime.boxToLong((long)testDataResultApproxByteSize), BoxesRunTime.boxToInteger((int)this.testDataSettings.resultsMaxBytes())});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.failed((Throwable)new RuntimeException("Too much test data. Please decrease test input data size."));
        } else {
            future = Future$.MODULE$.successful((Object)BoxedUnit.UNIT);
        }
        return future;
    }

    private Map<String, NodeCount> computeCounts(CanonicalProcess canonical, TestProcess.TestResults<?> results) {
        Map counts = (Map)results.nodeResults().map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String key = (String)tuple2._1();
            List nresults = (List)tuple2._2();
            Tuple2 tuple22 = Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)key), (Object)new RawCount(nresults.size(), Option$.MODULE$.option2Iterable(results.exceptions().find((Function1 & Serializable & scala.Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ScenarioTestService.$anonfun$computeCounts$2(key, x$3)))).size()));
            return tuple22;
        }, Map$.MODULE$.canBuildFrom());
        return this.processCounter.computeCounts(canonical, (Function1<String, Option<RawCount>>)(Function1 & Serializable & scala.Serializable)key -> counts.get(key));
    }

    public static final /* synthetic */ boolean $anonfun$computeCounts$2(String key$1, TestProcess.ExceptionResult x$3) {
        return x$3.nodeId().contains((Object)key$1);
    }

    public ScenarioTestService(ProcessingTypeDataProvider<TestInfoProvider> testInfoProviders, TestDataSettings testDataSettings, ScenarioTestDataSerDe scenarioTestDataSerDe, UIProcessResolving processResolving, ProcessCounter processCounter, ScenarioTestExecutorService testExecutorService) {
        this.testInfoProviders = testInfoProviders;
        this.testDataSettings = testDataSettings;
        this.scenarioTestDataSerDe = scenarioTestDataSerDe;
        this.processResolving = processResolving;
        this.processCounter = processCounter;
        this.testExecutorService = testExecutorService;
        LazyLogging.$init$((LazyLogging)this);
    }
}

