/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.tscreload;

import io.vavr.Function1;
import io.vavr.Function2;
import io.vavr.Function3;
import io.vavr.Function4;
import io.vavr.Function5;
import io.vavr.Function6;
import java.io.Serializable;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.tscreload.TransformationResult;
import pl.touk.tscreload.impl.Observable;
import pl.touk.tscreload.impl.Reloadable1;
import pl.touk.tscreload.impl.Reloadable2;
import pl.touk.tscreload.impl.Reloadable3;
import pl.touk.tscreload.impl.Reloadable4;
import pl.touk.tscreload.impl.Reloadable5;

public abstract class Reloadable<T>
extends Observable<T> {
    private static final Logger log = LoggerFactory.getLogger(Reloadable.class);
    private volatile T current;

    protected Reloadable(T t) {
        this.current = t;
    }

    protected synchronized void updateCurrentValue(Function1<Optional<T>, TransformationResult<T>> function1) {
        TransformationResult transformationResult = (TransformationResult)function1.apply(Optional.of(this.current));
        if (log.isTraceEnabled()) {
            log.trace("{} Updating current value. Change {} be propagated.", (Object)this, (Object)(transformationResult.isPropagateChange() ? "will" : "won't"));
        }
        this.current = transformationResult.getValue();
        if (transformationResult.isPropagateChange()) {
            this.notifyObservers(transformationResult.getValue());
        }
    }

    public <U> Reloadable<U> map(Function1<T, U> function1) {
        return this.map((Function2 & Serializable)(object, optional) -> TransformationResult.withPropagateChangeWhenValueChanged(optional, function1.apply(object)));
    }

    public <U> Reloadable<U> map(Function2<T, Optional<U>, TransformationResult<U>> function2) {
        Reloadable1<T, U> reloadable1 = new Reloadable1<T, U>(this.currentValue(), function2);
        this.addWeakObserver(reloadable1);
        return reloadable1;
    }

    public T currentValue() {
        return this.current;
    }

    public static <R1, R2, U> Reloadable<U> compose(Reloadable<R1> reloadable, Reloadable<R2> reloadable2, Function2<R1, R2, U> function2) {
        return Reloadable.compose(reloadable, reloadable2, (Function3 & Serializable)(object, object2, optional) -> TransformationResult.withPropagateChangeWhenValueChanged(optional, function2.apply(object, object2)));
    }

    public static <R1, R2, U> Reloadable<U> compose(Reloadable<R1> reloadable, Reloadable<R2> reloadable2, Function3<R1, R2, Optional<U>, TransformationResult<U>> function3) {
        Reloadable2<R1, R2, U> reloadable22 = new Reloadable2<R1, R2, U>(reloadable.currentValue(), reloadable2.currentValue(), function3);
        reloadable.addWeakObserver(reloadable22.observer1);
        reloadable2.addWeakObserver(reloadable22.observer2);
        return reloadable22;
    }

    public static <R1, R2, R3, U> Reloadable<U> compose(Reloadable<R1> reloadable, Reloadable<R2> reloadable2, Reloadable<R3> reloadable3, Function3<R1, R2, R3, U> function3) {
        return Reloadable.compose(reloadable, reloadable2, reloadable3, (Function4 & Serializable)(object, object2, object3, optional) -> TransformationResult.withPropagateChangeWhenValueChanged(optional, function3.apply(object, object2, object3)));
    }

    public static <R1, R2, R3, U> Reloadable<U> compose(Reloadable<R1> reloadable, Reloadable<R2> reloadable2, Reloadable<R3> reloadable3, Function4<R1, R2, R3, Optional<U>, TransformationResult<U>> function4) {
        Reloadable3<R1, R2, R3, U> reloadable32 = new Reloadable3<R1, R2, R3, U>(reloadable.currentValue(), reloadable2.currentValue(), reloadable3.currentValue(), function4);
        reloadable.addWeakObserver(reloadable32.observer1);
        reloadable2.addWeakObserver(reloadable32.observer2);
        reloadable3.addWeakObserver(reloadable32.observer3);
        return reloadable32;
    }

    public static <R1, R2, R3, R4, U> Reloadable<U> compose(Reloadable<R1> reloadable, Reloadable<R2> reloadable2, Reloadable<R3> reloadable3, Reloadable<R4> reloadable4, Function4<R1, R2, R3, R4, U> function4) {
        return Reloadable.compose(reloadable, reloadable2, reloadable3, reloadable4, (Function5 & Serializable)(object, object2, object3, object4, optional) -> TransformationResult.withPropagateChangeWhenValueChanged(optional, function4.apply(object, object2, object3, object4)));
    }

    public static <R1, R2, R3, R4, U> Reloadable<U> compose(Reloadable<R1> reloadable, Reloadable<R2> reloadable2, Reloadable<R3> reloadable3, Reloadable<R4> reloadable4, Function5<R1, R2, R3, R4, Optional<U>, TransformationResult<U>> function5) {
        Reloadable4<R1, R2, R3, R4, U> reloadable42 = new Reloadable4<R1, R2, R3, R4, U>(reloadable.currentValue(), reloadable2.currentValue(), reloadable3.currentValue(), reloadable4.currentValue(), function5);
        reloadable.addWeakObserver(reloadable42.observer1);
        reloadable2.addWeakObserver(reloadable42.observer2);
        reloadable3.addWeakObserver(reloadable42.observer3);
        reloadable4.addWeakObserver(reloadable42.observer4);
        return reloadable42;
    }

    public static <R1, R2, R3, R4, R5, U> Reloadable<U> compose(Reloadable<R1> reloadable, Reloadable<R2> reloadable2, Reloadable<R3> reloadable3, Reloadable<R4> reloadable4, Reloadable<R5> reloadable5, Function5<R1, R2, R3, R4, R5, U> function5) {
        return Reloadable.compose(reloadable, reloadable2, reloadable3, reloadable4, reloadable5, (Function6 & Serializable)(object, object2, object3, object4, object5, optional) -> TransformationResult.withPropagateChangeWhenValueChanged(optional, function5.apply(object, object2, object3, object4, object5)));
    }

    public static <R1, R2, R3, R4, R5, U> Reloadable<U> compose(Reloadable<R1> reloadable, Reloadable<R2> reloadable2, Reloadable<R3> reloadable3, Reloadable<R4> reloadable4, Reloadable<R5> reloadable5, Function6<R1, R2, R3, R4, R5, Optional<U>, TransformationResult<U>> function6) {
        Reloadable5<R1, R2, R3, R4, R5, U> reloadable52 = new Reloadable5<R1, R2, R3, R4, R5, U>(reloadable.currentValue(), reloadable2.currentValue(), reloadable3.currentValue(), reloadable4.currentValue(), reloadable5.currentValue(), function6);
        reloadable.addWeakObserver(reloadable52.observer1);
        reloadable2.addWeakObserver(reloadable52.observer2);
        reloadable3.addWeakObserver(reloadable52.observer3);
        reloadable4.addWeakObserver(reloadable52.observer4);
        reloadable5.addWeakObserver(reloadable52.observer5);
        return reloadable52;
    }
}

