/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.tscreload;

import io.vavr.Function1;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.function.Supplier;
import pl.touk.tscreload.Reloadable;
import pl.touk.tscreload.TimeTriggeredReloadable;
import pl.touk.tscreload.TransformationResult;
import pl.touk.tscreload.impl.Observer;
import pl.touk.tscreload.impl.ReloadableConfig;
import pl.touk.tscreload.impl.Reloader;

public class ReloadableConfigFactory {
    static final int TICK_SECONDS = 5;
    private static final Reloader reloader = new Reloader(5);

    public static <T> Reloadable<T> load(List<File> list, Duration duration, Supplier<T> supplier) {
        return ReloadableConfigFactory.load(list, duration, (Function1 & Serializable)optional -> TransformationResult.withPropagateChangeWhenValueChanged(optional, supplier.get()));
    }

    public static <T> Reloadable<T> load(List<File> list, Duration duration, Function1<Optional<T>, TransformationResult<T>> function1) {
        ReloadableConfig<T> reloadableConfig = new ReloadableConfig<T>(list, duration, function1);
        ReloadableConfigFactory.addTickObserver(reloadableConfig);
        return reloadableConfig;
    }

    public static Reloadable<Instant> addTickPropagator(Duration duration) {
        TimeTriggeredReloadable<Instant> timeTriggeredReloadable = TimeTriggeredReloadable.propagatingTicks(Instant.now(), duration);
        ReloadableConfigFactory.addTickObserver(timeTriggeredReloadable);
        return timeTriggeredReloadable;
    }

    public static <T extends Observer<Instant>> T addTickObserver(T t) {
        reloader.addWeakObserver(t);
        return t;
    }
}

