/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.tscreload;

import io.vavr.Function2;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.Collections;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.tscreload.Reloadable;
import pl.touk.tscreload.TransformationResult;
import pl.touk.tscreload.impl.Observable;
import pl.touk.tscreload.impl.Observer;

public class TimeTriggeredReloadable<T>
extends Reloadable<T>
implements Observer<Instant> {
    private static final Logger log = LoggerFactory.getLogger(TimeTriggeredReloadable.class);
    private final Set<Observable<?>> parents = Collections.synchronizedSet(new HashSet());
    private final Duration checkInterval;
    private final Function2<Instant, Optional<T>, TransformationResult<T>> transform;
    private Instant lastCheck;

    public TimeTriggeredReloadable(T t, Duration duration, Function2<Instant, Optional<T>, TransformationResult<T>> function2) {
        this(t, Instant.now(), duration, function2);
    }

    public TimeTriggeredReloadable(T t, Instant instant, Duration duration, Function2<Instant, Optional<T>, TransformationResult<T>> function2) {
        super(t);
        this.lastCheck = instant;
        this.checkInterval = duration;
        this.transform = function2;
    }

    @Override
    public void addParent(Observable<?> observable) {
        this.parents.add(observable);
    }

    @Override
    public synchronized void notifyChanged(Instant instant) {
        log.trace("{} Saved last check: {}, now: {}, checkInterval: {}", new Object[]{this, this.lastCheck, instant, this.checkInterval});
        if (instant.isAfter(this.lastCheck.plus(this.checkInterval))) {
            try {
                this.handleTimeTrigger(instant);
            }
            catch (Exception exception) {
                log.error("Error while handling tick, will check next time in " + this.checkInterval, (Throwable)exception);
                throw exception;
            }
            finally {
                this.lastCheck = instant;
            }
        }
    }

    protected void handleTimeTrigger(Instant instant) {
        this.updateCurrentValueWithTransformed(instant);
    }

    protected void updateCurrentValueWithTransformed(Instant instant) {
        this.updateCurrentValue(this.transform.apply((Object)instant));
    }

    public static TimeTriggeredReloadable<Instant> propagatingTicks(Instant instant2, Duration duration) {
        return new TimeTriggeredReloadable<Instant>(instant2, instant2, duration, (Function2 & Serializable)(instant, optional) -> new TransformationResult<Instant>((Instant)instant, true));
    }
}

