/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.tscreload;

import java.util.Optional;

public final class TransformationResult<T> {
    private final T value;
    private final boolean propagateChange;

    public static <U> TransformationResult<U> withPropagateChangeWhenValueChanged(Optional<U> optional, U u) {
        return new TransformationResult<U>(u, !optional.isPresent() || !u.equals(optional.get()));
    }

    public TransformationResult(T t, boolean bl) {
        this.value = t;
        this.propagateChange = bl;
    }

    private TransformationResult() {
        this.value = null;
        this.propagateChange = false;
    }

    public T getValue() {
        return this.value;
    }

    public boolean isPropagateChange() {
        return this.propagateChange;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof TransformationResult)) {
            return false;
        }
        TransformationResult transformationResult = (TransformationResult)object;
        T t = this.getValue();
        T t2 = transformationResult.getValue();
        if (t == null ? t2 != null : !t.equals(t2)) {
            return false;
        }
        return this.isPropagateChange() == transformationResult.isPropagateChange();
    }

    public int hashCode() {
        int n = 1;
        T t = this.getValue();
        n = n * 59 + (t == null ? 43 : t.hashCode());
        n = n * 59 + (this.isPropagateChange() ? 79 : 97);
        return n;
    }

    public String toString() {
        return "TransformationResult(value=" + this.getValue() + ", propagateChange=" + this.isPropagateChange() + ")";
    }
}

