/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.tscreload.impl;

import java.util.Collections;
import java.util.Set;
import java.util.WeakHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.tscreload.impl.Observer;

public abstract class Observable<T> {
    private static final Logger log = LoggerFactory.getLogger(Observable.class);
    private final Set<Observer<T>> observers = Collections.newSetFromMap(new WeakHashMap());

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addWeakObserver(Observer<T> observer) {
        Set<Observer<T>> set = this.observers;
        synchronized (set) {
            observer.addParent(this);
            this.observers.add(observer);
            if (!this.observers.isEmpty()) {
                log.trace("{} Added observer {}. Current observer count: {}", new Object[]{this, observer, this.observers.size()});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void notifyObservers(T t) {
        Set<Observer<T>> set = this.observers;
        synchronized (set) {
            if (!this.observers.isEmpty()) {
                log.trace("{} Notifying {} observers...", (Object)this, (Object)this.observers.size());
            }
            this.observers.forEach(observer -> {
                try {
                    observer.notifyChanged(t);
                }
                catch (Exception exception) {
                    log.error("Exception while notify about changed value. Propagation of changes for child nodes will be discarded.", (Throwable)exception);
                }
            });
        }
    }
}

