/*
 * Decompiled with CFR 0.152.
 */
package pl.touk.tscreload.impl;

import io.vavr.Function1;
import io.vavr.Function2;
import java.io.File;
import java.io.Serializable;
import java.time.Duration;
import java.time.Instant;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.tscreload.TimeTriggeredReloadable;
import pl.touk.tscreload.TransformationResult;

public class ReloadableConfig<T>
extends TimeTriggeredReloadable<T> {
    private static final Logger log = LoggerFactory.getLogger(ReloadableConfig.class);
    private final List<File> scannedFiles;
    private Instant savedLastModified;

    public ReloadableConfig(List<File> list, Duration duration, Function1<Optional<T>, TransformationResult<T>> function1) {
        super(((TransformationResult)function1.apply(Optional.empty())).getValue(), Instant.now(), duration, (Function2 & Serializable)(instant, optional) -> (TransformationResult)function1.apply(optional));
        this.scannedFiles = list;
        this.savedLastModified = this.checkLastModified();
    }

    @Override
    protected void handleTimeTrigger(Instant instant) {
        String string;
        Instant instant2 = this.checkLastModified();
        if (log.isTraceEnabled()) {
            string = this.scannedFiles.stream().map(File::getPath).collect(Collectors.joining(", "));
            log.trace("{} Last modified for files {}: {}. Previous saved is: {}", new Object[]{this, string, instant2, this.savedLastModified});
        }
        if (instant2.isAfter(this.savedLastModified)) {
            if (log.isDebugEnabled()) {
                string = this.scannedFiles.stream().map(File::getPath).collect(Collectors.joining(", "));
                log.debug("Last modified time for files {}: {} is after previous saved: {}. Reloading configuration...", new Object[]{string, instant2, this.savedLastModified});
            }
            this.updateCurrentValueWithTransformed(instant);
            this.savedLastModified = instant2;
        }
    }

    private Instant checkLastModified() {
        return this.scannedFiles.stream().map(File::lastModified).max(Long::compare).map(Instant::ofEpochMilli).orElseThrow(() -> new IllegalArgumentException("None files to scan specified."));
    }
}

