/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.eid;

import javax.annotation.Nullable;
import pl.wavesoftware.eid.api.Eid;
import pl.wavesoftware.eid.api.EidMessage;
import pl.wavesoftware.eid.api.SerializableSupplier;
import pl.wavesoftware.eid.api.Supplier;
import pl.wavesoftware.eid.api.Validator;
import pl.wavesoftware.eid.system.EidModule;

public class DefaultEid
implements Eid {
    private static final long serialVersionUID = 20181029193034L;
    private transient String id;
    @Nullable
    private transient String ref;
    private final SerializableSupplier<String> uniqueId = EidModule.MODULE.getBinding().getFactories().getLazyFactory().lazy(new Supplier<String>(){

        @Override
        public String get() {
            return EidModule.MODULE.getBinding().getConfigurationSystem().getConfiguration().getIdGenerator().generateUniqId();
        }
    });

    public DefaultEid(CharSequence id) {
        this.id = DefaultEid.validate(id).toString();
        this.ref = null;
    }

    public DefaultEid(CharSequence id, CharSequence ref) {
        this.id = DefaultEid.validate(id).toString();
        this.ref = ref.toString();
    }

    public static Eid eid(String id) {
        return new DefaultEid(id);
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    @Nullable
    public String getRef() {
        return this.ref;
    }

    @Override
    public boolean hasRef() {
        return this.getRef() != null;
    }

    @Override
    public String getUnique() {
        return (String)this.uniqueId.get();
    }

    @Override
    public EidMessage message(CharSequence messageTemplate, Object ... templateArguments) {
        return EidModule.MODULE.getBinding().getFactories().getMessageFactory().create(this, messageTemplate, templateArguments);
    }

    public String toString() {
        return EidModule.MODULE.getBinding().getConfigurationSystem().getConfiguration().getFormatter().format(this);
    }

    private static CharSequence validate(CharSequence id) {
        if (id == null) {
            throw new IllegalArgumentException("Exception ID can't be null");
        }
        if (DefaultEid.isInvalid(id)) {
            throw new IllegalArgumentException("Invalid ID given as an Exception ID: " + id);
        }
        return id;
    }

    private static boolean isInvalid(CharSequence id) {
        Validator validator = DefaultEid.getValidator();
        return validator != null && !validator.isValid(id);
    }

    @Nullable
    private static Validator getValidator() {
        return EidModule.MODULE.getBinding().getConfigurationSystem().getConfiguration().getValidator();
    }
}

