/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.eid.exceptions;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import pl.wavesoftware.eid.api.Eid;
import pl.wavesoftware.eid.api.EidContainer;
import pl.wavesoftware.eid.api.EidMessage;
import pl.wavesoftware.eid.system.EidModule;

public class EidRuntimeException
extends RuntimeException
implements EidContainer {
    private static final long serialVersionUID = 20181029202308L;
    private final Eid eid;

    public EidRuntimeException(CharSequence eid) {
        this(EidModule.MODULE.getBinding().getFactories().getEidFactory().create(eid));
    }

    public EidRuntimeException(CharSequence eid, String message) {
        this(EidModule.MODULE.getBinding().getFactories().getEidFactory().create(eid), message);
    }

    public EidRuntimeException(EidMessage message) {
        super(message.toString());
        this.eid = message.getEid();
    }

    public EidRuntimeException(CharSequence eid, String message, @Nullable Throwable cause) {
        this(EidModule.MODULE.getBinding().getFactories().getEidFactory().create(eid), message, cause);
    }

    public EidRuntimeException(EidMessage message, @Nullable Throwable cause) {
        this(message.getEid(), message.getFormattedMessage().toString(), cause);
    }

    public EidRuntimeException(CharSequence eid, @Nullable Throwable cause) {
        this(EidModule.MODULE.getBinding().getFactories().getEidFactory().create(eid), cause);
    }

    public EidRuntimeException(Eid id) {
        super(id.toString());
        this.eid = id;
    }

    public EidRuntimeException(Eid id, String message) {
        super(id.message(message, new Object[0]).toString());
        this.eid = id;
    }

    public EidRuntimeException(Eid id, String message, @Nullable Throwable cause) {
        super(id.message(message, new Object[0]).toString(), cause);
        this.eid = id;
    }

    public EidRuntimeException(Eid id, @Nullable Throwable cause) {
        super(EidRuntimeException.messageOf(id, cause), cause);
        this.eid = id;
    }

    @Override
    public Eid getEid() {
        return this.eid;
    }

    private static String messageOf(Eid eid, @Nullable Throwable cause) {
        if (cause != null) {
            return eid.message(EidRuntimeException.messageOf(cause), new Object[0]).toString();
        }
        return eid.toString();
    }

    @Nonnull
    private static String messageOf(Throwable cause) {
        String value = EidRuntimeException.coalesce(EidRuntimeException.coalesce(cause.getLocalizedMessage(), cause.getMessage()), cause.toString());
        assert (value != null) : "20181214:234625";
        return value;
    }

    @Nullable
    private static <T> T coalesce(@Nullable T first, @Nullable T second) {
        if (first == null) {
            return second;
        }
        return first;
    }
}

