/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.eid.impl;

import java.util.Locale;
import java.util.TimeZone;
import javax.annotation.Nullable;
import pl.wavesoftware.eid.api.Configuration;
import pl.wavesoftware.eid.api.ConfigurationBuilder;
import pl.wavesoftware.eid.api.Formatter;
import pl.wavesoftware.eid.api.UniqueIdGenerator;
import pl.wavesoftware.eid.api.Validator;
import pl.wavesoftware.eid.impl.InternalChecks;
import pl.wavesoftware.eid.impl.MutableConfiguration;

final class ConfigurationImpl
implements MutableConfiguration {
    private Formatter formatter;
    private UniqueIdGenerator generator;
    @Nullable
    private Validator validator;
    @Nullable
    private Locale locale;
    @Nullable
    private TimeZone zone;

    ConfigurationImpl() {
    }

    ConfigurationImpl(MutableConfiguration settings) {
        InternalChecks.checkNotNull(settings, "20181218:002046");
        this.formatter = settings.getFormatter();
        this.generator = settings.getIdGenerator();
        this.validator = settings.getValidator();
        this.locale = settings.getLocale();
        this.zone = settings.getTimeZone();
    }

    @Override
    public ConfigurationBuilder uniqueIdGenerator(UniqueIdGenerator generator) {
        this.generator = InternalChecks.checkNotNull(generator, "20181218:002002");
        return this;
    }

    @Override
    public ConfigurationBuilder formatter(Formatter formatter) {
        this.formatter = InternalChecks.checkNotNull(formatter, "20181218:002018");
        return this;
    }

    @Override
    public ConfigurationBuilder locale(@Nullable Locale locale) {
        this.locale = locale;
        return this;
    }

    @Override
    public ConfigurationBuilder timezone(@Nullable TimeZone zone) {
        this.zone = zone;
        return this;
    }

    @Override
    public ConfigurationBuilder validator(@Nullable Validator validator) {
        this.validator = validator;
        return this;
    }

    @Override
    public Configuration getFutureConfiguration() {
        return this;
    }

    @Override
    public Formatter getFormatter() {
        return this.formatter;
    }

    @Override
    public UniqueIdGenerator getIdGenerator() {
        return this.generator;
    }

    @Override
    @Nullable
    public Validator getValidator() {
        return this.validator;
    }

    @Override
    @Nullable
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    @Nullable
    public TimeZone getTimeZone() {
        return this.zone;
    }
}

