/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.eid.impl;

import java.util.ServiceLoader;
import pl.wavesoftware.eid.api.Configuration;
import pl.wavesoftware.eid.api.ConfigurationBuilder;
import pl.wavesoftware.eid.api.ConfigurationSystem;
import pl.wavesoftware.eid.api.Configurator;
import pl.wavesoftware.eid.api.Supplier;
import pl.wavesoftware.eid.impl.ConfigurationImpl;
import pl.wavesoftware.eid.impl.DefaultConfigurator;
import pl.wavesoftware.eid.impl.Lazy;
import pl.wavesoftware.eid.impl.MutableConfiguration;

final class ConfigurationSystemImpl
implements ConfigurationSystem {
    private Lazy<MutableConfiguration> configuration = Lazy.of(new MutableConfigurationSupplier());

    ConfigurationSystemImpl() {
    }

    @Override
    public Configuration getConfiguration() {
        return this.configuration.get();
    }

    @Override
    public Configurator configure(Configurator configurator) {
        MutableConfiguration configured = this.configuration.get();
        ConfigurationImpl mutable = new ConfigurationImpl(configured);
        configurator.configure(mutable);
        this.configuration = Lazy.of(mutable);
        return new RestoreConfigurator(configured);
    }

    private static final class RestoreConfigurator
    implements Configurator {
        private final MutableConfiguration configuration;

        RestoreConfigurator(MutableConfiguration configuration) {
            this.configuration = configuration;
        }

        @Override
        public void configure(ConfigurationBuilder builder) {
            builder.formatter(this.configuration.getFormatter()).uniqueIdGenerator(this.configuration.getIdGenerator()).validator(this.configuration.getValidator()).locale(this.configuration.getLocale());
        }
    }

    private static final class MutableConfigurationSupplier
    implements Supplier<MutableConfiguration> {
        private MutableConfigurationSupplier() {
        }

        @Override
        public MutableConfiguration get() {
            return MutableConfigurationSupplier.loadConfiguration();
        }

        private static MutableConfiguration loadConfiguration() {
            ConfigurationImpl mutableConfiguration = new ConfigurationImpl();
            new DefaultConfigurator().configure(mutableConfiguration);
            ServiceLoader<Configurator> configurators = ServiceLoader.load(Configurator.class);
            for (Configurator configurator : configurators) {
                configurator.configure(mutableConfiguration);
            }
            return mutableConfiguration;
        }
    }
}

