/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.eid.impl;

import java.util.Locale;
import pl.wavesoftware.eid.api.Configuration;
import pl.wavesoftware.eid.api.Eid;
import pl.wavesoftware.eid.api.Formatter;

final class DefaultFormatter
implements Formatter {
    private static final String FORMAT = "[%s]<%s>";
    private static final String REF_FORMAT = "[%s|%s]<%s>";
    private static final String MSG_FORMAT = "%s => %s";
    private final Configuration configuration;

    DefaultFormatter(Configuration configuration) {
        this.configuration = configuration;
    }

    @Override
    public String format(Eid eid) {
        Object[] params;
        String fmt;
        if (eid.getRef() == null) {
            fmt = FORMAT;
            params = new Object[]{eid.getId(), eid.getUnique()};
        } else {
            fmt = REF_FORMAT;
            params = new Object[]{eid.getId(), eid.getRef(), eid.getUnique()};
        }
        java.util.Formatter formatter = this.getStringFormatter().format(fmt, params);
        return formatter.toString();
    }

    @Override
    public String format(Eid eid, String message) {
        return this.getStringFormatter().format(MSG_FORMAT, this.format(eid), message).toString();
    }

    private java.util.Formatter getStringFormatter() {
        Locale locale = this.configuration.getLocale();
        if (locale != null) {
            return new java.util.Formatter(locale);
        }
        return new java.util.Formatter();
    }
}

