/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.eid.impl;

import java.io.Serializable;
import pl.wavesoftware.eid.api.Configuration;
import pl.wavesoftware.eid.api.Eid;
import pl.wavesoftware.eid.api.EidContainer;
import pl.wavesoftware.eid.api.Supplier;
import pl.wavesoftware.eid.impl.SerializableLazy;
import pl.wavesoftware.eid.impl.TextMessage;

final class EidTextRepresentation
implements EidContainer,
Serializable {
    private static final long serialVersionUID = 20181029231519L;
    private final Eid eid;
    private final TextMessage textMessage;
    private final SerializableLazy<String> actual;

    EidTextRepresentation(final Eid eid, final TextMessage textMessage, final Configuration configuration) {
        this.eid = eid;
        this.textMessage = textMessage;
        this.actual = SerializableLazy.serializableOf(new Supplier<String>(){

            @Override
            public String get() {
                return configuration.getFormatter().format(eid, textMessage.get());
            }
        });
    }

    @Override
    public Eid getEid() {
        return this.eid;
    }

    TextMessage getTextMessage() {
        return this.textMessage;
    }

    String get() {
        return (String)this.actual.get();
    }
}

