/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.eid.impl;

import pl.wavesoftware.eid.api.Supplier;
import pl.wavesoftware.eid.impl.InternalChecks;

class Lazy<T>
implements Supplier<T> {
    private volatile Supplier<T> supplier;
    private T value;

    Lazy(Supplier<T> supplier) {
        this.supplier = InternalChecks.checkNotNull(supplier, "20181124:004511");
    }

    protected Lazy() {
    }

    private Lazy(T value) {
        this.value = value;
    }

    static <R> Lazy<R> of(Supplier<R> supplier) {
        return new Lazy<Supplier<R>>(supplier);
    }

    static <R> Lazy<R> of(R value) {
        return new Lazy<R>(value);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public T get() {
        if (this.supplier != null) {
            Lazy lazy = this;
            synchronized (lazy) {
                if (this.supplier != null) {
                    T calculated = this.supplier.get();
                    this.supplier = null;
                    this.value = calculated;
                }
            }
        }
        return this.value;
    }
}

