/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.eid.impl;

import java.text.Format;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import pl.wavesoftware.eid.api.Configuration;
import pl.wavesoftware.eid.api.Supplier;

final class MessageSupplier
implements Supplier<String> {
    private final Configuration configuration;
    private final CharSequence messageFormat;
    private final Object[] arguments;

    MessageSupplier(Configuration configuration, CharSequence messageFormat, Object[] arguments) {
        this.configuration = configuration;
        this.messageFormat = messageFormat;
        this.arguments = (Object[])arguments.clone();
    }

    @Override
    public String get() {
        return this.getFormatter().format(this.arguments);
    }

    private MessageFormat getFormatter() {
        Locale locale = this.configuration.getLocale();
        MessageFormat format = locale == null ? new MessageFormat(this.messageFormat.toString()) : new MessageFormat(this.messageFormat.toString(), locale);
        return this.ensureTimeZone(format);
    }

    private MessageFormat ensureTimeZone(MessageFormat messageFormat) {
        TimeZone zone = this.configuration.getTimeZone();
        if (zone != null) {
            Format[] formats;
            for (Format format : formats = messageFormat.getFormats()) {
                if (!(format instanceof SimpleDateFormat)) continue;
                ((SimpleDateFormat)format).setTimeZone(zone);
            }
        }
        return messageFormat;
    }
}

