/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.eid.utils;

import pl.wavesoftware.eid.api.Eid;
import pl.wavesoftware.eid.exceptions.EidRuntimeException;
import pl.wavesoftware.eid.utils.EidUtil;
import pl.wavesoftware.eid.utils.UnsafeProcedure;
import pl.wavesoftware.eid.utils.UnsafeSupplier;

public final class EidExecutions {
    private EidExecutions() {
    }

    public static <R> R tryToExecute(UnsafeSupplier<R> supplier, Eid eid) {
        try {
            return supplier.get();
        }
        catch (Exception throwable) {
            throw new EidRuntimeException(EidUtil.ensureEid(eid), (Throwable)throwable);
        }
    }

    public static void tryToExecute(UnsafeProcedure procedure, Eid eid) {
        try {
            procedure.execute();
        }
        catch (Exception throwable) {
            throw new EidRuntimeException(EidUtil.ensureEid(eid), (Throwable)throwable);
        }
    }

    public static <R> R tryToExecute(UnsafeSupplier<R> supplier, String eid) {
        try {
            return supplier.get();
        }
        catch (Exception throwable) {
            throw new EidRuntimeException(EidUtil.ensureEid(eid), (Throwable)throwable);
        }
    }

    public static void tryToExecute(UnsafeProcedure procedure, String eid) {
        try {
            procedure.execute();
        }
        catch (Exception throwable) {
            throw new EidRuntimeException(EidUtil.ensureEid(eid), (Throwable)throwable);
        }
    }
}

