/*
 * Decompiled with CFR 0.152.
 */
package pl.wavesoftware.eid.utils;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import pl.wavesoftware.eid.api.Eid;
import pl.wavesoftware.eid.exceptions.EidIllegalArgumentException;
import pl.wavesoftware.eid.exceptions.EidIllegalStateException;
import pl.wavesoftware.eid.exceptions.EidIndexOutOfBoundsException;
import pl.wavesoftware.eid.exceptions.EidNullPointerException;
import pl.wavesoftware.eid.exceptions.EidRuntimeException;
import pl.wavesoftware.eid.utils.EidUtil;

public final class EidPreconditions {
    EidPreconditions() {
        throw new EidRuntimeException((CharSequence)"20150718:083450", "This should not be accessed");
    }

    public static void checkArgument(boolean expression, String eid) {
        if (!expression) {
            throw new EidIllegalArgumentException(EidUtil.ensureEid(eid));
        }
    }

    public static void checkArgument(boolean expression, String eid, String messageFormat, Object ... parameters) {
        if (!expression) {
            throw new EidIllegalArgumentException(EidUtil.ensureEid(eid).message(messageFormat, parameters));
        }
    }

    public static void checkArgument(boolean expression, Eid eid) {
        if (!expression) {
            throw new EidIllegalArgumentException(EidUtil.ensureEid(eid));
        }
    }

    public static void checkArgument(boolean expression, Eid eid, String messageFormat, Object ... parameters) {
        if (!expression) {
            throw new EidIllegalArgumentException(EidUtil.ensureEid(eid).message(messageFormat, parameters));
        }
    }

    public static void checkState(boolean expression, String eid) {
        if (!expression) {
            throw new EidIllegalStateException(EidUtil.ensureEid(eid));
        }
    }

    public static void checkState(boolean expression, String eid, String messageFormat, Object ... parameters) {
        if (!expression) {
            throw new EidIllegalStateException(EidUtil.ensureEid(eid).message(messageFormat, parameters));
        }
    }

    public static void checkState(boolean expression, Eid eid) {
        if (!expression) {
            throw new EidIllegalStateException(EidUtil.ensureEid(eid));
        }
    }

    public static void checkState(boolean expression, Eid eid, String messageFormat, Object ... parameters) {
        if (!expression) {
            throw new EidIllegalStateException(EidUtil.ensureEid(eid).message(messageFormat, parameters));
        }
    }

    public static <T> T checkNotNull(@Nullable T reference, String eid) {
        if (reference == null) {
            throw new EidNullPointerException(EidUtil.ensureEid(eid));
        }
        return reference;
    }

    public static <T> T checkNotNull(@Nullable T reference, String eid, String messageFormat, Object ... parameters) {
        if (reference == null) {
            throw new EidNullPointerException(EidUtil.ensureEid(eid).message(messageFormat, parameters));
        }
        return reference;
    }

    public static <T> T checkNotNull(@Nullable T reference, Eid eid) {
        if (reference == null) {
            throw new EidNullPointerException(EidUtil.ensureEid(eid));
        }
        return reference;
    }

    @Nonnull
    public static <T> T checkNotNull(@Nullable T reference, Eid eid, String messageFormat, Object ... parameters) {
        if (reference == null) {
            throw new EidNullPointerException(EidUtil.ensureEid(eid).message(messageFormat, parameters));
        }
        return reference;
    }

    public static int checkElementIndex(int index, int size, String eid) {
        if (EidPreconditions.isSizeIllegal(size)) {
            throw new EidIllegalArgumentException(EidUtil.ensureEid(eid));
        }
        if (EidPreconditions.isIndexAndSizeIllegal(index, size)) {
            throw new EidIndexOutOfBoundsException(EidUtil.ensureEid(eid));
        }
        return index;
    }

    public static int checkElementIndex(int index, int size, String eid, String messageFormat, Object ... parameters) {
        if (EidPreconditions.isSizeIllegal(size)) {
            throw new EidIllegalArgumentException(EidUtil.ensureEid(eid).message(messageFormat, parameters));
        }
        if (EidPreconditions.isIndexAndSizeIllegal(index, size)) {
            throw new EidIndexOutOfBoundsException(EidUtil.ensureEid(eid).message(messageFormat, parameters));
        }
        return index;
    }

    public static int checkElementIndex(int index, int size, Eid eid) {
        if (EidPreconditions.isSizeIllegal(size)) {
            throw new EidIllegalArgumentException(EidUtil.ensureEid(eid));
        }
        if (EidPreconditions.isIndexAndSizeIllegal(index, size)) {
            throw new EidIndexOutOfBoundsException(EidUtil.ensureEid(eid));
        }
        return index;
    }

    public static int checkElementIndex(int index, int size, Eid eid, String messageFormat, Object ... parameters) {
        if (EidPreconditions.isSizeIllegal(size)) {
            throw new EidIllegalArgumentException(EidUtil.ensureEid(eid).message(messageFormat, parameters));
        }
        if (EidPreconditions.isIndexAndSizeIllegal(index, size)) {
            throw new EidIndexOutOfBoundsException(EidUtil.ensureEid(eid).message(messageFormat, parameters));
        }
        return index;
    }

    private static boolean isIndexAndSizeIllegal(int index, int size) {
        return index < 0 || index >= size;
    }

    private static boolean isSizeIllegal(int size) {
        return size < 0;
    }
}

