/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.alternative;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.List;
import pl.zankowski.iextrading4j.api.marketdata.BookEntry;
import pl.zankowski.iextrading4j.api.util.ListUtil;

public class CryptoBookEvent
implements Serializable {
    private static final long serialVersionUID = -2249655496972607126L;
    private final String symbol;
    private final List<BookEntry> bid;
    private final List<BookEntry> ask;

    @JsonCreator
    public CryptoBookEvent(@JsonProperty(value="bids") List<BookEntry> bid, @JsonProperty(value="asks") List<BookEntry> ask, @JsonProperty(value="symbol") String symbol) {
        this.symbol = symbol;
        this.bid = ListUtil.immutableList(bid);
        this.ask = ListUtil.immutableList(ask);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public List<BookEntry> getBid() {
        return this.bid;
    }

    public List<BookEntry> getAsk() {
        return this.ask;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CryptoBookEvent that = (CryptoBookEvent)o;
        return Objects.equal((Object)this.symbol, (Object)that.symbol) && Objects.equal(this.bid, that.bid) && Objects.equal(this.ask, that.ask);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.symbol, this.bid, this.ask});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("symbol", (Object)this.symbol).add("bid", this.bid).add("ask", this.ask).toString();
    }
}

