/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.corporate;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;
import pl.zankowski.iextrading4j.api.corporate.CorporateData;

public class AdvancedDistribution
extends CorporateData {
    private static final long serialVersionUID = 3622240354483747567L;
    private final LocalDate recordDate;
    private final LocalDate paymentDate;
    private final LocalDate withdrawalFromDate;
    private final LocalDate withdrawalToDate;
    private final LocalDate electionDate;
    private final BigDecimal minPrice;
    private final BigDecimal maxPrice;
    private final BigDecimal hasWithdrawalRights;

    @JsonCreator
    public AdvancedDistribution(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="id") String id, @JsonProperty(value="key") String key, @JsonProperty(value="subkey") String subkey, @JsonProperty(value="updated") Long updated, @JsonProperty(value="refid") String refid, @JsonProperty(value="source") String source, @JsonProperty(value="date") Long date, @JsonProperty(value="created") LocalDate created, @JsonProperty(value="lastUpdated") LocalDate lastUpdated, @JsonProperty(value="notes") String notes, @JsonProperty(value="figi") String figi, @JsonProperty(value="parValue") BigDecimal parValue, @JsonProperty(value="parValueCurrency") String parValueCurrency, @JsonProperty(value="exDate") LocalDate exDate, @JsonProperty(value="recordDate") LocalDate recordDate, @JsonProperty(value="paymentDate") LocalDate paymentDate, @JsonProperty(value="withdrawalFromDate") LocalDate withdrawalFromDate, @JsonProperty(value="withdrawalToDate") LocalDate withdrawalToDate, @JsonProperty(value="electionDate") LocalDate electionDate, @JsonProperty(value="fromFactor") BigDecimal fromFactor, @JsonProperty(value="toFactor") BigDecimal toFactor, @JsonProperty(value="ratio") BigDecimal ratio, @JsonProperty(value="minPrice") BigDecimal minPrice, @JsonProperty(value="maxPrice") BigDecimal maxPrice, @JsonProperty(value="description") String description, @JsonProperty(value="flag") String flag, @JsonProperty(value="securityType") String securityType, @JsonProperty(value="hasWithdrawalRights") BigDecimal hasWithdrawalRights, @JsonProperty(value="countryCode") String countryCode) {
        super(symbol, id, key, subkey, updated, refid, source, date, created, lastUpdated, notes, figi, parValue, parValueCurrency, description, flag, securityType, fromFactor, toFactor, ratio, exDate, countryCode);
        this.recordDate = recordDate;
        this.paymentDate = paymentDate;
        this.withdrawalFromDate = withdrawalFromDate;
        this.withdrawalToDate = withdrawalToDate;
        this.electionDate = electionDate;
        this.minPrice = minPrice;
        this.maxPrice = maxPrice;
        this.hasWithdrawalRights = hasWithdrawalRights;
    }

    public LocalDate getRecordDate() {
        return this.recordDate;
    }

    public LocalDate getPaymentDate() {
        return this.paymentDate;
    }

    public LocalDate getWithdrawalFromDate() {
        return this.withdrawalFromDate;
    }

    public LocalDate getWithdrawalToDate() {
        return this.withdrawalToDate;
    }

    public LocalDate getElectionDate() {
        return this.electionDate;
    }

    public BigDecimal getMinPrice() {
        return this.minPrice;
    }

    public BigDecimal getMaxPrice() {
        return this.maxPrice;
    }

    public BigDecimal getHasWithdrawalRights() {
        return this.hasWithdrawalRights;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        AdvancedDistribution that = (AdvancedDistribution)o;
        return Objects.equals(this.recordDate, that.recordDate) && Objects.equals(this.paymentDate, that.paymentDate) && Objects.equals(this.withdrawalFromDate, that.withdrawalFromDate) && Objects.equals(this.withdrawalToDate, that.withdrawalToDate) && Objects.equals(this.electionDate, that.electionDate) && Objects.equals(this.minPrice, that.minPrice) && Objects.equals(this.maxPrice, that.maxPrice) && Objects.equals(this.hasWithdrawalRights, that.hasWithdrawalRights);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.recordDate, this.paymentDate, this.withdrawalFromDate, this.withdrawalToDate, this.electionDate, this.minPrice, this.maxPrice, this.hasWithdrawalRights);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", AdvancedDistribution.class.getSimpleName() + "[", "]").add("recordDate=" + this.recordDate).add("paymentDate=" + this.paymentDate).add("withdrawalFromDate=" + this.withdrawalFromDate).add("withdrawalToDate=" + this.withdrawalToDate).add("electionDate=" + this.electionDate).add("minPrice=" + this.minPrice).add("maxPrice=" + this.maxPrice).add("hasWithdrawalRights=" + this.hasWithdrawalRights).add("countryCode='" + this.getCountryCode() + "'").add("refid='" + this.getRefid() + "'").add("source='" + this.getSource() + "'").add("date=" + this.getDate()).add("created=" + this.getCreated()).add("lastUpdated=" + this.getLastUpdated()).add("notes='" + this.getNotes() + "'").add("figi='" + this.getFigi() + "'").add("description='" + this.getDescription() + "'").add("flag='" + this.getFlag() + "'").add("securityType='" + this.getSecurityType() + "'").add("fromFactor=" + this.getFromFactor()).add("toFactor=" + this.getToFactor()).add("ratio=" + this.getRatio()).add("parValue=" + this.getParValue()).add("parValueCurrency='" + this.getParValueCurrency() + "'").add("exDate=" + this.getExDate()).add("symbol='" + this.getSymbol() + "'").add("id='" + this.getId() + "'").add("key='" + this.getKey() + "'").add("subkey='" + this.getSubkey() + "'").add("updated=" + this.getUpdated()).toString();
    }
}

