/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.corporate;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;
import pl.zankowski.iextrading4j.api.stocks.v1.BaseData;

public abstract class CorporateData
extends BaseData {
    private static final long serialVersionUID = -1484007127414346002L;
    private final String refid;
    private final String source;
    private final Long date;
    private final LocalDate created;
    private final LocalDate lastUpdated;
    private final String notes;
    private final String figi;
    private final String description;
    private final String flag;
    private final String securityType;
    private final BigDecimal fromFactor;
    private final BigDecimal toFactor;
    private final BigDecimal ratio;
    private final BigDecimal parValue;
    private final String parValueCurrency;
    private final LocalDate exDate;
    private final String countryCode;

    public CorporateData(String symbol, String id, String key, String subkey, Long updated, String refid, String source, Long date, LocalDate created, LocalDate lastUpdated, String notes, String figi, BigDecimal parValue, String parValueCurrency, String description, String flag, String securityType, BigDecimal fromFactor, BigDecimal toFactor, BigDecimal ratio, LocalDate exDate, String countryCode) {
        super(symbol, id, key, subkey, updated);
        this.refid = refid;
        this.source = source;
        this.date = date;
        this.created = created;
        this.lastUpdated = lastUpdated;
        this.notes = notes;
        this.figi = figi;
        this.parValue = parValue;
        this.parValueCurrency = parValueCurrency;
        this.description = description;
        this.flag = flag;
        this.securityType = securityType;
        this.fromFactor = fromFactor;
        this.toFactor = toFactor;
        this.ratio = ratio;
        this.exDate = exDate;
        this.countryCode = countryCode;
    }

    public String getRefid() {
        return this.refid;
    }

    public String getSource() {
        return this.source;
    }

    public Long getDate() {
        return this.date;
    }

    public LocalDate getCreated() {
        return this.created;
    }

    public LocalDate getLastUpdated() {
        return this.lastUpdated;
    }

    public String getNotes() {
        return this.notes;
    }

    public String getFigi() {
        return this.figi;
    }

    public String getDescription() {
        return this.description;
    }

    public String getFlag() {
        return this.flag;
    }

    public String getSecurityType() {
        return this.securityType;
    }

    public BigDecimal getFromFactor() {
        return this.fromFactor;
    }

    public BigDecimal getToFactor() {
        return this.toFactor;
    }

    public BigDecimal getRatio() {
        return this.ratio;
    }

    public BigDecimal getParValue() {
        return this.parValue;
    }

    public String getParValueCurrency() {
        return this.parValueCurrency;
    }

    public LocalDate getExDate() {
        return this.exDate;
    }

    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CorporateData that = (CorporateData)o;
        return Objects.equals(this.refid, that.refid) && Objects.equals(this.source, that.source) && Objects.equals(this.date, that.date) && Objects.equals(this.created, that.created) && Objects.equals(this.lastUpdated, that.lastUpdated) && Objects.equals(this.notes, that.notes) && Objects.equals(this.figi, that.figi) && Objects.equals(this.description, that.description) && Objects.equals(this.flag, that.flag) && Objects.equals(this.securityType, that.securityType) && Objects.equals(this.fromFactor, that.fromFactor) && Objects.equals(this.toFactor, that.toFactor) && Objects.equals(this.ratio, that.ratio) && Objects.equals(this.parValue, that.parValue) && Objects.equals(this.parValueCurrency, that.parValueCurrency) && Objects.equals(this.exDate, that.exDate) && Objects.equals(this.countryCode, that.countryCode);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.refid, this.source, this.date, this.created, this.lastUpdated, this.notes, this.figi, this.description, this.flag, this.securityType, this.fromFactor, this.toFactor, this.ratio, this.parValue, this.parValueCurrency, this.exDate, this.countryCode);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", CorporateData.class.getSimpleName() + "[", "]").add("refid='" + this.refid + "'").add("source='" + this.source + "'").add("date=" + this.date).add("created=" + this.created).add("lastUpdated=" + this.lastUpdated).add("notes='" + this.notes + "'").add("figi='" + this.figi + "'").add("description='" + this.description + "'").add("flag='" + this.flag + "'").add("securityType='" + this.securityType + "'").add("fromFactor=" + this.fromFactor).add("toFactor=" + this.toFactor).add("ratio=" + this.ratio).add("parValue=" + this.parValue).add("parValueCurrency='" + this.parValueCurrency + "'").add("exDate=" + this.exDate).add("countryCode='" + this.countryCode + "'").add("symbol='" + this.getSymbol() + "'").add("id='" + this.getId() + "'").add("key='" + this.getKey() + "'").add("subkey='" + this.getSubkey() + "'").add("updated=" + this.getUpdated()).toString();
    }
}

