/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.marketdata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.math.BigDecimal;
import java.time.LocalTime;
import pl.zankowski.iextrading4j.api.marketdata.AuctionType;
import pl.zankowski.iextrading4j.api.marketdata.DeepResult;

public class Auction
implements DeepResult {
    private static final long serialVersionUID = 5635671777545800835L;
    private final AuctionType auctionType;
    private final BigDecimal pairedShares;
    private final BigDecimal imbalanceShares;
    private final BigDecimal referencePrice;
    private final BigDecimal indicativePrice;
    private final BigDecimal auctionBookPrice;
    private final BigDecimal collarReferencePrice;
    private final BigDecimal lowerCollarPrice;
    private final BigDecimal upperCollarPrice;
    private final BigDecimal extensionNumber;
    private final LocalTime startTime;
    private final Long lastUpdate;

    @JsonCreator
    public Auction(@JsonProperty(value="auctionType") AuctionType auctionType, @JsonProperty(value="pairedShares") BigDecimal pairedShares, @JsonProperty(value="imbalanceShares") BigDecimal imbalanceShares, @JsonProperty(value="referencePrice") BigDecimal referencePrice, @JsonProperty(value="indicativePrice") BigDecimal indicativePrice, @JsonProperty(value="auctionBookPrice") BigDecimal auctionBookPrice, @JsonProperty(value="collarReferencePrice") BigDecimal collarReferencePrice, @JsonProperty(value="lowerCollarPrice") BigDecimal lowerCollarPrice, @JsonProperty(value="upperCollarPrice") BigDecimal upperCollarPrice, @JsonProperty(value="extensionNumber") BigDecimal extensionNumber, @JsonProperty(value="startTime") LocalTime startTime, @JsonProperty(value="lastUpdate") Long lastUpdate) {
        this.auctionType = auctionType;
        this.pairedShares = pairedShares;
        this.imbalanceShares = imbalanceShares;
        this.referencePrice = referencePrice;
        this.indicativePrice = indicativePrice;
        this.auctionBookPrice = auctionBookPrice;
        this.collarReferencePrice = collarReferencePrice;
        this.lowerCollarPrice = lowerCollarPrice;
        this.upperCollarPrice = upperCollarPrice;
        this.extensionNumber = extensionNumber;
        this.startTime = startTime;
        this.lastUpdate = lastUpdate;
    }

    public AuctionType getAuctionType() {
        return this.auctionType;
    }

    public BigDecimal getPairedShares() {
        return this.pairedShares;
    }

    public BigDecimal getImbalanceShares() {
        return this.imbalanceShares;
    }

    public BigDecimal getReferencePrice() {
        return this.referencePrice;
    }

    public BigDecimal getIndicativePrice() {
        return this.indicativePrice;
    }

    public BigDecimal getAuctionBookPrice() {
        return this.auctionBookPrice;
    }

    public BigDecimal getCollarReferencePrice() {
        return this.collarReferencePrice;
    }

    public BigDecimal getLowerCollarPrice() {
        return this.lowerCollarPrice;
    }

    public BigDecimal getUpperCollarPrice() {
        return this.upperCollarPrice;
    }

    public BigDecimal getExtensionNumber() {
        return this.extensionNumber;
    }

    public LocalTime getStartTime() {
        return this.startTime;
    }

    public Long getLastUpdate() {
        return this.lastUpdate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Auction auction = (Auction)o;
        return this.auctionType == auction.auctionType && Objects.equal((Object)this.pairedShares, (Object)auction.pairedShares) && Objects.equal((Object)this.imbalanceShares, (Object)auction.imbalanceShares) && Objects.equal((Object)this.referencePrice, (Object)auction.referencePrice) && Objects.equal((Object)this.indicativePrice, (Object)auction.indicativePrice) && Objects.equal((Object)this.auctionBookPrice, (Object)auction.auctionBookPrice) && Objects.equal((Object)this.collarReferencePrice, (Object)auction.collarReferencePrice) && Objects.equal((Object)this.lowerCollarPrice, (Object)auction.lowerCollarPrice) && Objects.equal((Object)this.upperCollarPrice, (Object)auction.upperCollarPrice) && Objects.equal((Object)this.extensionNumber, (Object)auction.extensionNumber) && Objects.equal((Object)this.startTime, (Object)auction.startTime) && Objects.equal((Object)this.lastUpdate, (Object)auction.lastUpdate);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.auctionType, this.pairedShares, this.imbalanceShares, this.referencePrice, this.indicativePrice, this.auctionBookPrice, this.collarReferencePrice, this.lowerCollarPrice, this.upperCollarPrice, this.extensionNumber, this.startTime, this.lastUpdate});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("auctionType", (Object)this.auctionType).add("pairedShares", (Object)this.pairedShares).add("imbalanceShares", (Object)this.imbalanceShares).add("referencePrice", (Object)this.referencePrice).add("indicativePrice", (Object)this.indicativePrice).add("auctionBookPrice", (Object)this.auctionBookPrice).add("collarReferencePrice", (Object)this.collarReferencePrice).add("lowerCollarPrice", (Object)this.lowerCollarPrice).add("upperCollarPrice", (Object)this.upperCollarPrice).add("extensionNumber", (Object)this.extensionNumber).add("startTime", (Object)this.startTime).add("lastUpdate", (Object)this.lastUpdate).toString();
    }
}

