/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.marketdata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.List;
import pl.zankowski.iextrading4j.api.marketdata.BookEntry;
import pl.zankowski.iextrading4j.api.marketdata.DeepResult;
import pl.zankowski.iextrading4j.api.util.ListUtil;

public class Book
implements DeepResult {
    private static final long serialVersionUID = -5500382403416100795L;
    private final String symbol;
    private final List<BookEntry> bids;
    private final List<BookEntry> asks;

    @JsonCreator
    public Book(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="bids") List<BookEntry> bids, @JsonProperty(value="asks") List<BookEntry> asks) {
        this.symbol = symbol;
        this.bids = ListUtil.immutableList(bids);
        this.asks = ListUtil.immutableList(asks);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public List<BookEntry> getBids() {
        return this.bids;
    }

    public List<BookEntry> getAsks() {
        return this.asks;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Book book = (Book)o;
        return Objects.equal((Object)this.symbol, (Object)book.symbol) && Objects.equal(this.bids, book.bids) && Objects.equal(this.asks, book.asks);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.symbol, this.bids, this.asks});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("symbol", (Object)this.symbol).add("bids", this.bids).add("asks", this.asks).toString();
    }
}

