/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.marketdata;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.math.BigDecimal;
import pl.zankowski.iextrading4j.api.marketdata.DeepResult;

public class Trade
implements DeepResult {
    private static final long serialVersionUID = -1447468079664257972L;
    private final BigDecimal price;
    private final BigDecimal size;
    private final Long tradeId;
    private final Boolean isISO;
    private final Boolean isOddLot;
    private final Boolean isOutsideRegularHours;
    private final Boolean isSinglePriceCross;
    private final Boolean isTradeThroughExempt;
    private final Long timestamp;

    @JsonCreator
    public Trade(@JsonProperty(value="price") BigDecimal price, @JsonProperty(value="size") BigDecimal size, @JsonProperty(value="tradeId") Long tradeId, @JsonProperty(value="isISO") Boolean isISO, @JsonProperty(value="isOddLot") Boolean isOddLot, @JsonProperty(value="isOutsideRegularHours") Boolean isOutsideRegularHours, @JsonProperty(value="isSinglePriceCross") Boolean isSinglePriceCross, @JsonProperty(value="isTradeThroughExempt") Boolean isTradeThroughExempt, @JsonProperty(value="timestamp") Long timestamp) {
        this.price = price;
        this.size = size;
        this.tradeId = tradeId;
        this.isISO = isISO;
        this.isOddLot = isOddLot;
        this.isOutsideRegularHours = isOutsideRegularHours;
        this.isSinglePriceCross = isSinglePriceCross;
        this.isTradeThroughExempt = isTradeThroughExempt;
        this.timestamp = timestamp;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public BigDecimal getSize() {
        return this.size;
    }

    public Long getTradeId() {
        return this.tradeId;
    }

    @JsonProperty(value="isISO")
    public Boolean isISO() {
        return this.isISO;
    }

    @JsonProperty(value="isOddLot")
    public Boolean isOddLot() {
        return this.isOddLot;
    }

    @JsonProperty(value="isOutsideRegularHours")
    public Boolean isOutsideRegularHours() {
        return this.isOutsideRegularHours;
    }

    @JsonProperty(value="isSinglePriceCross")
    public Boolean isSinglePriceCross() {
        return this.isSinglePriceCross;
    }

    @JsonProperty(value="isTradeThroughExempt")
    public Boolean isTradeThroughExempt() {
        return this.isTradeThroughExempt;
    }

    public Long getTimestamp() {
        return this.timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Trade trade = (Trade)o;
        return Objects.equal((Object)this.price, (Object)trade.price) && Objects.equal((Object)this.size, (Object)trade.size) && Objects.equal((Object)this.tradeId, (Object)trade.tradeId) && Objects.equal((Object)this.isISO, (Object)trade.isISO) && Objects.equal((Object)this.isOddLot, (Object)trade.isOddLot) && Objects.equal((Object)this.isOutsideRegularHours, (Object)trade.isOutsideRegularHours) && Objects.equal((Object)this.isSinglePriceCross, (Object)trade.isSinglePriceCross) && Objects.equal((Object)this.isTradeThroughExempt, (Object)trade.isTradeThroughExempt) && Objects.equal((Object)this.timestamp, (Object)trade.timestamp);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.price, this.size, this.tradeId, this.isISO, this.isOddLot, this.isOutsideRegularHours, this.isSinglePriceCross, this.isTradeThroughExempt, this.timestamp});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("price", (Object)this.price).add("size", (Object)this.size).add("tradeId", (Object)this.tradeId).add("isISO", (Object)this.isISO).add("isOddLot", (Object)this.isOddLot).add("isOutsideRegularHours", (Object)this.isOutsideRegularHours).add("isSinglePriceCross", (Object)this.isSinglePriceCross).add("isTradeThroughExempt", (Object)this.isTradeThroughExempt).add("timestamp", (Object)this.timestamp).toString();
    }
}

