/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.List;
import pl.zankowski.iextrading4j.api.marketdata.BookEntry;
import pl.zankowski.iextrading4j.api.marketdata.SystemEvent;
import pl.zankowski.iextrading4j.api.marketdata.Trade;
import pl.zankowski.iextrading4j.api.stocks.Quote;
import pl.zankowski.iextrading4j.api.util.ListUtil;

public class Book
implements Serializable {
    private static final long serialVersionUID = -251227870271833278L;
    private final Quote quote;
    private final List<BookEntry> bids;
    private final List<BookEntry> asks;
    private final List<Trade> trades;
    private final SystemEvent systemEvent;

    @JsonCreator
    public Book(@JsonProperty(value="quote") Quote quote, @JsonProperty(value="bids") List<BookEntry> bids, @JsonProperty(value="asks") List<BookEntry> asks, @JsonProperty(value="trades") List<Trade> trades, @JsonProperty(value="systemEvent") SystemEvent systemEvent) {
        this.quote = quote;
        this.bids = ListUtil.immutableList(bids);
        this.asks = ListUtil.immutableList(asks);
        this.trades = ListUtil.immutableList(trades);
        this.systemEvent = systemEvent;
    }

    public Quote getQuote() {
        return this.quote;
    }

    public List<BookEntry> getBids() {
        return this.bids;
    }

    public List<BookEntry> getAsks() {
        return this.asks;
    }

    public List<Trade> getTrades() {
        return this.trades;
    }

    public SystemEvent getSystemEvent() {
        return this.systemEvent;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Book book = (Book)o;
        return Objects.equal((Object)this.quote, (Object)book.quote) && Objects.equal(this.bids, book.bids) && Objects.equal(this.asks, book.asks) && Objects.equal(this.trades, book.trades) && Objects.equal((Object)this.systemEvent, (Object)book.systemEvent);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.quote, this.bids, this.asks, this.trades, this.systemEvent});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("quote", (Object)this.quote).add("bids", this.bids).add("asks", this.asks).add("trades", this.trades).add("systemEvent", (Object)this.systemEvent).toString();
    }
}

