/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.List;
import java.util.Objects;
import java.util.StringJoiner;
import pl.zankowski.iextrading4j.api.stocks.TimeSeries;
import pl.zankowski.iextrading4j.api.util.ListUtil;

public class Chart
extends TimeSeries {
    private static final long serialVersionUID = -9161802845718659470L;
    private final String minute;
    private final BigDecimal marketAverage;
    private final BigDecimal marketNotional;
    private final BigDecimal marketNumberOfTrades;
    private final BigDecimal marketHigh;
    private final BigDecimal marketLow;
    private final BigDecimal marketVolume;
    private final BigDecimal marketChangeOverTime;
    private final BigDecimal marketOpen;
    private final BigDecimal marketClose;
    private final BigDecimal average;
    private final BigDecimal notional;
    private final BigDecimal numberOfTrades;
    private final List<BigDecimal> simplifyFactor;
    private final String currency;

    @JsonCreator
    public Chart(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="id") String id, @JsonProperty(value="key") String key, @JsonProperty(value="subkey") String subkey, @JsonProperty(value="updated") Long updated, @JsonProperty(value="minute") String minute, @JsonProperty(value="marketAverage") BigDecimal marketAverage, @JsonProperty(value="marketNotional") BigDecimal marketNotional, @JsonProperty(value="marketNumberOfTrades") BigDecimal marketNumberOfTrades, @JsonProperty(value="marketHigh") BigDecimal marketHigh, @JsonProperty(value="marketLow") BigDecimal marketLow, @JsonProperty(value="marketVolume") BigDecimal marketVolume, @JsonProperty(value="marketChangeOverTime") BigDecimal marketChangeOverTime, @JsonProperty(value="marketOpen") BigDecimal marketOpen, @JsonProperty(value="marketClose") BigDecimal marketClose, @JsonProperty(value="average") BigDecimal average, @JsonProperty(value="notional") BigDecimal notional, @JsonProperty(value="numberOfTrades") BigDecimal numberOfTrades, @JsonProperty(value="simplifyFactor") List<BigDecimal> simplifyFactor, @JsonProperty(value="high") BigDecimal high, @JsonProperty(value="low") BigDecimal low, @JsonProperty(value="volume") BigDecimal volume, @JsonProperty(value="label") String label, @JsonProperty(value="changeOverTime") BigDecimal changeOverTime, @JsonProperty(value="date") String date, @JsonProperty(value="open") BigDecimal open, @JsonProperty(value="close") BigDecimal close, @JsonProperty(value="uOpen") BigDecimal uOpen, @JsonProperty(value="uHigh") BigDecimal uHigh, @JsonProperty(value="uLow") BigDecimal uLow, @JsonProperty(value="uClose") BigDecimal uClose, @JsonProperty(value="uVolume") BigDecimal uVolume, @JsonProperty(value="fOpen") BigDecimal fOpen, @JsonProperty(value="fHigh") BigDecimal fHigh, @JsonProperty(value="fLow") BigDecimal fLow, @JsonProperty(value="fClose") BigDecimal fClose, @JsonProperty(value="fVolume") BigDecimal fVolume, @JsonProperty(value="unadjustedVolume") BigDecimal unadjustedVolume, @JsonProperty(value="change") BigDecimal change, @JsonProperty(value="changePercent") BigDecimal changePercent, @JsonProperty(value="vwap") BigDecimal vwap, @JsonProperty(value="currency") String currency) {
        super(symbol, id, key, subkey, updated, date, open, high, low, close, volume, uOpen, uHigh, uLow, uClose, uVolume, fOpen, fHigh, fLow, fClose, fVolume, unadjustedVolume, change, changePercent, vwap, label, changeOverTime);
        this.minute = minute;
        this.marketAverage = marketAverage;
        this.marketNotional = marketNotional;
        this.marketNumberOfTrades = marketNumberOfTrades;
        this.marketHigh = marketHigh;
        this.marketLow = marketLow;
        this.marketVolume = marketVolume;
        this.marketChangeOverTime = marketChangeOverTime;
        this.marketOpen = marketOpen;
        this.marketClose = marketClose;
        this.average = average;
        this.notional = notional;
        this.numberOfTrades = numberOfTrades;
        this.simplifyFactor = ListUtil.immutableList(simplifyFactor);
        this.currency = currency;
    }

    public String getMinute() {
        return this.minute;
    }

    public BigDecimal getMarketAverage() {
        return this.marketAverage;
    }

    public BigDecimal getMarketNotional() {
        return this.marketNotional;
    }

    public BigDecimal getMarketNumberOfTrades() {
        return this.marketNumberOfTrades;
    }

    public BigDecimal getMarketHigh() {
        return this.marketHigh;
    }

    public BigDecimal getMarketLow() {
        return this.marketLow;
    }

    public BigDecimal getMarketVolume() {
        return this.marketVolume;
    }

    public BigDecimal getMarketChangeOverTime() {
        return this.marketChangeOverTime;
    }

    public BigDecimal getMarketOpen() {
        return this.marketOpen;
    }

    public BigDecimal getMarketClose() {
        return this.marketClose;
    }

    public BigDecimal getAverage() {
        return this.average;
    }

    public BigDecimal getNotional() {
        return this.notional;
    }

    public BigDecimal getNumberOfTrades() {
        return this.numberOfTrades;
    }

    public List<BigDecimal> getSimplifyFactor() {
        return this.simplifyFactor;
    }

    public String getCurrency() {
        return this.currency;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Chart chart = (Chart)o;
        return Objects.equals(this.minute, chart.minute) && Objects.equals(this.marketAverage, chart.marketAverage) && Objects.equals(this.marketNotional, chart.marketNotional) && Objects.equals(this.marketNumberOfTrades, chart.marketNumberOfTrades) && Objects.equals(this.marketHigh, chart.marketHigh) && Objects.equals(this.marketLow, chart.marketLow) && Objects.equals(this.marketVolume, chart.marketVolume) && Objects.equals(this.marketChangeOverTime, chart.marketChangeOverTime) && Objects.equals(this.marketOpen, chart.marketOpen) && Objects.equals(this.marketClose, chart.marketClose) && Objects.equals(this.average, chart.average) && Objects.equals(this.notional, chart.notional) && Objects.equals(this.numberOfTrades, chart.numberOfTrades) && Objects.equals(this.simplifyFactor, chart.simplifyFactor) && Objects.equals(this.currency, chart.currency);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.minute, this.marketAverage, this.marketNotional, this.marketNumberOfTrades, this.marketHigh, this.marketLow, this.marketVolume, this.marketChangeOverTime, this.marketOpen, this.marketClose, this.average, this.notional, this.numberOfTrades, this.simplifyFactor, this.currency);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", Chart.class.getSimpleName() + "[", "]").add("minute='" + this.minute + "'").add("marketAverage=" + this.marketAverage).add("marketNotional=" + this.marketNotional).add("marketNumberOfTrades=" + this.marketNumberOfTrades).add("marketHigh=" + this.marketHigh).add("marketLow=" + this.marketLow).add("marketVolume=" + this.marketVolume).add("marketChangeOverTime=" + this.marketChangeOverTime).add("marketOpen=" + this.marketOpen).add("marketClose=" + this.marketClose).add("average=" + this.average).add("notional=" + this.notional).add("numberOfTrades=" + this.numberOfTrades).add("simplifyFactor=" + this.simplifyFactor).add("currency='" + this.currency + "'").toString();
    }
}

