/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import pl.zankowski.iextrading4j.api.util.ListUtil;

public class Company
implements Serializable {
    private static final long serialVersionUID = 1665863689707337670L;
    private final String symbol;
    private final String companyName;
    private final String exchange;
    private final String industry;
    private final String website;
    private final String description;
    private final String CEO;
    private final String securityName;
    private final String issueType;
    private final String sector;
    private final BigDecimal employees;
    private final List<String> tags;
    private final String address;
    private final String address2;
    private final String state;
    private final String city;
    private final String zip;
    private final String country;
    private final String phone;
    private final String primarySicCode;

    @JsonCreator
    public Company(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="companyName") String companyName, @JsonProperty(value="exchange") String exchange, @JsonProperty(value="industry") String industry, @JsonProperty(value="website") String website, @JsonProperty(value="description") String description, @JsonProperty(value="CEO") String CEO, @JsonProperty(value="securityName") String securityName, @JsonProperty(value="issueType") String issueType, @JsonProperty(value="sector") String sector, @JsonProperty(value="employees") BigDecimal employees, @JsonProperty(value="tags") List<String> tags, @JsonProperty(value="address") String address, @JsonProperty(value="address2") String address2, @JsonProperty(value="state") String state, @JsonProperty(value="city") String city, @JsonProperty(value="zip") String zip, @JsonProperty(value="country") String country, @JsonProperty(value="phone") String phone, @JsonProperty(value="primarySicCode") String primarySicCode) {
        this.symbol = symbol;
        this.companyName = companyName;
        this.exchange = exchange;
        this.industry = industry;
        this.website = website;
        this.description = description;
        this.CEO = CEO;
        this.securityName = securityName;
        this.issueType = issueType;
        this.sector = sector;
        this.employees = employees;
        this.tags = ListUtil.immutableList(tags);
        this.address = address;
        this.address2 = address2;
        this.state = state;
        this.city = city;
        this.zip = zip;
        this.country = country;
        this.phone = phone;
        this.primarySicCode = primarySicCode;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public String getExchange() {
        return this.exchange;
    }

    public String getIndustry() {
        return this.industry;
    }

    public String getWebsite() {
        return this.website;
    }

    public String getDescription() {
        return this.description;
    }

    @JsonProperty(value="CEO")
    public String getCEO() {
        return this.CEO;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public String getIssueType() {
        return this.issueType;
    }

    public String getSector() {
        return this.sector;
    }

    public BigDecimal getEmployees() {
        return this.employees;
    }

    public List<String> getTags() {
        return this.tags;
    }

    public String getAddress() {
        return this.address;
    }

    public String getAddress2() {
        return this.address2;
    }

    public String getState() {
        return this.state;
    }

    public String getCity() {
        return this.city;
    }

    public String getZip() {
        return this.zip;
    }

    public String getCountry() {
        return this.country;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getPrimarySicCode() {
        return this.primarySicCode;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Company company = (Company)o;
        return Objects.equal((Object)this.symbol, (Object)company.symbol) && Objects.equal((Object)this.companyName, (Object)company.companyName) && Objects.equal((Object)this.exchange, (Object)company.exchange) && Objects.equal((Object)this.industry, (Object)company.industry) && Objects.equal((Object)this.website, (Object)company.website) && Objects.equal((Object)this.description, (Object)company.description) && Objects.equal((Object)this.CEO, (Object)company.CEO) && Objects.equal((Object)this.securityName, (Object)company.securityName) && Objects.equal((Object)this.issueType, (Object)company.issueType) && Objects.equal((Object)this.sector, (Object)company.sector) && Objects.equal((Object)this.employees, (Object)company.employees) && Objects.equal(this.tags, company.tags) && Objects.equal((Object)this.address, (Object)company.address) && Objects.equal((Object)this.address2, (Object)company.address2) && Objects.equal((Object)this.state, (Object)company.state) && Objects.equal((Object)this.city, (Object)company.city) && Objects.equal((Object)this.zip, (Object)company.zip) && Objects.equal((Object)this.country, (Object)company.country) && Objects.equal((Object)this.phone, (Object)company.phone) && Objects.equal((Object)this.primarySicCode, (Object)company.primarySicCode);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.symbol, this.companyName, this.exchange, this.industry, this.website, this.description, this.CEO, this.securityName, this.issueType, this.sector, this.employees, this.tags, this.address, this.address2, this.state, this.city, this.zip, this.country, this.phone, this.primarySicCode});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("symbol", (Object)this.symbol).add("companyName", (Object)this.companyName).add("exchange", (Object)this.exchange).add("industry", (Object)this.industry).add("website", (Object)this.website).add("description", (Object)this.description).add("CEO", (Object)this.CEO).add("securityName", (Object)this.securityName).add("issueType", (Object)this.issueType).add("sector", (Object)this.sector).add("employees", (Object)this.employees).add("tags", this.tags).add("address", (Object)this.address).add("address2", (Object)this.address2).add("state", (Object)this.state).add("city", (Object)this.city).add("zip", (Object)this.zip).add("country", (Object)this.country).add("phone", (Object)this.phone).add("primarySicCode", (Object)this.primarySicCode).toString();
    }
}

