/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

public class Earning
implements Serializable {
    private static final long serialVersionUID = -3254561425537119565L;
    private final BigDecimal actualEPS;
    private final BigDecimal consensusEPS;
    private final BigDecimal estimatedEPS;
    private final String announceTime;
    private final BigDecimal numberOfEstimates;
    private final BigDecimal EPSSurpriseDollar;
    private final LocalDate EPSReportDate;
    private final String fiscalPeriod;
    private final LocalDate fiscalEndDate;
    private final BigDecimal yearAgo;
    private final BigDecimal yearAgoChangePercent;
    private final String currency;

    @JsonCreator
    public Earning(@JsonProperty(value="actualEPS") BigDecimal actualEPS, @JsonProperty(value="consensusEPS") BigDecimal consensusEPS, @JsonProperty(value="estimatedEPS") BigDecimal estimatedEPS, @JsonProperty(value="announceTime") String announceTime, @JsonProperty(value="numberOfEstimates") BigDecimal numberOfEstimates, @JsonProperty(value="EPSSurpriseDollar") BigDecimal EPSSurpriseDollar, @JsonProperty(value="EPSReportDate") LocalDate EPSReportDate, @JsonProperty(value="fiscalPeriod") String fiscalPeriod, @JsonProperty(value="fiscalEndDate") LocalDate fiscalEndDate, @JsonProperty(value="yearAgo") BigDecimal yearAgo, @JsonProperty(value="yearAgoChangePercent") BigDecimal yearAgoChangePercent, @JsonProperty(value="currency") String currency) {
        this.actualEPS = actualEPS;
        this.consensusEPS = consensusEPS;
        this.estimatedEPS = estimatedEPS;
        this.announceTime = announceTime;
        this.numberOfEstimates = numberOfEstimates;
        this.EPSSurpriseDollar = EPSSurpriseDollar;
        this.EPSReportDate = EPSReportDate;
        this.fiscalPeriod = fiscalPeriod;
        this.fiscalEndDate = fiscalEndDate;
        this.yearAgo = yearAgo;
        this.yearAgoChangePercent = yearAgoChangePercent;
        this.currency = currency;
    }

    public BigDecimal getActualEPS() {
        return this.actualEPS;
    }

    public BigDecimal getConsensusEPS() {
        return this.consensusEPS;
    }

    public BigDecimal getEstimatedEPS() {
        return this.estimatedEPS;
    }

    public String getAnnounceTime() {
        return this.announceTime;
    }

    public BigDecimal getNumberOfEstimates() {
        return this.numberOfEstimates;
    }

    @JsonProperty(value="EPSSurpriseDollar")
    public BigDecimal getEPSSurpriseDollar() {
        return this.EPSSurpriseDollar;
    }

    @JsonProperty(value="EPSReportDate")
    public LocalDate getEPSReportDate() {
        return this.EPSReportDate;
    }

    public String getFiscalPeriod() {
        return this.fiscalPeriod;
    }

    public LocalDate getFiscalEndDate() {
        return this.fiscalEndDate;
    }

    public BigDecimal getYearAgo() {
        return this.yearAgo;
    }

    public BigDecimal getYearAgoChangePercent() {
        return this.yearAgoChangePercent;
    }

    public String getCurrency() {
        return this.currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Earning earning = (Earning)o;
        return Objects.equal((Object)this.actualEPS, (Object)earning.actualEPS) && Objects.equal((Object)this.consensusEPS, (Object)earning.consensusEPS) && Objects.equal((Object)this.estimatedEPS, (Object)earning.estimatedEPS) && Objects.equal((Object)this.announceTime, (Object)earning.announceTime) && Objects.equal((Object)this.numberOfEstimates, (Object)earning.numberOfEstimates) && Objects.equal((Object)this.EPSSurpriseDollar, (Object)earning.EPSSurpriseDollar) && Objects.equal((Object)this.EPSReportDate, (Object)earning.EPSReportDate) && Objects.equal((Object)this.fiscalPeriod, (Object)earning.fiscalPeriod) && Objects.equal((Object)this.fiscalEndDate, (Object)earning.fiscalEndDate) && Objects.equal((Object)this.yearAgo, (Object)earning.yearAgo) && Objects.equal((Object)this.yearAgoChangePercent, (Object)earning.yearAgoChangePercent) && Objects.equal((Object)this.currency, (Object)earning.currency);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.actualEPS, this.consensusEPS, this.estimatedEPS, this.announceTime, this.numberOfEstimates, this.EPSSurpriseDollar, this.EPSReportDate, this.fiscalPeriod, this.fiscalEndDate, this.yearAgo, this.yearAgoChangePercent, this.currency});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("actualEPS", (Object)this.actualEPS).add("consensusEPS", (Object)this.consensusEPS).add("estimatedEPS", (Object)this.estimatedEPS).add("announceTime", (Object)this.announceTime).add("numberOfEstimates", (Object)this.numberOfEstimates).add("EPSSurpriseDollar", (Object)this.EPSSurpriseDollar).add("EPSReportDate", (Object)this.EPSReportDate).add("fiscalPeriod", (Object)this.fiscalPeriod).add("fiscalEndDate", (Object)this.fiscalEndDate).add("yearAgo", (Object)this.yearAgo).add("yearAgoChangePercent", (Object)this.yearAgoChangePercent).add("currency", (Object)this.currency).toString();
    }
}

