/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.List;
import pl.zankowski.iextrading4j.api.stocks.Earning;
import pl.zankowski.iextrading4j.api.util.ListUtil;

public class Earnings
implements Serializable {
    private static final long serialVersionUID = 1072601094280484975L;
    private final String symbol;
    private final List<Earning> earnings;

    @JsonCreator
    public Earnings(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="earnings") List<Earning> earnings) {
        this.symbol = symbol;
        this.earnings = ListUtil.immutableList(earnings);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public List<Earning> getEarnings() {
        return this.earnings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Earnings earnings1 = (Earnings)o;
        return Objects.equal((Object)this.symbol, (Object)earnings1.symbol) && Objects.equal(this.earnings, earnings1.earnings);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.symbol, this.earnings});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("symbol", (Object)this.symbol).add("earnings", this.earnings).toString();
    }
}

