/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import pl.zankowski.iextrading4j.api.util.ListUtil;

public class Ipo
implements Serializable {
    private static final long serialVersionUID = 6433050561897952237L;
    private final String symbol;
    private final String companyName;
    private final LocalDate expectedDate;
    private final List<String> leadUnderwriters;
    private final List<String> underwriters;
    private final List<String> companyCounsel;
    private final List<String> underwriterCounsel;
    private final String auditor;
    private final String market;
    private final String cik;
    private final String address;
    private final String city;
    private final String state;
    private final String zip;
    private final String phone;
    private final String ceo;
    private final BigDecimal employees;
    private final String url;
    private final String status;
    private final BigDecimal sharesOffered;
    private final BigDecimal priceLow;
    private final BigDecimal priceHigh;
    private final BigDecimal offerAmount;
    private final BigDecimal totalExpenses;
    private final BigDecimal sharesOverAlloted;
    private final BigDecimal shareholderShares;
    private final BigDecimal sharesOutstanding;
    private final LocalDate lockupPeriodExpiration;
    private final LocalDate quietPeriodExpiration;
    private final BigDecimal revenue;
    private final BigDecimal netIncome;
    private final BigDecimal totalAssets;
    private final BigDecimal totalLiabilities;
    private final BigDecimal stockholderEquity;
    private final String companyDescription;
    private final String businessDescription;
    private final String useOfProceeds;
    private final String competition;
    private final BigDecimal amount;
    private final BigDecimal percentOffered;

    @JsonCreator
    public Ipo(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="companyName") String companyName, @JsonProperty(value="expectedDate") LocalDate expectedDate, @JsonProperty(value="leadUnderwriters") List<String> leadUnderwriters, @JsonProperty(value="underwriters") List<String> underwriters, @JsonProperty(value="companyCounsel") List<String> companyCounsel, @JsonProperty(value="underwriterCounsel") List<String> underwriterCounsel, @JsonProperty(value="auditor") String auditor, @JsonProperty(value="market") String market, @JsonProperty(value="cik") String cik, @JsonProperty(value="address") String address, @JsonProperty(value="city") String city, @JsonProperty(value="state") String state, @JsonProperty(value="zip") String zip, @JsonProperty(value="phone") String phone, @JsonProperty(value="ceo") String ceo, @JsonProperty(value="employees") BigDecimal employees, @JsonProperty(value="url") String url, @JsonProperty(value="status") String status, @JsonProperty(value="sharesOffered") BigDecimal sharesOffered, @JsonProperty(value="priceLow") BigDecimal priceLow, @JsonProperty(value="priceHigh") BigDecimal priceHigh, @JsonProperty(value="offerAmount") BigDecimal offerAmount, @JsonProperty(value="totalExpenses") BigDecimal totalExpenses, @JsonProperty(value="sharesOverAlloted") BigDecimal sharesOverAlloted, @JsonProperty(value="shareholderShares") BigDecimal shareholderShares, @JsonProperty(value="sharesOutstanding") BigDecimal sharesOutstanding, @JsonProperty(value="lockupPeriodExpiration") LocalDate lockupPeriodExpiration, @JsonProperty(value="quietPeriodExpiration") LocalDate quietPeriodExpiration, @JsonProperty(value="revenue") BigDecimal revenue, @JsonProperty(value="netIncome") BigDecimal netIncome, @JsonProperty(value="totalAssets") BigDecimal totalAssets, @JsonProperty(value="totalLiabilities") BigDecimal totalLiabilities, @JsonProperty(value="stockholderEquity") BigDecimal stockholderEquity, @JsonProperty(value="companyDescription") String companyDescription, @JsonProperty(value="businessDescription") String businessDescription, @JsonProperty(value="useOfProceeds") String useOfProceeds, @JsonProperty(value="competition") String competition, @JsonProperty(value="amount") BigDecimal amount, @JsonProperty(value="percentOffered") BigDecimal percentOffered) {
        this.symbol = symbol;
        this.companyName = companyName;
        this.expectedDate = expectedDate;
        this.leadUnderwriters = ListUtil.immutableList(leadUnderwriters);
        this.underwriters = ListUtil.immutableList(underwriters);
        this.companyCounsel = ListUtil.immutableList(companyCounsel);
        this.underwriterCounsel = ListUtil.immutableList(underwriterCounsel);
        this.auditor = auditor;
        this.market = market;
        this.cik = cik;
        this.address = address;
        this.city = city;
        this.state = state;
        this.zip = zip;
        this.phone = phone;
        this.ceo = ceo;
        this.employees = employees;
        this.url = url;
        this.status = status;
        this.sharesOffered = sharesOffered;
        this.priceLow = priceLow;
        this.priceHigh = priceHigh;
        this.offerAmount = offerAmount;
        this.totalExpenses = totalExpenses;
        this.sharesOverAlloted = sharesOverAlloted;
        this.shareholderShares = shareholderShares;
        this.sharesOutstanding = sharesOutstanding;
        this.lockupPeriodExpiration = lockupPeriodExpiration;
        this.quietPeriodExpiration = quietPeriodExpiration;
        this.revenue = revenue;
        this.netIncome = netIncome;
        this.totalAssets = totalAssets;
        this.totalLiabilities = totalLiabilities;
        this.stockholderEquity = stockholderEquity;
        this.companyDescription = companyDescription;
        this.businessDescription = businessDescription;
        this.useOfProceeds = useOfProceeds;
        this.competition = competition;
        this.amount = amount;
        this.percentOffered = percentOffered;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public LocalDate getExpectedDate() {
        return this.expectedDate;
    }

    public List<String> getLeadUnderwriters() {
        return this.leadUnderwriters;
    }

    public List<String> getUnderwriters() {
        return this.underwriters;
    }

    public List<String> getCompanyCounsel() {
        return this.companyCounsel;
    }

    public List<String> getUnderwriterCounsel() {
        return this.underwriterCounsel;
    }

    public String getAuditor() {
        return this.auditor;
    }

    public String getMarket() {
        return this.market;
    }

    public String getCik() {
        return this.cik;
    }

    public String getAddress() {
        return this.address;
    }

    public String getCity() {
        return this.city;
    }

    public String getState() {
        return this.state;
    }

    public String getZip() {
        return this.zip;
    }

    public String getPhone() {
        return this.phone;
    }

    public String getCeo() {
        return this.ceo;
    }

    public BigDecimal getEmployees() {
        return this.employees;
    }

    public String getUrl() {
        return this.url;
    }

    public String getStatus() {
        return this.status;
    }

    public BigDecimal getSharesOffered() {
        return this.sharesOffered;
    }

    public BigDecimal getPriceLow() {
        return this.priceLow;
    }

    public BigDecimal getPriceHigh() {
        return this.priceHigh;
    }

    public BigDecimal getOfferAmount() {
        return this.offerAmount;
    }

    public BigDecimal getTotalExpenses() {
        return this.totalExpenses;
    }

    public BigDecimal getSharesOverAlloted() {
        return this.sharesOverAlloted;
    }

    public BigDecimal getShareholderShares() {
        return this.shareholderShares;
    }

    public BigDecimal getSharesOutstanding() {
        return this.sharesOutstanding;
    }

    public LocalDate getLockupPeriodExpiration() {
        return this.lockupPeriodExpiration;
    }

    public LocalDate getQuietPeriodExpiration() {
        return this.quietPeriodExpiration;
    }

    public BigDecimal getRevenue() {
        return this.revenue;
    }

    public BigDecimal getNetIncome() {
        return this.netIncome;
    }

    public BigDecimal getTotalAssets() {
        return this.totalAssets;
    }

    public BigDecimal getTotalLiabilities() {
        return this.totalLiabilities;
    }

    public BigDecimal getStockholderEquity() {
        return this.stockholderEquity;
    }

    public String getCompanyDescription() {
        return this.companyDescription;
    }

    public String getBusinessDescription() {
        return this.businessDescription;
    }

    public String getUseOfProceeds() {
        return this.useOfProceeds;
    }

    public String getCompetition() {
        return this.competition;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public BigDecimal getPercentOffered() {
        return this.percentOffered;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ipo ipo = (Ipo)o;
        return Objects.equal((Object)this.symbol, (Object)ipo.symbol) && Objects.equal((Object)this.companyName, (Object)ipo.companyName) && Objects.equal((Object)this.expectedDate, (Object)ipo.expectedDate) && Objects.equal(this.leadUnderwriters, ipo.leadUnderwriters) && Objects.equal(this.underwriters, ipo.underwriters) && Objects.equal(this.companyCounsel, ipo.companyCounsel) && Objects.equal(this.underwriterCounsel, ipo.underwriterCounsel) && Objects.equal((Object)this.auditor, (Object)ipo.auditor) && Objects.equal((Object)this.market, (Object)ipo.market) && Objects.equal((Object)this.cik, (Object)ipo.cik) && Objects.equal((Object)this.address, (Object)ipo.address) && Objects.equal((Object)this.city, (Object)ipo.city) && Objects.equal((Object)this.state, (Object)ipo.state) && Objects.equal((Object)this.zip, (Object)ipo.zip) && Objects.equal((Object)this.phone, (Object)ipo.phone) && Objects.equal((Object)this.ceo, (Object)ipo.ceo) && Objects.equal((Object)this.employees, (Object)ipo.employees) && Objects.equal((Object)this.url, (Object)ipo.url) && Objects.equal((Object)this.status, (Object)ipo.status) && Objects.equal((Object)this.sharesOffered, (Object)ipo.sharesOffered) && Objects.equal((Object)this.priceLow, (Object)ipo.priceLow) && Objects.equal((Object)this.priceHigh, (Object)ipo.priceHigh) && Objects.equal((Object)this.offerAmount, (Object)ipo.offerAmount) && Objects.equal((Object)this.totalExpenses, (Object)ipo.totalExpenses) && Objects.equal((Object)this.sharesOverAlloted, (Object)ipo.sharesOverAlloted) && Objects.equal((Object)this.shareholderShares, (Object)ipo.shareholderShares) && Objects.equal((Object)this.sharesOutstanding, (Object)ipo.sharesOutstanding) && Objects.equal((Object)this.lockupPeriodExpiration, (Object)ipo.lockupPeriodExpiration) && Objects.equal((Object)this.quietPeriodExpiration, (Object)ipo.quietPeriodExpiration) && Objects.equal((Object)this.revenue, (Object)ipo.revenue) && Objects.equal((Object)this.netIncome, (Object)ipo.netIncome) && Objects.equal((Object)this.totalAssets, (Object)ipo.totalAssets) && Objects.equal((Object)this.totalLiabilities, (Object)ipo.totalLiabilities) && Objects.equal((Object)this.stockholderEquity, (Object)ipo.stockholderEquity) && Objects.equal((Object)this.companyDescription, (Object)ipo.companyDescription) && Objects.equal((Object)this.businessDescription, (Object)ipo.businessDescription) && Objects.equal((Object)this.useOfProceeds, (Object)ipo.useOfProceeds) && Objects.equal((Object)this.competition, (Object)ipo.competition) && Objects.equal((Object)this.amount, (Object)ipo.amount) && Objects.equal((Object)this.percentOffered, (Object)ipo.percentOffered);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.symbol, this.companyName, this.expectedDate, this.leadUnderwriters, this.underwriters, this.companyCounsel, this.underwriterCounsel, this.auditor, this.market, this.cik, this.address, this.city, this.state, this.zip, this.phone, this.ceo, this.employees, this.url, this.status, this.sharesOffered, this.priceLow, this.priceHigh, this.offerAmount, this.totalExpenses, this.sharesOverAlloted, this.shareholderShares, this.sharesOutstanding, this.lockupPeriodExpiration, this.quietPeriodExpiration, this.revenue, this.netIncome, this.totalAssets, this.totalLiabilities, this.stockholderEquity, this.companyDescription, this.businessDescription, this.useOfProceeds, this.competition, this.amount, this.percentOffered});
    }

    public String toString() {
        return "Ipo{symbol='" + this.symbol + '\'' + ", companyName='" + this.companyName + '\'' + ", expectedDate=" + this.expectedDate + ", leadUnderwriters=" + this.leadUnderwriters + ", underwriters=" + this.underwriters + ", companyCounsel=" + this.companyCounsel + ", underwriterCounsel=" + this.underwriterCounsel + ", auditor='" + this.auditor + '\'' + ", market='" + this.market + '\'' + ", cik='" + this.cik + '\'' + ", address='" + this.address + '\'' + ", city='" + this.city + '\'' + ", state='" + this.state + '\'' + ", zip='" + this.zip + '\'' + ", phone='" + this.phone + '\'' + ", ceo='" + this.ceo + '\'' + ", employees=" + this.employees + ", url='" + this.url + '\'' + ", status='" + this.status + '\'' + ", sharesOffered=" + this.sharesOffered + ", priceLow=" + this.priceLow + ", priceHigh=" + this.priceHigh + ", offerAmount=" + this.offerAmount + ", totalExpenses=" + this.totalExpenses + ", sharesOverAlloted=" + this.sharesOverAlloted + ", shareholderShares=" + this.shareholderShares + ", sharesOutstanding=" + this.sharesOutstanding + ", lockupPeriodExpiration=" + this.lockupPeriodExpiration + ", quietPeriodExpiration=" + this.quietPeriodExpiration + ", revenue=" + this.revenue + ", netIncome=" + this.netIncome + ", totalAssets=" + this.totalAssets + ", totalLiabilities=" + this.totalLiabilities + ", stockholderEquity=" + this.stockholderEquity + ", companyDescription='" + this.companyDescription + '\'' + ", businessDescription='" + this.businessDescription + '\'' + ", useOfProceeds='" + this.useOfProceeds + '\'' + ", competition='" + this.competition + '\'' + ", amount=" + this.amount + ", percentOffered=" + this.percentOffered + '}';
    }
}

