/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import pl.zankowski.iextrading4j.api.refdata.Flag;

public class ShortInterest
implements Serializable {
    private static final long serialVersionUID = 3667871969291332272L;
    private final LocalDate settlementDate;
    private final String symbolInINETSymbology;
    private final String symbolInCQSSymbology;
    private final String symbolInCMSSymbology;
    private final String cusip;
    private final String securityName;
    private final String companyName;
    private final BigDecimal currentShortInterest;
    private final BigDecimal previousShortInterest;
    private final BigDecimal percentChange;
    private final BigDecimal averageDailyVolume;
    private final BigDecimal daystoCover;
    private final Flag stockAdjustmentFlag;
    private final Flag newIssueFlag;
    private final Flag revisionFlag;

    @JsonCreator
    public ShortInterest(@JsonProperty(value="SettlementDate") @JsonFormat(pattern="yyyyMMdd") LocalDate settlementDate, @JsonProperty(value="SymbolinINETSymbology") String symbolInINETSymbology, @JsonProperty(value="SymbolinCQSSymbology") String symbolInCQSSymbology, @JsonProperty(value="SymbolinCMSSymbology") String symbolInCMSSymbology, @JsonProperty(value="CUSIP") String cusip, @JsonProperty(value="SecurityName") String securityName, @JsonProperty(value="CompanyName") String companyName, @JsonProperty(value="CurrentShortInterest") BigDecimal currentShortInterest, @JsonProperty(value="PreviousShortInterest") BigDecimal previousShortInterest, @JsonProperty(value="PercentChange") BigDecimal percentChange, @JsonProperty(value="AverageDailyVolume") BigDecimal averageDailyVolume, @JsonProperty(value="DaystoCover") BigDecimal daystoCover, @JsonProperty(value="StockAdjustmentFlag") Flag stockAdjustmentFlag, @JsonProperty(value="NewIssueFlag") Flag newIssueFlag, @JsonProperty(value="RevisionFlag") Flag revisionFlag) {
        this.settlementDate = settlementDate;
        this.symbolInINETSymbology = symbolInINETSymbology;
        this.symbolInCQSSymbology = symbolInCQSSymbology;
        this.symbolInCMSSymbology = symbolInCMSSymbology;
        this.cusip = cusip;
        this.securityName = securityName;
        this.companyName = companyName;
        this.currentShortInterest = currentShortInterest;
        this.previousShortInterest = previousShortInterest;
        this.percentChange = percentChange;
        this.averageDailyVolume = averageDailyVolume;
        this.daystoCover = daystoCover;
        this.stockAdjustmentFlag = stockAdjustmentFlag;
        this.newIssueFlag = newIssueFlag;
        this.revisionFlag = revisionFlag;
    }

    public LocalDate getSettlementDate() {
        return this.settlementDate;
    }

    public String getSymbolInINETSymbology() {
        return this.symbolInINETSymbology;
    }

    public String getSymbolInCQSSymbology() {
        return this.symbolInCQSSymbology;
    }

    public String getSymbolInCMSSymbology() {
        return this.symbolInCMSSymbology;
    }

    public String getCusip() {
        return this.cusip;
    }

    public String getSecurityName() {
        return this.securityName;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public BigDecimal getCurrentShortInterest() {
        return this.currentShortInterest;
    }

    public BigDecimal getPreviousShortInterest() {
        return this.previousShortInterest;
    }

    public BigDecimal getPercentChange() {
        return this.percentChange;
    }

    public BigDecimal getAverageDailyVolume() {
        return this.averageDailyVolume;
    }

    public BigDecimal getDaystoCover() {
        return this.daystoCover;
    }

    public Flag getStockAdjustmentFlag() {
        return this.stockAdjustmentFlag;
    }

    public Flag getNewIssueFlag() {
        return this.newIssueFlag;
    }

    public Flag getRevisionFlag() {
        return this.revisionFlag;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShortInterest that = (ShortInterest)o;
        return Objects.equal((Object)this.settlementDate, (Object)that.settlementDate) && Objects.equal((Object)this.symbolInINETSymbology, (Object)that.symbolInINETSymbology) && Objects.equal((Object)this.symbolInCQSSymbology, (Object)that.symbolInCQSSymbology) && Objects.equal((Object)this.symbolInCMSSymbology, (Object)that.symbolInCMSSymbology) && Objects.equal((Object)this.cusip, (Object)that.cusip) && Objects.equal((Object)this.securityName, (Object)that.securityName) && Objects.equal((Object)this.companyName, (Object)that.companyName) && Objects.equal((Object)this.currentShortInterest, (Object)that.currentShortInterest) && Objects.equal((Object)this.previousShortInterest, (Object)that.previousShortInterest) && Objects.equal((Object)this.percentChange, (Object)that.percentChange) && Objects.equal((Object)this.averageDailyVolume, (Object)that.averageDailyVolume) && Objects.equal((Object)this.daystoCover, (Object)that.daystoCover) && this.stockAdjustmentFlag == that.stockAdjustmentFlag && this.newIssueFlag == that.newIssueFlag && this.revisionFlag == that.revisionFlag;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.settlementDate, this.symbolInINETSymbology, this.symbolInCQSSymbology, this.symbolInCMSSymbology, this.cusip, this.securityName, this.companyName, this.currentShortInterest, this.previousShortInterest, this.percentChange, this.averageDailyVolume, this.daystoCover, this.stockAdjustmentFlag, this.newIssueFlag, this.revisionFlag});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("settlementDate", (Object)this.settlementDate).add("symbolInINETSymbology", (Object)this.symbolInINETSymbology).add("symbolInCQSSymbology", (Object)this.symbolInCQSSymbology).add("symbolInCMSSymbology", (Object)this.symbolInCMSSymbology).add("cusip", (Object)this.cusip).add("securityName", (Object)this.securityName).add("companyName", (Object)this.companyName).add("currentShortInterest", (Object)this.currentShortInterest).add("previousShortInterest", (Object)this.previousShortInterest).add("percentChange", (Object)this.percentChange).add("averageDailyVolume", (Object)this.averageDailyVolume).add("daystoCover", (Object)this.daystoCover).add("stockAdjustmentFlag", (Object)this.stockAdjustmentFlag).add("newIssueFlag", (Object)this.newIssueFlag).add("revisionFlag", (Object)this.revisionFlag).toString();
    }
}

