/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.math.BigDecimal;
import java.time.LocalDate;
import pl.zankowski.iextrading4j.api.stocks.Earning;
import pl.zankowski.iextrading4j.api.stocks.Quote;

public class TodayEarning
extends Earning {
    private static final long serialVersionUID = -4956454242048079697L;
    private final String symbol;
    private final Quote quote;
    private final String headline;
    private final LocalDate reportDate;

    @JsonCreator
    public TodayEarning(@JsonProperty(value="actualEPS") BigDecimal actualEPS, @JsonProperty(value="consensusEPS") BigDecimal consensusEPS, @JsonProperty(value="estimatedEPS") BigDecimal estimatedEPS, @JsonProperty(value="announceTime") String announceTime, @JsonProperty(value="numberOfEstimates") BigDecimal numberOfEstimates, @JsonProperty(value="EPSSurpriseDollar") BigDecimal EPSSurpriseDollar, @JsonProperty(value="EPSReportDate") LocalDate EPSReportDate, @JsonProperty(value="fiscalPeriod") String fiscalPeriod, @JsonProperty(value="fiscalEndDate") LocalDate fiscalEndDate, @JsonProperty(value="yearAgo") BigDecimal yearAgo, @JsonProperty(value="yearAgoChangePercent") BigDecimal yearAgoChangePercent, @JsonProperty(value="symbol") String symbol, @JsonProperty(value="quote") Quote quote, @JsonProperty(value="headline") String headline, @JsonProperty(value="reportDate") LocalDate reportDate, @JsonProperty(value="currency") String currency) {
        super(actualEPS, consensusEPS, estimatedEPS, announceTime, numberOfEstimates, EPSSurpriseDollar, EPSReportDate, fiscalPeriod, fiscalEndDate, yearAgo, yearAgoChangePercent, currency);
        this.symbol = symbol;
        this.quote = quote;
        this.headline = headline;
        this.reportDate = reportDate;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public Quote getQuote() {
        return this.quote;
    }

    public String getHeadline() {
        return this.headline;
    }

    public LocalDate getReportDate() {
        return this.reportDate;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TodayEarning that = (TodayEarning)o;
        return Objects.equal((Object)this.symbol, (Object)that.symbol) && Objects.equal((Object)this.quote, (Object)that.quote) && Objects.equal((Object)this.headline, (Object)that.headline) && Objects.equal((Object)this.reportDate, (Object)that.reportDate);
    }

    @Override
    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{super.hashCode(), this.symbol, this.quote, this.headline, this.reportDate});
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("symbol", (Object)this.symbol).add("quote", (Object)this.quote).add("headline", (Object)this.headline).add("reportDate", (Object)this.reportDate).toString();
    }
}

