/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import pl.zankowski.iextrading4j.api.stocks.v1.Report;

public class BalanceSheet
extends Report {
    private static final long serialVersionUID = 903088600080035429L;
    private final BigDecimal currentCash;
    private final BigDecimal shortTermInvestments;
    private final BigDecimal receivables;
    private final BigDecimal inventory;
    private final BigDecimal otherCurrentAssets;
    private final BigDecimal currentAssets;
    private final BigDecimal longTermInvestments;
    private final BigDecimal propertyPlantEquipment;
    private final BigDecimal goodwill;
    private final BigDecimal intangibleAssets;
    private final BigDecimal otherAssets;
    private final BigDecimal totalAssets;
    private final BigDecimal accountsPayable;
    private final BigDecimal currentLongTermDebt;
    private final BigDecimal otherCurrentLiabilities;
    private final BigDecimal totalCurrentLiabilities;
    private final BigDecimal longTermDebt;
    private final BigDecimal otherLiabilities;
    private final BigDecimal minorityInterest;
    private final BigDecimal totalLiabilities;
    private final BigDecimal commonStock;
    private final BigDecimal retainedEarnings;
    private final BigDecimal treasuryStock;
    private final BigDecimal capitalSurplus;
    private final BigDecimal shareholderEquity;
    private final BigDecimal netTangibleAssets;

    @JsonCreator
    public BalanceSheet(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="id") String id, @JsonProperty(value="key") String key, @JsonProperty(value="subkey") String subkey, @JsonProperty(value="updated") Long updated, @JsonProperty(value="reportDate") LocalDate reportDate, @JsonProperty(value="fiscalDate") LocalDate fiscalDate, @JsonProperty(value="currency") String currency, @JsonProperty(value="currentCash") BigDecimal currentCash, @JsonProperty(value="shortTermInvestments") BigDecimal shortTermInvestments, @JsonProperty(value="receivables") BigDecimal receivables, @JsonProperty(value="inventory") BigDecimal inventory, @JsonProperty(value="otherCurrentAssets") BigDecimal otherCurrentAssets, @JsonProperty(value="currentAssets") BigDecimal currentAssets, @JsonProperty(value="longTermInvestments") BigDecimal longTermInvestments, @JsonProperty(value="propertyPlantEquipment") BigDecimal propertyPlantEquipment, @JsonProperty(value="goodwill") BigDecimal goodwill, @JsonProperty(value="intangibleAssets") BigDecimal intangibleAssets, @JsonProperty(value="otherAssets") BigDecimal otherAssets, @JsonProperty(value="totalAssets") BigDecimal totalAssets, @JsonProperty(value="accountsPayable") BigDecimal accountsPayable, @JsonProperty(value="currentLongTermDebt") BigDecimal currentLongTermDebt, @JsonProperty(value="otherCurrentLiabilities") BigDecimal otherCurrentLiabilities, @JsonProperty(value="totalCurrentLiabilities") BigDecimal totalCurrentLiabilities, @JsonProperty(value="longTermDebt") BigDecimal longTermDebt, @JsonProperty(value="otherLiabilities") BigDecimal otherLiabilities, @JsonProperty(value="minorityInterest") BigDecimal minorityInterest, @JsonProperty(value="totalLiabilities") BigDecimal totalLiabilities, @JsonProperty(value="commonStock") BigDecimal commonStock, @JsonProperty(value="retainedEarnings") BigDecimal retainedEarnings, @JsonProperty(value="treasuryStock") BigDecimal treasuryStock, @JsonProperty(value="capitalSurplus") BigDecimal capitalSurplus, @JsonProperty(value="shareholderEquity") BigDecimal shareholderEquity, @JsonProperty(value="netTangibleAssets") BigDecimal netTangibleAssets, @JsonProperty(value="filingType") String filingType, @JsonProperty(value="fiscalQuarter") BigDecimal fiscalQuarter, @JsonProperty(value="fiscalYear") BigDecimal fiscalYear) {
        super(symbol, id, key, subkey, updated, reportDate, filingType, fiscalDate, fiscalQuarter, fiscalYear, currency);
        this.currentCash = currentCash;
        this.shortTermInvestments = shortTermInvestments;
        this.receivables = receivables;
        this.inventory = inventory;
        this.otherCurrentAssets = otherCurrentAssets;
        this.currentAssets = currentAssets;
        this.longTermInvestments = longTermInvestments;
        this.propertyPlantEquipment = propertyPlantEquipment;
        this.goodwill = goodwill;
        this.intangibleAssets = intangibleAssets;
        this.otherAssets = otherAssets;
        this.totalAssets = totalAssets;
        this.accountsPayable = accountsPayable;
        this.currentLongTermDebt = currentLongTermDebt;
        this.otherCurrentLiabilities = otherCurrentLiabilities;
        this.totalCurrentLiabilities = totalCurrentLiabilities;
        this.longTermDebt = longTermDebt;
        this.otherLiabilities = otherLiabilities;
        this.minorityInterest = minorityInterest;
        this.totalLiabilities = totalLiabilities;
        this.commonStock = commonStock;
        this.retainedEarnings = retainedEarnings;
        this.treasuryStock = treasuryStock;
        this.capitalSurplus = capitalSurplus;
        this.shareholderEquity = shareholderEquity;
        this.netTangibleAssets = netTangibleAssets;
    }

    public BigDecimal getCurrentCash() {
        return this.currentCash;
    }

    public BigDecimal getShortTermInvestments() {
        return this.shortTermInvestments;
    }

    public BigDecimal getReceivables() {
        return this.receivables;
    }

    public BigDecimal getInventory() {
        return this.inventory;
    }

    public BigDecimal getOtherCurrentAssets() {
        return this.otherCurrentAssets;
    }

    public BigDecimal getCurrentAssets() {
        return this.currentAssets;
    }

    public BigDecimal getLongTermInvestments() {
        return this.longTermInvestments;
    }

    public BigDecimal getPropertyPlantEquipment() {
        return this.propertyPlantEquipment;
    }

    public BigDecimal getGoodwill() {
        return this.goodwill;
    }

    public BigDecimal getIntangibleAssets() {
        return this.intangibleAssets;
    }

    public BigDecimal getOtherAssets() {
        return this.otherAssets;
    }

    public BigDecimal getTotalAssets() {
        return this.totalAssets;
    }

    public BigDecimal getAccountsPayable() {
        return this.accountsPayable;
    }

    public BigDecimal getCurrentLongTermDebt() {
        return this.currentLongTermDebt;
    }

    public BigDecimal getOtherCurrentLiabilities() {
        return this.otherCurrentLiabilities;
    }

    public BigDecimal getTotalCurrentLiabilities() {
        return this.totalCurrentLiabilities;
    }

    public BigDecimal getLongTermDebt() {
        return this.longTermDebt;
    }

    public BigDecimal getOtherLiabilities() {
        return this.otherLiabilities;
    }

    public BigDecimal getMinorityInterest() {
        return this.minorityInterest;
    }

    public BigDecimal getTotalLiabilities() {
        return this.totalLiabilities;
    }

    public BigDecimal getCommonStock() {
        return this.commonStock;
    }

    public BigDecimal getRetainedEarnings() {
        return this.retainedEarnings;
    }

    public BigDecimal getTreasuryStock() {
        return this.treasuryStock;
    }

    public BigDecimal getCapitalSurplus() {
        return this.capitalSurplus;
    }

    public BigDecimal getShareholderEquity() {
        return this.shareholderEquity;
    }

    public BigDecimal getNetTangibleAssets() {
        return this.netTangibleAssets;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BalanceSheet that = (BalanceSheet)o;
        return Objects.equals(this.currentCash, that.currentCash) && Objects.equals(this.shortTermInvestments, that.shortTermInvestments) && Objects.equals(this.receivables, that.receivables) && Objects.equals(this.inventory, that.inventory) && Objects.equals(this.otherCurrentAssets, that.otherCurrentAssets) && Objects.equals(this.currentAssets, that.currentAssets) && Objects.equals(this.longTermInvestments, that.longTermInvestments) && Objects.equals(this.propertyPlantEquipment, that.propertyPlantEquipment) && Objects.equals(this.goodwill, that.goodwill) && Objects.equals(this.intangibleAssets, that.intangibleAssets) && Objects.equals(this.otherAssets, that.otherAssets) && Objects.equals(this.totalAssets, that.totalAssets) && Objects.equals(this.accountsPayable, that.accountsPayable) && Objects.equals(this.currentLongTermDebt, that.currentLongTermDebt) && Objects.equals(this.otherCurrentLiabilities, that.otherCurrentLiabilities) && Objects.equals(this.totalCurrentLiabilities, that.totalCurrentLiabilities) && Objects.equals(this.longTermDebt, that.longTermDebt) && Objects.equals(this.otherLiabilities, that.otherLiabilities) && Objects.equals(this.minorityInterest, that.minorityInterest) && Objects.equals(this.totalLiabilities, that.totalLiabilities) && Objects.equals(this.commonStock, that.commonStock) && Objects.equals(this.retainedEarnings, that.retainedEarnings) && Objects.equals(this.treasuryStock, that.treasuryStock) && Objects.equals(this.capitalSurplus, that.capitalSurplus) && Objects.equals(this.shareholderEquity, that.shareholderEquity) && Objects.equals(this.netTangibleAssets, that.netTangibleAssets);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.currentCash, this.shortTermInvestments, this.receivables, this.inventory, this.otherCurrentAssets, this.currentAssets, this.longTermInvestments, this.propertyPlantEquipment, this.goodwill, this.intangibleAssets, this.otherAssets, this.totalAssets, this.accountsPayable, this.currentLongTermDebt, this.otherCurrentLiabilities, this.totalCurrentLiabilities, this.longTermDebt, this.otherLiabilities, this.minorityInterest, this.totalLiabilities, this.commonStock, this.retainedEarnings, this.treasuryStock, this.capitalSurplus, this.shareholderEquity, this.netTangibleAssets);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("currentCash", (Object)this.currentCash).add("shortTermInvestments", (Object)this.shortTermInvestments).add("receivables", (Object)this.receivables).add("inventory", (Object)this.inventory).add("otherCurrentAssets", (Object)this.otherCurrentAssets).add("currentAssets", (Object)this.currentAssets).add("longTermInvestments", (Object)this.longTermInvestments).add("propertyPlantEquipment", (Object)this.propertyPlantEquipment).add("goodwill", (Object)this.goodwill).add("intangibleAssets", (Object)this.intangibleAssets).add("otherAssets", (Object)this.otherAssets).add("totalAssets", (Object)this.totalAssets).add("accountsPayable", (Object)this.accountsPayable).add("currentLongTermDebt", (Object)this.currentLongTermDebt).add("otherCurrentLiabilities", (Object)this.otherCurrentLiabilities).add("totalCurrentLiabilities", (Object)this.totalCurrentLiabilities).add("longTermDebt", (Object)this.longTermDebt).add("otherLiabilities", (Object)this.otherLiabilities).add("minorityInterest", (Object)this.minorityInterest).add("totalLiabilities", (Object)this.totalLiabilities).add("commonStock", (Object)this.commonStock).add("retainedEarnings", (Object)this.retainedEarnings).add("treasuryStock", (Object)this.treasuryStock).add("capitalSurplus", (Object)this.capitalSurplus).add("shareholderEquity", (Object)this.shareholderEquity).add("netTangibleAssets", (Object)this.netTangibleAssets).toString();
    }
}

