/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.List;
import pl.zankowski.iextrading4j.api.stocks.Book;
import pl.zankowski.iextrading4j.api.stocks.Chart;
import pl.zankowski.iextrading4j.api.stocks.Company;
import pl.zankowski.iextrading4j.api.stocks.DelayedQuote;
import pl.zankowski.iextrading4j.api.stocks.Earnings;
import pl.zankowski.iextrading4j.api.stocks.LargestTrade;
import pl.zankowski.iextrading4j.api.stocks.Logo;
import pl.zankowski.iextrading4j.api.stocks.Ohlc;
import pl.zankowski.iextrading4j.api.stocks.Quote;
import pl.zankowski.iextrading4j.api.stocks.TodayEarnings;
import pl.zankowski.iextrading4j.api.stocks.VenueVolume;
import pl.zankowski.iextrading4j.api.stocks.v1.AdvancedStats;
import pl.zankowski.iextrading4j.api.stocks.v1.BalanceSheets;
import pl.zankowski.iextrading4j.api.stocks.v1.BarData;
import pl.zankowski.iextrading4j.api.stocks.v1.CashFlows;
import pl.zankowski.iextrading4j.api.stocks.v1.Dividends;
import pl.zankowski.iextrading4j.api.stocks.v1.Estimates;
import pl.zankowski.iextrading4j.api.stocks.v1.Financials;
import pl.zankowski.iextrading4j.api.stocks.v1.FundOwnership;
import pl.zankowski.iextrading4j.api.stocks.v1.IncomeStatements;
import pl.zankowski.iextrading4j.api.stocks.v1.InsiderRoster;
import pl.zankowski.iextrading4j.api.stocks.v1.InsiderSummary;
import pl.zankowski.iextrading4j.api.stocks.v1.InsiderTransaction;
import pl.zankowski.iextrading4j.api.stocks.v1.Intraday;
import pl.zankowski.iextrading4j.api.stocks.v1.KeyStats;
import pl.zankowski.iextrading4j.api.stocks.v1.News;
import pl.zankowski.iextrading4j.api.stocks.v1.Ownership;
import pl.zankowski.iextrading4j.api.stocks.v1.PriceTarget;
import pl.zankowski.iextrading4j.api.stocks.v1.RecommendationTrends;
import pl.zankowski.iextrading4j.api.stocks.v1.Split;
import pl.zankowski.iextrading4j.api.util.ListUtil;

public class BatchStocks
implements Serializable {
    private static final long serialVersionUID = -1000412562192933682L;
    private final AdvancedStats advancedStats;
    private final BalanceSheets balanceSheets;
    private final Book book;
    private final CashFlows cashFlows;
    private final List<Chart> chart;
    private final Company company;
    private final DelayedQuote delayedQuote;
    private final List<Dividends> dividends;
    private final Earnings earnings;
    private final TodayEarnings earningsToday;
    private final Estimates estimates;
    private final Financials financials;
    private final List<FundOwnership> fundOwnership;
    private final IncomeStatements incomeStatements;
    private final List<InsiderRoster> insiderRoster;
    private final List<InsiderSummary> insiderSummary;
    private final List<InsiderTransaction> insiderTransaction;
    private final List<Ownership> institutionalOwnership;
    private final List<Intraday> intradayPrices;
    private final KeyStats keyStats;
    private final List<LargestTrade> largestTrades;
    private final Logo logo;
    private final List<News> news;
    private final Ohlc ohlc;
    private final List<String> options;
    private final List<String> peers;
    private final BarData previous;
    private final BigDecimal price;
    private final PriceTarget priceTarget;
    private final Quote quote;
    private final List<RecommendationTrends> recommendationTrends;
    private final List<Split> splits;
    private final List<VenueVolume> volumeByVenue;

    @JsonCreator
    public BatchStocks(@JsonProperty(value="advanced-stats") AdvancedStats advancedStats, @JsonProperty(value="balance-sheet") BalanceSheets balanceSheets, @JsonProperty(value="book") Book book, @JsonProperty(value="cash-flow") CashFlows cashFlows, @JsonProperty(value="chart") List<Chart> chart, @JsonProperty(value="company") Company company, @JsonProperty(value="delayed-quote") DelayedQuote delayedQuote, @JsonProperty(value="dividends") List<Dividends> dividends, @JsonProperty(value="earnings") Earnings earnings, @JsonProperty(value="today-earnings") TodayEarnings earningsToday, @JsonProperty(value="estimates") Estimates estimates, @JsonProperty(value="financials") Financials financials, @JsonProperty(value="fund-ownership") List<FundOwnership> fundOwnership, @JsonProperty(value="income") IncomeStatements incomeStatements, @JsonProperty(value="insider-roster") List<InsiderRoster> insiderRoster, @JsonProperty(value="insider-summary") List<InsiderSummary> insiderSummary, @JsonProperty(value="insider-transactions") List<InsiderTransaction> insiderTransaction, @JsonProperty(value="institutional-ownership") List<Ownership> institutionalOwnership, @JsonProperty(value="intraday-prices") List<Intraday> intradayPrices, @JsonProperty(value="stats") KeyStats keyStats, @JsonProperty(value="largest-trades") List<LargestTrade> largestTrades, @JsonProperty(value="logo") Logo logo, @JsonProperty(value="news") List<News> news, @JsonProperty(value="ohlc") Ohlc ohlc, @JsonProperty(value="options") List<String> options, @JsonProperty(value="peers") List<String> peers, @JsonProperty(value="previous") BarData previous, @JsonProperty(value="price") BigDecimal price, @JsonProperty(value="price-target") PriceTarget priceTarget, @JsonProperty(value="quote") Quote quote, @JsonProperty(value="recommendation-trends") List<RecommendationTrends> recommendationTrends, @JsonProperty(value="splits") List<Split> splits, @JsonProperty(value="volume-by-venue") List<VenueVolume> volumeByVenue) {
        this.advancedStats = advancedStats;
        this.balanceSheets = balanceSheets;
        this.book = book;
        this.cashFlows = cashFlows;
        this.chart = ListUtil.immutableList(chart);
        this.company = company;
        this.delayedQuote = delayedQuote;
        this.dividends = ListUtil.immutableList(dividends);
        this.earnings = earnings;
        this.earningsToday = earningsToday;
        this.estimates = estimates;
        this.financials = financials;
        this.fundOwnership = ListUtil.immutableList(fundOwnership);
        this.incomeStatements = incomeStatements;
        this.insiderRoster = ListUtil.immutableList(insiderRoster);
        this.insiderSummary = ListUtil.immutableList(insiderSummary);
        this.insiderTransaction = ListUtil.immutableList(insiderTransaction);
        this.institutionalOwnership = ListUtil.immutableList(institutionalOwnership);
        this.intradayPrices = ListUtil.immutableList(intradayPrices);
        this.keyStats = keyStats;
        this.largestTrades = ListUtil.immutableList(largestTrades);
        this.logo = logo;
        this.news = ListUtil.immutableList(news);
        this.ohlc = ohlc;
        this.options = ListUtil.immutableList(options);
        this.peers = ListUtil.immutableList(peers);
        this.previous = previous;
        this.price = price;
        this.priceTarget = priceTarget;
        this.quote = quote;
        this.recommendationTrends = ListUtil.immutableList(recommendationTrends);
        this.splits = ListUtil.immutableList(splits);
        this.volumeByVenue = ListUtil.immutableList(volumeByVenue);
    }

    @JsonProperty(value="advanced-stats")
    public AdvancedStats getAdvancedStats() {
        return this.advancedStats;
    }

    @JsonProperty(value="balance-sheet")
    public BalanceSheets getBalanceSheets() {
        return this.balanceSheets;
    }

    public Book getBook() {
        return this.book;
    }

    @JsonProperty(value="cash-flow")
    public CashFlows getCashFlows() {
        return this.cashFlows;
    }

    public List<Chart> getChart() {
        return this.chart;
    }

    public Company getCompany() {
        return this.company;
    }

    @JsonProperty(value="delayed-quote")
    public DelayedQuote getDelayedQuote() {
        return this.delayedQuote;
    }

    public List<Dividends> getDividends() {
        return this.dividends;
    }

    public Earnings getEarnings() {
        return this.earnings;
    }

    @JsonProperty(value="today-earnings")
    public TodayEarnings getEarningsToday() {
        return this.earningsToday;
    }

    public Estimates getEstimates() {
        return this.estimates;
    }

    public Financials getFinancials() {
        return this.financials;
    }

    @JsonProperty(value="fund-ownership")
    public List<FundOwnership> getFundOwnership() {
        return this.fundOwnership;
    }

    @JsonProperty(value="income")
    public IncomeStatements getIncomeStatements() {
        return this.incomeStatements;
    }

    @JsonProperty(value="insider-roster")
    public List<InsiderRoster> getInsiderRoster() {
        return this.insiderRoster;
    }

    @JsonProperty(value="insider-summary")
    public List<InsiderSummary> getInsiderSummary() {
        return this.insiderSummary;
    }

    @JsonProperty(value="insider-transactions")
    public List<InsiderTransaction> getInsiderTransaction() {
        return this.insiderTransaction;
    }

    @JsonProperty(value="institutional-ownership")
    public List<Ownership> getInstitutionalOwnership() {
        return this.institutionalOwnership;
    }

    @JsonProperty(value="intraday-prices")
    public List<Intraday> getIntradayPrices() {
        return this.intradayPrices;
    }

    @JsonProperty(value="stats")
    public KeyStats getKeyStats() {
        return this.keyStats;
    }

    @JsonProperty(value="largest-trades")
    public List<LargestTrade> getLargestTrades() {
        return this.largestTrades;
    }

    public Logo getLogo() {
        return this.logo;
    }

    public List<News> getNews() {
        return this.news;
    }

    public Ohlc getOhlc() {
        return this.ohlc;
    }

    public List<String> getOptions() {
        return this.options;
    }

    public List<String> getPeers() {
        return this.peers;
    }

    public BarData getPrevious() {
        return this.previous;
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public PriceTarget getPriceTarget() {
        return this.priceTarget;
    }

    public Quote getQuote() {
        return this.quote;
    }

    @JsonProperty(value="recommendation-trends")
    public List<RecommendationTrends> getRecommendationTrends() {
        return this.recommendationTrends;
    }

    public List<Split> getSplits() {
        return this.splits;
    }

    @JsonProperty(value="volume-by-venue")
    public List<VenueVolume> getVolumeByVenue() {
        return this.volumeByVenue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BatchStocks that = (BatchStocks)o;
        return Objects.equal((Object)this.advancedStats, (Object)that.advancedStats) && Objects.equal((Object)this.balanceSheets, (Object)that.balanceSheets) && Objects.equal((Object)this.book, (Object)that.book) && Objects.equal((Object)this.cashFlows, (Object)that.cashFlows) && Objects.equal(this.chart, that.chart) && Objects.equal((Object)this.company, (Object)that.company) && Objects.equal((Object)this.delayedQuote, (Object)that.delayedQuote) && Objects.equal(this.dividends, that.dividends) && Objects.equal((Object)this.earnings, (Object)that.earnings) && Objects.equal((Object)this.earningsToday, (Object)that.earningsToday) && Objects.equal((Object)this.estimates, (Object)that.estimates) && Objects.equal((Object)this.financials, (Object)that.financials) && Objects.equal(this.fundOwnership, that.fundOwnership) && Objects.equal((Object)this.incomeStatements, (Object)that.incomeStatements) && Objects.equal(this.insiderRoster, that.insiderRoster) && Objects.equal(this.insiderSummary, that.insiderSummary) && Objects.equal(this.insiderTransaction, that.insiderTransaction) && Objects.equal(this.institutionalOwnership, that.institutionalOwnership) && Objects.equal(this.intradayPrices, that.intradayPrices) && Objects.equal((Object)this.keyStats, (Object)that.keyStats) && Objects.equal(this.largestTrades, that.largestTrades) && Objects.equal((Object)this.logo, (Object)that.logo) && Objects.equal(this.news, that.news) && Objects.equal((Object)this.ohlc, (Object)that.ohlc) && Objects.equal(this.options, that.options) && Objects.equal(this.peers, that.peers) && Objects.equal((Object)this.previous, (Object)that.previous) && Objects.equal((Object)this.price, (Object)that.price) && Objects.equal((Object)this.priceTarget, (Object)that.priceTarget) && Objects.equal((Object)this.quote, (Object)that.quote) && Objects.equal(this.recommendationTrends, that.recommendationTrends) && Objects.equal(this.splits, that.splits) && Objects.equal(this.volumeByVenue, that.volumeByVenue);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.advancedStats, this.balanceSheets, this.book, this.cashFlows, this.chart, this.company, this.delayedQuote, this.dividends, this.earnings, this.earningsToday, this.estimates, this.financials, this.fundOwnership, this.incomeStatements, this.insiderRoster, this.insiderSummary, this.insiderTransaction, this.institutionalOwnership, this.intradayPrices, this.keyStats, this.largestTrades, this.logo, this.news, this.ohlc, this.options, this.peers, this.previous, this.price, this.priceTarget, this.quote, this.recommendationTrends, this.splits, this.volumeByVenue});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("advancedStats", (Object)this.advancedStats).add("balanceSheets", (Object)this.balanceSheets).add("book", (Object)this.book).add("cashFlows", (Object)this.cashFlows).add("chart", this.chart).add("company", (Object)this.company).add("delayedQuote", (Object)this.delayedQuote).add("dividends", this.dividends).add("earnings", (Object)this.earnings).add("earningsToday", (Object)this.earningsToday).add("estimates", (Object)this.estimates).add("financials", (Object)this.financials).add("fundOwnership", this.fundOwnership).add("incomeStatements", (Object)this.incomeStatements).add("insiderRoster", this.insiderRoster).add("insiderSummary", this.insiderSummary).add("insiderTransaction", this.insiderTransaction).add("institutionalOwnership", this.institutionalOwnership).add("intradayPrices", this.intradayPrices).add("keyStats", (Object)this.keyStats).add("largestTrades", this.largestTrades).add("logo", (Object)this.logo).add("news", this.news).add("ohlc", (Object)this.ohlc).add("options", this.options).add("peers", this.peers).add("previous", (Object)this.previous).add("price", (Object)this.price).add("priceTarget", (Object)this.priceTarget).add("quote", (Object)this.quote).add("recommendationTrends", this.recommendationTrends).add("splits", this.splits).add("volumeByVenue", this.volumeByVenue).toString();
    }
}

