/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import pl.zankowski.iextrading4j.api.stocks.v1.Report;

public class CashFlow
extends Report {
    private static final Long serialVersionUID = 3659383763381838960L;
    private final BigDecimal netIncome;
    private final BigDecimal depreciation;
    private final BigDecimal changesInReceivables;
    private final BigDecimal changesInInventories;
    private final BigDecimal cashChange;
    private final BigDecimal cashFlow;
    private final BigDecimal capitalExpenditures;
    private final BigDecimal investments;
    private final BigDecimal investingActivityOther;
    private final BigDecimal totalInvestingCashFlows;
    private final BigDecimal dividendsPaid;
    private final BigDecimal netBorrowings;
    private final BigDecimal otherFinancingCashFlows;
    private final BigDecimal cashFlowFinancing;
    private final BigDecimal exchangeRateEffect;

    @JsonCreator
    public CashFlow(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="id") String id, @JsonProperty(value="key") String key, @JsonProperty(value="subkey") String subkey, @JsonProperty(value="updated") Long updated, @JsonProperty(value="reportDate") LocalDate reportDate, @JsonProperty(value="fiscalDate") LocalDate fiscalDate, @JsonProperty(value="currency") String currency, @JsonProperty(value="netIncome") BigDecimal netIncome, @JsonProperty(value="depreciation") BigDecimal depreciation, @JsonProperty(value="changesInReceivables") BigDecimal changesInReceivables, @JsonProperty(value="changesInInventories") BigDecimal changesInInventories, @JsonProperty(value="cashChange") BigDecimal cashChange, @JsonProperty(value="cashFlow") BigDecimal cashFlow, @JsonProperty(value="capitalExpenditures") BigDecimal capitalExpenditures, @JsonProperty(value="investments") BigDecimal investments, @JsonProperty(value="investingActivityOther") BigDecimal investingActivityOther, @JsonProperty(value="totalInvestingCashFlows") BigDecimal totalInvestingCashFlows, @JsonProperty(value="dividendsPaid") BigDecimal dividendsPaid, @JsonProperty(value="netBorrowings") BigDecimal netBorrowings, @JsonProperty(value="otherFinancingCashFlows") BigDecimal otherFinancingCashFlows, @JsonProperty(value="cashFlowFinancing") BigDecimal cashFlowFinancing, @JsonProperty(value="exchangeRateEffect") BigDecimal exchangeRateEffect, @JsonProperty(value="filingType") String filingType, @JsonProperty(value="fiscalQuarter") BigDecimal fiscalQuarter, @JsonProperty(value="fiscalYear") BigDecimal fiscalYear) {
        super(symbol, id, key, subkey, updated, reportDate, filingType, fiscalDate, fiscalQuarter, fiscalYear, currency);
        this.netIncome = netIncome;
        this.depreciation = depreciation;
        this.changesInReceivables = changesInReceivables;
        this.changesInInventories = changesInInventories;
        this.cashChange = cashChange;
        this.cashFlow = cashFlow;
        this.capitalExpenditures = capitalExpenditures;
        this.investments = investments;
        this.investingActivityOther = investingActivityOther;
        this.totalInvestingCashFlows = totalInvestingCashFlows;
        this.dividendsPaid = dividendsPaid;
        this.netBorrowings = netBorrowings;
        this.otherFinancingCashFlows = otherFinancingCashFlows;
        this.cashFlowFinancing = cashFlowFinancing;
        this.exchangeRateEffect = exchangeRateEffect;
    }

    public BigDecimal getNetIncome() {
        return this.netIncome;
    }

    public BigDecimal getDepreciation() {
        return this.depreciation;
    }

    public BigDecimal getChangesInReceivables() {
        return this.changesInReceivables;
    }

    public BigDecimal getChangesInInventories() {
        return this.changesInInventories;
    }

    public BigDecimal getCashChange() {
        return this.cashChange;
    }

    public BigDecimal getCashFlow() {
        return this.cashFlow;
    }

    public BigDecimal getCapitalExpenditures() {
        return this.capitalExpenditures;
    }

    public BigDecimal getInvestments() {
        return this.investments;
    }

    public BigDecimal getInvestingActivityOther() {
        return this.investingActivityOther;
    }

    public BigDecimal getTotalInvestingCashFlows() {
        return this.totalInvestingCashFlows;
    }

    public BigDecimal getDividendsPaid() {
        return this.dividendsPaid;
    }

    public BigDecimal getNetBorrowings() {
        return this.netBorrowings;
    }

    public BigDecimal getOtherFinancingCashFlows() {
        return this.otherFinancingCashFlows;
    }

    public BigDecimal getCashFlowFinancing() {
        return this.cashFlowFinancing;
    }

    public BigDecimal getExchangeRateEffect() {
        return this.exchangeRateEffect;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        CashFlow cashFlow1 = (CashFlow)o;
        return Objects.equals(this.netIncome, cashFlow1.netIncome) && Objects.equals(this.depreciation, cashFlow1.depreciation) && Objects.equals(this.changesInReceivables, cashFlow1.changesInReceivables) && Objects.equals(this.changesInInventories, cashFlow1.changesInInventories) && Objects.equals(this.cashChange, cashFlow1.cashChange) && Objects.equals(this.cashFlow, cashFlow1.cashFlow) && Objects.equals(this.capitalExpenditures, cashFlow1.capitalExpenditures) && Objects.equals(this.investments, cashFlow1.investments) && Objects.equals(this.investingActivityOther, cashFlow1.investingActivityOther) && Objects.equals(this.totalInvestingCashFlows, cashFlow1.totalInvestingCashFlows) && Objects.equals(this.dividendsPaid, cashFlow1.dividendsPaid) && Objects.equals(this.netBorrowings, cashFlow1.netBorrowings) && Objects.equals(this.otherFinancingCashFlows, cashFlow1.otherFinancingCashFlows) && Objects.equals(this.cashFlowFinancing, cashFlow1.cashFlowFinancing) && Objects.equals(this.exchangeRateEffect, cashFlow1.exchangeRateEffect);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.netIncome, this.depreciation, this.changesInReceivables, this.changesInInventories, this.cashChange, this.cashFlow, this.capitalExpenditures, this.investments, this.investingActivityOther, this.totalInvestingCashFlows, this.dividendsPaid, this.netBorrowings, this.otherFinancingCashFlows, this.cashFlowFinancing, this.exchangeRateEffect);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("netIncome", (Object)this.netIncome).add("depreciation", (Object)this.depreciation).add("changesInReceivables", (Object)this.changesInReceivables).add("changesInInventories", (Object)this.changesInInventories).add("cashChange", (Object)this.cashChange).add("cashFlow", (Object)this.cashFlow).add("capitalExpenditures", (Object)this.capitalExpenditures).add("investments", (Object)this.investments).add("investingActivityOther", (Object)this.investingActivityOther).add("totalInvestingCashFlows", (Object)this.totalInvestingCashFlows).add("dividendsPaid", (Object)this.dividendsPaid).add("netBorrowings", (Object)this.netBorrowings).add("otherFinancingCashFlows", (Object)this.otherFinancingCashFlows).add("cashFlowFinancing", (Object)this.cashFlowFinancing).add("exchangeRateEffect", (Object)this.exchangeRateEffect).toString();
    }
}

