/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;

public class Estimate
implements Serializable {
    private static final long serialVersionUID = -5638112355484292012L;
    private final BigDecimal consensusEPS;
    private final String announceTime;
    private final BigDecimal numberOfEstimates;
    private final String fiscalPeriod;
    private final LocalDate fiscalEndDate;
    private final LocalDate reportDate;
    private final String currency;

    @JsonCreator
    public Estimate(@JsonProperty(value="consensusEPS") BigDecimal consensusEPS, @JsonProperty(value="announceTime") String announceTime, @JsonProperty(value="numberOfEstimates") BigDecimal numberOfEstimates, @JsonProperty(value="fiscalPeriod") String fiscalPeriod, @JsonProperty(value="fiscalEndDate") LocalDate fiscalEndDate, @JsonProperty(value="reportDate") LocalDate reportDate, @JsonProperty(value="currency") String currency) {
        this.consensusEPS = consensusEPS;
        this.announceTime = announceTime;
        this.numberOfEstimates = numberOfEstimates;
        this.fiscalPeriod = fiscalPeriod;
        this.fiscalEndDate = fiscalEndDate;
        this.reportDate = reportDate;
        this.currency = currency;
    }

    public BigDecimal getConsensusEPS() {
        return this.consensusEPS;
    }

    public String getAnnounceTime() {
        return this.announceTime;
    }

    public BigDecimal getNumberOfEstimates() {
        return this.numberOfEstimates;
    }

    public String getFiscalPeriod() {
        return this.fiscalPeriod;
    }

    public LocalDate getFiscalEndDate() {
        return this.fiscalEndDate;
    }

    public LocalDate getReportDate() {
        return this.reportDate;
    }

    public String getCurrency() {
        return this.currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Estimate estimate = (Estimate)o;
        return Objects.equal((Object)this.consensusEPS, (Object)estimate.consensusEPS) && Objects.equal((Object)this.announceTime, (Object)estimate.announceTime) && Objects.equal((Object)this.numberOfEstimates, (Object)estimate.numberOfEstimates) && Objects.equal((Object)this.fiscalPeriod, (Object)estimate.fiscalPeriod) && Objects.equal((Object)this.fiscalEndDate, (Object)estimate.fiscalEndDate) && Objects.equal((Object)this.currency, (Object)estimate.currency) && Objects.equal((Object)this.reportDate, (Object)estimate.reportDate);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.consensusEPS, this.announceTime, this.numberOfEstimates, this.fiscalPeriod, this.fiscalEndDate, this.reportDate, this.currency});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("consensusEPS", (Object)this.consensusEPS).add("announceTime", (Object)this.announceTime).add("numberOfEstimates", (Object)this.numberOfEstimates).add("fiscalPeriod", (Object)this.fiscalPeriod).add("fiscalEndDate", (Object)this.fiscalEndDate).add("reportDate", (Object)this.reportDate).add("currency", (Object)this.currency).toString();
    }
}

