/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import pl.zankowski.iextrading4j.api.stocks.v1.Report;

public class IncomeStatement
extends Report {
    private static final long serialVersionUID = -1413080264580022740L;
    private final BigDecimal totalRevenue;
    private final BigDecimal costOfRevenue;
    private final BigDecimal ebit;
    private final BigDecimal grossProfit;
    private final BigDecimal incomeTax;
    private final BigDecimal interestIncome;
    private final BigDecimal minorityInterest;
    private final BigDecimal netIncome;
    private final BigDecimal netIncomeBasic;
    private final BigDecimal operatingExpense;
    private final BigDecimal operatingIncome;
    private final BigDecimal otherIncomeExpenseNet;
    private final BigDecimal pretaxIncome;
    private final BigDecimal researchAndDevelopment;
    private final BigDecimal sellingGeneralAndAdmin;

    @JsonCreator
    public IncomeStatement(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="id") String id, @JsonProperty(value="key") String key, @JsonProperty(value="subkey") String subkey, @JsonProperty(value="updated") Long updated, @JsonProperty(value="reportDate") LocalDate reportDate, @JsonProperty(value="fiscalDate") LocalDate fiscalDate, @JsonProperty(value="currency") String currency, @JsonProperty(value="totalRevenue") BigDecimal totalRevenue, @JsonProperty(value="costOfRevenue") BigDecimal costOfRevenue, @JsonProperty(value="grossProfit") BigDecimal grossProfit, @JsonProperty(value="researchAndDevelopment") BigDecimal researchAndDevelopment, @JsonProperty(value="sellingGeneralAndAdmin") BigDecimal sellingGeneralAndAdmin, @JsonProperty(value="operatingExpense") BigDecimal operatingExpense, @JsonProperty(value="operatingIncome") BigDecimal operatingIncome, @JsonProperty(value="otherIncomeExpenseNet") BigDecimal otherIncomeExpenseNet, @JsonProperty(value="ebit") BigDecimal ebit, @JsonProperty(value="interestIncome") BigDecimal interestIncome, @JsonProperty(value="pretaxIncome") BigDecimal pretaxIncome, @JsonProperty(value="incomeTax") BigDecimal incomeTax, @JsonProperty(value="minorityInterest") BigDecimal minorityInterest, @JsonProperty(value="netIncome") BigDecimal netIncome, @JsonProperty(value="netIncomeBasic") BigDecimal netIncomeBasic, @JsonProperty(value="filingType") String filingType, @JsonProperty(value="fiscalQuarter") BigDecimal fiscalQuarter, @JsonProperty(value="fiscalYear") BigDecimal fiscalYear) {
        super(symbol, id, key, subkey, updated, reportDate, filingType, fiscalDate, fiscalQuarter, fiscalYear, currency);
        this.totalRevenue = totalRevenue;
        this.costOfRevenue = costOfRevenue;
        this.grossProfit = grossProfit;
        this.researchAndDevelopment = researchAndDevelopment;
        this.sellingGeneralAndAdmin = sellingGeneralAndAdmin;
        this.operatingExpense = operatingExpense;
        this.operatingIncome = operatingIncome;
        this.otherIncomeExpenseNet = otherIncomeExpenseNet;
        this.ebit = ebit;
        this.interestIncome = interestIncome;
        this.pretaxIncome = pretaxIncome;
        this.incomeTax = incomeTax;
        this.minorityInterest = minorityInterest;
        this.netIncome = netIncome;
        this.netIncomeBasic = netIncomeBasic;
    }

    public BigDecimal getTotalRevenue() {
        return this.totalRevenue;
    }

    public BigDecimal getCostOfRevenue() {
        return this.costOfRevenue;
    }

    public BigDecimal getGrossProfit() {
        return this.grossProfit;
    }

    public BigDecimal getResearchAndDevelopment() {
        return this.researchAndDevelopment;
    }

    public BigDecimal getSellingGeneralAndAdmin() {
        return this.sellingGeneralAndAdmin;
    }

    public BigDecimal getOperatingExpense() {
        return this.operatingExpense;
    }

    public BigDecimal getOperatingIncome() {
        return this.operatingIncome;
    }

    public BigDecimal getOtherIncomeExpenseNet() {
        return this.otherIncomeExpenseNet;
    }

    public BigDecimal getEbit() {
        return this.ebit;
    }

    public BigDecimal getInterestIncome() {
        return this.interestIncome;
    }

    public BigDecimal getPretaxIncome() {
        return this.pretaxIncome;
    }

    public BigDecimal getIncomeTax() {
        return this.incomeTax;
    }

    public BigDecimal getMinorityInterest() {
        return this.minorityInterest;
    }

    public BigDecimal getNetIncome() {
        return this.netIncome;
    }

    public BigDecimal getNetIncomeBasic() {
        return this.netIncomeBasic;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        IncomeStatement that = (IncomeStatement)o;
        return Objects.equals(this.totalRevenue, that.totalRevenue) && Objects.equals(this.costOfRevenue, that.costOfRevenue) && Objects.equals(this.grossProfit, that.grossProfit) && Objects.equals(this.researchAndDevelopment, that.researchAndDevelopment) && Objects.equals(this.sellingGeneralAndAdmin, that.sellingGeneralAndAdmin) && Objects.equals(this.operatingExpense, that.operatingExpense) && Objects.equals(this.operatingIncome, that.operatingIncome) && Objects.equals(this.otherIncomeExpenseNet, that.otherIncomeExpenseNet) && Objects.equals(this.ebit, that.ebit) && Objects.equals(this.interestIncome, that.interestIncome) && Objects.equals(this.pretaxIncome, that.pretaxIncome) && Objects.equals(this.incomeTax, that.incomeTax) && Objects.equals(this.minorityInterest, that.minorityInterest) && Objects.equals(this.netIncome, that.netIncome) && Objects.equals(this.netIncomeBasic, that.netIncomeBasic);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.totalRevenue, this.costOfRevenue, this.grossProfit, this.researchAndDevelopment, this.sellingGeneralAndAdmin, this.operatingExpense, this.operatingIncome, this.otherIncomeExpenseNet, this.ebit, this.interestIncome, this.pretaxIncome, this.incomeTax, this.minorityInterest, this.netIncome, this.netIncomeBasic);
    }

    @Override
    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("totalRevenue", (Object)this.totalRevenue).add("costOfRevenue", (Object)this.costOfRevenue).add("grossProfit", (Object)this.grossProfit).add("researchAndDevelopment", (Object)this.researchAndDevelopment).add("sellingGeneralAndAdmin", (Object)this.sellingGeneralAndAdmin).add("operatingExpense", (Object)this.operatingExpense).add("operatingIncome", (Object)this.operatingIncome).add("otherIncomeExpenseNet", (Object)this.otherIncomeExpenseNet).add("ebit", (Object)this.ebit).add("interestIncome", (Object)this.interestIncome).add("pretaxIncome", (Object)this.pretaxIncome).add("incomeTax", (Object)this.incomeTax).add("minorityInterest", (Object)this.minorityInterest).add("netIncome", (Object)this.netIncome).add("netIncomeBasic", (Object)this.netIncomeBasic).toString();
    }
}

