/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.io.Serializable;
import java.util.List;
import pl.zankowski.iextrading4j.api.stocks.v1.IncomeStatement;
import pl.zankowski.iextrading4j.api.util.ListUtil;

public class IncomeStatements
implements Serializable {
    private static final long serialVersionUID = -4920654684070765966L;
    private final String symbol;
    private final List<IncomeStatement> income;

    @JsonCreator
    public IncomeStatements(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="income") List<IncomeStatement> income) {
        this.symbol = symbol;
        this.income = ListUtil.immutableList(income);
    }

    public String getSymbol() {
        return this.symbol;
    }

    public List<IncomeStatement> getIncome() {
        return this.income;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IncomeStatements that = (IncomeStatements)o;
        return Objects.equal((Object)this.symbol, (Object)that.symbol) && Objects.equal(this.income, that.income);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.symbol, this.income});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("symbol", (Object)this.symbol).add("income", this.income).toString();
    }
}

