/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.util.Objects;
import java.util.StringJoiner;
import pl.zankowski.iextrading4j.api.stocks.v1.BaseData;

public class InsiderSummary
extends BaseData {
    private static final long serialVersionUID = 8669068160445448149L;
    private final String fullName;
    private final BigDecimal netTransacted;
    private final String reportedTitle;
    private final BigDecimal totalBought;
    private final BigDecimal totalSold;

    @JsonCreator
    public InsiderSummary(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="id") String id, @JsonProperty(value="key") String key, @JsonProperty(value="subkey") String subkey, @JsonProperty(value="updated") Long updated, @JsonProperty(value="fullName") String fullName, @JsonProperty(value="netTransacted") BigDecimal netTransacted, @JsonProperty(value="reportedTitle") String reportedTitle, @JsonProperty(value="totalBought") BigDecimal totalBought, @JsonProperty(value="totalSold") BigDecimal totalSold) {
        super(symbol, id, key, subkey, updated);
        this.fullName = fullName;
        this.netTransacted = netTransacted;
        this.reportedTitle = reportedTitle;
        this.totalBought = totalBought;
        this.totalSold = totalSold;
    }

    public String getFullName() {
        return this.fullName;
    }

    public BigDecimal getNetTransacted() {
        return this.netTransacted;
    }

    public String getReportedTitle() {
        return this.reportedTitle;
    }

    public BigDecimal getTotalBought() {
        return this.totalBought;
    }

    public BigDecimal getTotalSold() {
        return this.totalSold;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsiderSummary that = (InsiderSummary)o;
        return Objects.equals(this.fullName, that.fullName) && Objects.equals(this.netTransacted, that.netTransacted) && Objects.equals(this.reportedTitle, that.reportedTitle) && Objects.equals(this.totalBought, that.totalBought) && Objects.equals(this.totalSold, that.totalSold);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.fullName, this.netTransacted, this.reportedTitle, this.totalBought, this.totalSold);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", InsiderSummary.class.getSimpleName() + "[", "]").add("fullName='" + this.fullName + "'").add("netTransacted=" + this.netTransacted).add("reportedTitle='" + this.reportedTitle + "'").add("totalBought=" + this.totalBought).add("totalSold=" + this.totalSold).toString();
    }
}

