/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;
import pl.zankowski.iextrading4j.api.stocks.v1.BaseData;
import pl.zankowski.iextrading4j.api.stocks.v1.DirectIndirect;

public class InsiderTransaction
extends BaseData {
    private static final long serialVersionUID = -5403038990862585492L;
    private final BigDecimal conversionOrExercisePrice;
    private final DirectIndirect directIndirect;
    private final Long effectiveDate;
    private final LocalDate filingDate;
    private final String fullName;
    private final boolean is10b51;
    private final BigDecimal postShares;
    private final String reportedTitle;
    private final String transactionCode;
    private final LocalDate transactionDate;
    private final BigDecimal transactionPrice;
    private final BigDecimal transactionShares;
    private final BigDecimal transactionValue;
    private final BigDecimal tranPrice;
    private final BigDecimal tranShares;
    private final BigDecimal tranValue;

    @JsonCreator
    public InsiderTransaction(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="id") String id, @JsonProperty(value="key") String key, @JsonProperty(value="subkey") String subkey, @JsonProperty(value="updated") Long updated, @JsonProperty(value="conversionOrExercisePrice") BigDecimal conversionOrExercisePrice, @JsonProperty(value="directIndirect") DirectIndirect directIndirect, @JsonProperty(value="effectiveDate") Long effectiveDate, @JsonProperty(value="filingDate") LocalDate filingDate, @JsonProperty(value="fullName") String fullName, @JsonProperty(value="is10b51") boolean is10b51, @JsonProperty(value="postShares") BigDecimal postShares, @JsonProperty(value="reportedTitle") String reportedTitle, @JsonProperty(value="transactionCode") String transactionCode, @JsonProperty(value="transactionDate") LocalDate transactionDate, @JsonProperty(value="transactionPrice") BigDecimal transactionPrice, @JsonProperty(value="transactionShares") BigDecimal transactionShares, @JsonProperty(value="transactionValue") BigDecimal transactionValue, @JsonProperty(value="tranPrice") BigDecimal tranPrice, @JsonProperty(value="tranShares") BigDecimal tranShares, @JsonProperty(value="tranValue") BigDecimal tranValue) {
        super(symbol, id, key, subkey, updated);
        this.conversionOrExercisePrice = conversionOrExercisePrice;
        this.directIndirect = directIndirect;
        this.effectiveDate = effectiveDate;
        this.filingDate = filingDate;
        this.fullName = fullName;
        this.is10b51 = is10b51;
        this.postShares = postShares;
        this.reportedTitle = reportedTitle;
        this.transactionCode = transactionCode;
        this.transactionDate = transactionDate;
        this.transactionPrice = transactionPrice;
        this.transactionShares = transactionShares;
        this.transactionValue = transactionValue;
        this.tranPrice = tranPrice;
        this.tranShares = tranShares;
        this.tranValue = tranValue;
    }

    public BigDecimal getConversionOrExercisePrice() {
        return this.conversionOrExercisePrice;
    }

    public DirectIndirect getDirectIndirect() {
        return this.directIndirect;
    }

    public Long getEffectiveDate() {
        return this.effectiveDate;
    }

    public LocalDate getFilingDate() {
        return this.filingDate;
    }

    public String getFullName() {
        return this.fullName;
    }

    public boolean isIs10b51() {
        return this.is10b51;
    }

    public BigDecimal getPostShares() {
        return this.postShares;
    }

    public String getReportedTitle() {
        return this.reportedTitle;
    }

    public String getTransactionCode() {
        return this.transactionCode;
    }

    public LocalDate getTransactionDate() {
        return this.transactionDate;
    }

    public BigDecimal getTransactionPrice() {
        return this.transactionPrice;
    }

    public BigDecimal getTransactionShares() {
        return this.transactionShares;
    }

    public BigDecimal getTransactionValue() {
        return this.transactionValue;
    }

    public BigDecimal getTranPrice() {
        return this.tranPrice;
    }

    public BigDecimal getTranShares() {
        return this.tranShares;
    }

    public BigDecimal getTranValue() {
        return this.tranValue;
    }

    @Deprecated
    public char getTranCode() {
        return this.transactionCode == null ? (char)' ' : this.transactionCode.charAt(0);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        InsiderTransaction that = (InsiderTransaction)o;
        return this.is10b51 == that.is10b51 && Objects.equals(this.conversionOrExercisePrice, that.conversionOrExercisePrice) && Objects.equals((Object)this.directIndirect, (Object)that.directIndirect) && Objects.equals(this.effectiveDate, that.effectiveDate) && this.directIndirect == that.directIndirect && Objects.equals(this.filingDate, that.filingDate) && Objects.equals(this.fullName, that.fullName) && Objects.equals(this.postShares, that.postShares) && Objects.equals(this.reportedTitle, that.reportedTitle) && Objects.equals(this.transactionCode, that.transactionCode) && Objects.equals(this.transactionDate, that.transactionDate) && Objects.equals(this.transactionPrice, that.transactionPrice) && Objects.equals(this.transactionShares, that.transactionShares) && Objects.equals(this.transactionValue, that.transactionValue) && Objects.equals(this.tranPrice, that.tranPrice) && Objects.equals(this.tranShares, that.tranShares) && Objects.equals(this.tranValue, that.tranValue);
    }

    @Override
    public int hashCode() {
        return Objects.hash(new Object[]{super.hashCode(), this.conversionOrExercisePrice, this.directIndirect, this.effectiveDate, this.directIndirect, this.filingDate, this.fullName, this.is10b51, this.postShares, this.reportedTitle, this.transactionCode, this.transactionDate, this.transactionPrice, this.transactionShares, this.transactionValue, this.tranPrice, this.tranShares, this.tranValue});
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", InsiderTransaction.class.getSimpleName() + "[", "]").add("conversionOrExercisePrice=" + this.conversionOrExercisePrice).add("directIndirect=" + (Object)((Object)this.directIndirect)).add("effectiveDate=" + this.effectiveDate).add("filingDate=" + this.filingDate).add("fullName='" + this.fullName + "'").add("is10b51=" + this.is10b51).add("postShares=" + this.postShares).add("reportedTitle='" + this.reportedTitle + "'").add("transactionCode='" + this.transactionCode + "'").add("transactionDate=" + this.transactionDate).add("transactionPrice=" + this.transactionPrice).add("transactionShares=" + this.transactionShares).add("transactionValue=" + this.transactionValue).add("tranPrice=" + this.tranPrice).add("tranShares=" + this.tranShares).add("tranValue=" + this.tranValue).toString();
    }
}

