/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;

public class Ownership
implements Serializable {
    private static final long serialVersionUID = -90284369606919937L;
    private final String symbol;
    private final String id;
    private final BigDecimal adjHolding;
    private final BigDecimal adjMv;
    private final String entityProperName;
    protected final Long reportDate;
    private final LocalDate filingDate;
    private final BigDecimal reportedHolding;
    private final Long updated;

    @JsonCreator
    public Ownership(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="id") String id, @JsonProperty(value="adjHolding") BigDecimal adjHolding, @JsonProperty(value="adjMv") BigDecimal adjMv, @JsonProperty(value="entityProperName") String entityProperName, @JsonProperty(value="reportDate") Long reportDate, @JsonProperty(value="filingDate") LocalDate filingDate, @JsonProperty(value="reportedHolding") BigDecimal reportedHolding, @JsonProperty(value="updated") Long updated) {
        this.symbol = symbol;
        this.id = id;
        this.adjHolding = adjHolding;
        this.adjMv = adjMv;
        this.entityProperName = entityProperName;
        this.reportDate = reportDate;
        this.filingDate = filingDate;
        this.reportedHolding = reportedHolding;
        this.updated = updated;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public String getId() {
        return this.id;
    }

    public BigDecimal getAdjHolding() {
        return this.adjHolding;
    }

    public BigDecimal getAdjMv() {
        return this.adjMv;
    }

    public String getEntityProperName() {
        return this.entityProperName;
    }

    public Long getReportDate() {
        return this.reportDate;
    }

    public LocalDate getFilingDate() {
        return this.filingDate;
    }

    public BigDecimal getReportedHolding() {
        return this.reportedHolding;
    }

    public Long getUpdated() {
        return this.updated;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Ownership ownership = (Ownership)o;
        return Objects.equals(this.symbol, ownership.symbol) && Objects.equals(this.id, ownership.id) && Objects.equals(this.adjHolding, ownership.adjHolding) && Objects.equals(this.adjMv, ownership.adjMv) && Objects.equals(this.entityProperName, ownership.entityProperName) && Objects.equals(this.reportDate, ownership.reportDate) && Objects.equals(this.filingDate, ownership.filingDate) && Objects.equals(this.reportedHolding, ownership.reportedHolding) && Objects.equals(this.updated, ownership.updated);
    }

    public int hashCode() {
        return Objects.hash(this.symbol, this.id, this.adjHolding, this.adjMv, this.entityProperName, this.reportDate, this.filingDate, this.reportedHolding, this.updated);
    }

    public String toString() {
        return new StringJoiner(", ", Ownership.class.getSimpleName() + "[", "]").add("symbol='" + this.symbol + "'").add("id='" + this.id + "'").add("adjHolding=" + this.adjHolding).add("adjMv=" + this.adjMv).add("entityProperName='" + this.entityProperName + "'").add("reportDate=" + this.reportDate).add("filingDate=" + this.filingDate).add("reportedHolding=" + this.reportedHolding).add("updated=" + this.updated).toString();
    }
}

