/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks.v1;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;

public class PriceTarget
implements Serializable {
    private static final long serialVersionUID = 2641199116590474197L;
    private final String symbol;
    private final LocalDate updatedDate;
    private final BigDecimal priceTargetAverage;
    private final BigDecimal priceTargetHigh;
    private final BigDecimal priceTargetLow;
    private final BigDecimal numberOfAnalysts;
    private final String currency;

    @JsonCreator
    public PriceTarget(@JsonProperty(value="symbol") String symbol, @JsonProperty(value="updatedDate") LocalDate updatedDate, @JsonProperty(value="priceTargetAverage") BigDecimal priceTargetAverage, @JsonProperty(value="priceTargetHigh") BigDecimal priceTargetHigh, @JsonProperty(value="priceTargetLow") BigDecimal priceTargetLow, @JsonProperty(value="numberOfAnalysts") BigDecimal numberOfAnalysts, @JsonProperty(value="currency") String currency) {
        this.symbol = symbol;
        this.updatedDate = updatedDate;
        this.priceTargetAverage = priceTargetAverage;
        this.priceTargetHigh = priceTargetHigh;
        this.priceTargetLow = priceTargetLow;
        this.numberOfAnalysts = numberOfAnalysts;
        this.currency = currency;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public LocalDate getUpdatedDate() {
        return this.updatedDate;
    }

    public BigDecimal getPriceTargetAverage() {
        return this.priceTargetAverage;
    }

    public BigDecimal getPriceTargetHigh() {
        return this.priceTargetHigh;
    }

    public BigDecimal getPriceTargetLow() {
        return this.priceTargetLow;
    }

    public BigDecimal getNumberOfAnalysts() {
        return this.numberOfAnalysts;
    }

    public String getCurrency() {
        return this.currency;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        PriceTarget that = (PriceTarget)o;
        return Objects.equals(this.symbol, that.symbol) && Objects.equals(this.updatedDate, that.updatedDate) && Objects.equals(this.priceTargetAverage, that.priceTargetAverage) && Objects.equals(this.priceTargetHigh, that.priceTargetHigh) && Objects.equals(this.priceTargetLow, that.priceTargetLow) && Objects.equals(this.numberOfAnalysts, that.numberOfAnalysts) && Objects.equals(this.currency, that.currency);
    }

    public int hashCode() {
        return Objects.hash(this.symbol, this.updatedDate, this.priceTargetAverage, this.priceTargetHigh, this.priceTargetLow, this.numberOfAnalysts, this.currency);
    }

    public String toString() {
        return new StringJoiner(", ", PriceTarget.class.getSimpleName() + "[", "]").add("symbol='" + this.symbol + "'").add("updatedDate=" + this.updatedDate).add("priceTargetAverage=" + this.priceTargetAverage).add("priceTargetHigh=" + this.priceTargetHigh).add("priceTargetLow=" + this.priceTargetLow).add("numberOfAnalysts=" + this.numberOfAnalysts).add("currency='" + this.currency + "'").toString();
    }
}

