/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.api.stocks.v1;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Objects;
import java.util.StringJoiner;
import pl.zankowski.iextrading4j.api.stocks.v1.BaseData;

public abstract class Report
extends BaseData {
    private final LocalDate reportDate;
    private final String filingType;
    private final LocalDate fiscalDate;
    private final BigDecimal fiscalQuarter;
    private final BigDecimal fiscalYear;
    private final String currency;

    public Report(String symbol, String id, String key, String subkey, Long updated, LocalDate reportDate, String filingType, LocalDate fiscalDate, BigDecimal fiscalQuarter, BigDecimal fiscalYear, String currency) {
        super(symbol, id, key, subkey, updated);
        this.reportDate = reportDate;
        this.filingType = filingType;
        this.fiscalDate = fiscalDate;
        this.fiscalQuarter = fiscalQuarter;
        this.fiscalYear = fiscalYear;
        this.currency = currency;
    }

    public LocalDate getReportDate() {
        return this.reportDate;
    }

    public String getFilingType() {
        return this.filingType;
    }

    public LocalDate getFiscalDate() {
        return this.fiscalDate;
    }

    public BigDecimal getFiscalQuarter() {
        return this.fiscalQuarter;
    }

    public BigDecimal getFiscalYear() {
        return this.fiscalYear;
    }

    public String getCurrency() {
        return this.currency;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Report report = (Report)o;
        return Objects.equals(this.reportDate, report.reportDate) && Objects.equals(this.filingType, report.filingType) && Objects.equals(this.fiscalDate, report.fiscalDate) && Objects.equals(this.fiscalQuarter, report.fiscalQuarter) && Objects.equals(this.fiscalYear, report.fiscalYear) && Objects.equals(this.currency, report.currency);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.reportDate, this.filingType, this.fiscalDate, this.fiscalQuarter, this.fiscalYear, this.currency);
    }

    @Override
    public String toString() {
        return new StringJoiner(", ", Report.class.getSimpleName() + "[", "]").add("reportDate=" + this.reportDate).add("filingType='" + this.filingType + "'").add("fiscalDate=" + this.fiscalDate).add("fiscalQuarter=" + this.fiscalQuarter).add("fiscalYear=" + this.fiscalYear).add("currency='" + this.currency + "'").toString();
    }
}

