/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.function.Consumer;
import javax.ws.rs.client.Client;
import org.glassfish.jersey.client.JerseyClient;
import org.glassfish.jersey.client.JerseyClientBuilder;
import org.glassfish.jersey.jackson.JacksonFeature;
import pl.zankowski.iextrading4j.client.IEXApiClient;
import pl.zankowski.iextrading4j.client.IEXCloudClient;
import pl.zankowski.iextrading4j.client.IEXCloudToken;
import pl.zankowski.iextrading4j.client.IEXTradingApiVersion;
import pl.zankowski.iextrading4j.client.mapper.IEXTradingMapperContextResolver;
import pl.zankowski.iextrading4j.client.properties.PropertiesReader;
import pl.zankowski.iextrading4j.client.properties.PropertyType;
import pl.zankowski.iextrading4j.client.rest.endpoint.GenericRestEndpoint;
import pl.zankowski.iextrading4j.client.rest.manager.RestClient;
import pl.zankowski.iextrading4j.client.rest.manager.RestClientMetadata;
import pl.zankowski.iextrading4j.client.rest.manager.RestManager;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.socket.endpoint.GenericSocketEndpoint;
import pl.zankowski.iextrading4j.client.socket.manager.SocketManager;
import pl.zankowski.iextrading4j.client.socket.manager.SocketRequest;
import pl.zankowski.iextrading4j.client.socket.manager.SocketWrapper;
import pl.zankowski.iextrading4j.client.sse.endpoint.GenericSseEndpoint;
import pl.zankowski.iextrading4j.client.sse.manager.SseClient;
import pl.zankowski.iextrading4j.client.sse.manager.SseClientMetadata;
import pl.zankowski.iextrading4j.client.sse.manager.SseManager;
import pl.zankowski.iextrading4j.client.sse.manager.SseRequest;

public class IEXTradingClient
implements IEXApiClient,
IEXCloudClient {
    private static final Map<IEXTradingApiVersion, PropertyType> REST_PATHS = ImmutableMap.builder().put((Object)IEXTradingApiVersion.IEX_API_V1, (Object)PropertyType.API_REST_V1).put((Object)IEXTradingApiVersion.IEX_CLOUD_BETA, (Object)PropertyType.API_REST_V2_BETA).put((Object)IEXTradingApiVersion.IEX_CLOUD_BETA_SANDBOX, (Object)PropertyType.API_REST_V2_BETA_SANDBOX).put((Object)IEXTradingApiVersion.IEX_CLOUD_V1, (Object)PropertyType.API_REST_V2).put((Object)IEXTradingApiVersion.IEX_CLOUD_STABLE, (Object)PropertyType.API_REST_STABLE).put((Object)IEXTradingApiVersion.IEX_CLOUD_STABLE_SANDBOX, (Object)PropertyType.API_REST_STABLE_SANDBOX).put((Object)IEXTradingApiVersion.IEX_CLOUD_V1_SANDBOX, (Object)PropertyType.API_REST_V2_SANDBOX).build();
    private static final Map<IEXTradingApiVersion, PropertyType> SSE_PATHS = ImmutableMap.builder().put((Object)IEXTradingApiVersion.IEX_CLOUD_BETA, (Object)PropertyType.API_SSE_V2).put((Object)IEXTradingApiVersion.IEX_CLOUD_BETA_SANDBOX, (Object)PropertyType.API_SSE_V2_SANDBOX).put((Object)IEXTradingApiVersion.IEX_CLOUD_V1, (Object)PropertyType.API_SSE_V2).put((Object)IEXTradingApiVersion.IEX_CLOUD_V1_SANDBOX, (Object)PropertyType.API_SSE_V2_SANDBOX).build();
    private static final Map<IEXTradingApiVersion, PropertyType> SOCKET_PATHS = ImmutableMap.builder().put((Object)IEXTradingApiVersion.IEX_API_V1, (Object)PropertyType.API_SOCKET_V1).put((Object)IEXTradingApiVersion.IEX_CLOUD_BETA, (Object)PropertyType.API_SOCKET_V2).put((Object)IEXTradingApiVersion.IEX_CLOUD_BETA_SANDBOX, (Object)PropertyType.API_SOCKET_V2_SANDBOX).put((Object)IEXTradingApiVersion.IEX_CLOUD_V1, (Object)PropertyType.API_SOCKET_V2).put((Object)IEXTradingApiVersion.IEX_CLOUD_V1_SANDBOX, (Object)PropertyType.API_SOCKET_V2_SANDBOX).build();
    private final GenericRestEndpoint genericRestEndpoint;
    private final GenericSocketEndpoint genericSocketEndpoint;
    private final GenericSseEndpoint genericSseEndpoint;

    private IEXTradingClient() {
        this(IEXTradingApiVersion.IEX_API_V1, null);
    }

    private IEXTradingClient(IEXTradingApiVersion version, IEXCloudToken token) {
        JerseyClient client = new JerseyClientBuilder().build().register(JacksonFeature.class);
        RestClient restClient = new RestClient((Client)client, new RestClientMetadata(PropertiesReader.getInstance().getString(REST_PATHS.get((Object)version)), token));
        SseClient sseClient = new SseClient((Client)client, new SseClientMetadata(PropertiesReader.getInstance().getString(SSE_PATHS.get((Object)version)), token));
        restClient.getClient().register(IEXTradingMapperContextResolver.class);
        this.genericRestEndpoint = new GenericRestEndpoint(new RestManager(restClient));
        this.genericSocketEndpoint = new GenericSocketEndpoint(new SocketManager(new SocketWrapper(), PropertiesReader.getInstance().getString(PropertyType.API_SOCKET_V1)));
        this.genericSseEndpoint = new GenericSseEndpoint(new SseManager(sseClient));
    }

    public static IEXApiClient create() {
        return new IEXTradingClient();
    }

    public static IEXCloudClient create(IEXCloudToken token) {
        return new IEXTradingClient(IEXTradingApiVersion.IEX_CLOUD_BETA, token);
    }

    public static IEXCloudClient create(IEXTradingApiVersion version, IEXCloudToken token) {
        return new IEXTradingClient(version, token);
    }

    @Override
    public <R> R executeRequest(RestRequest<R> restRequest) {
        return this.genericRestEndpoint.executeRequest(restRequest);
    }

    @Override
    public <R> void subscribe(SseRequest<R> sseRequest, Consumer<R> consumer) {
        this.genericSseEndpoint.subscribe(sseRequest, consumer);
    }

    @Override
    public <R> void unsubscribe(SseRequest<R> sseRequest) {
        this.genericSseEndpoint.unsubscribe(sseRequest);
    }

    @Override
    public <R> void subscribe(SocketRequest<R> socketRequest, Consumer<R> consumer) {
        this.genericSocketEndpoint.subscribe(socketRequest, consumer);
    }

    @Override
    public <R> void unsubscribe(SocketRequest<R> socketRequest) {
        this.genericSocketEndpoint.unsubscribe(socketRequest);
    }
}

