/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.mapper;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.deser.std.StdScalarDeserializer;
import java.io.IOException;
import java.math.BigDecimal;

class HackyBigDecimalDeserializer
extends StdScalarDeserializer<BigDecimal> {
    HackyBigDecimalDeserializer() {
        super(BigDecimal.class);
    }

    public BigDecimal deserialize(JsonParser parser, DeserializationContext ctx) throws IOException {
        String val = parser.getValueAsString();
        if (val == null || "N/A".equalsIgnoreCase(val) || "NaN".equalsIgnoreCase(val) || val.isEmpty()) {
            return null;
        }
        try {
            return parser.getDecimalValue();
        }
        catch (IOException e) {
            return new BigDecimal(val);
        }
    }
}

