/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.mapper;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.module.SimpleModule;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import javax.ws.rs.ext.ContextResolver;
import javax.ws.rs.ext.Provider;
import pl.zankowski.iextrading4j.api.alternative.CryptoEventReason;
import pl.zankowski.iextrading4j.api.alternative.CryptoEventType;
import pl.zankowski.iextrading4j.api.alternative.CryptoSide;
import pl.zankowski.iextrading4j.api.marketdata.SystemEventType;
import pl.zankowski.iextrading4j.api.marketdata.TradingStatusReasonType;
import pl.zankowski.iextrading4j.api.marketdata.TradingStatusType;
import pl.zankowski.iextrading4j.api.refdata.DelistingReason;
import pl.zankowski.iextrading4j.api.refdata.DividendTypeId;
import pl.zankowski.iextrading4j.api.refdata.FinancialStatus;
import pl.zankowski.iextrading4j.api.refdata.Flag;
import pl.zankowski.iextrading4j.api.refdata.IssueEvent;
import pl.zankowski.iextrading4j.api.refdata.IssueSubType;
import pl.zankowski.iextrading4j.api.refdata.IssueType;
import pl.zankowski.iextrading4j.api.refdata.ListingCenter;
import pl.zankowski.iextrading4j.api.refdata.LuldTier;
import pl.zankowski.iextrading4j.api.refdata.PaymentFrequency;
import pl.zankowski.iextrading4j.api.refdata.QualifiedDividendType;
import pl.zankowski.iextrading4j.api.refdata.SymbolType;
import pl.zankowski.iextrading4j.api.stocks.ChartRange;
import pl.zankowski.iextrading4j.api.stocks.DividendQualification;
import pl.zankowski.iextrading4j.api.stocks.DividendType;
import pl.zankowski.iextrading4j.api.stocks.v1.DirectIndirect;
import pl.zankowski.iextrading4j.client.mapper.ChartRangeDeserializer;
import pl.zankowski.iextrading4j.client.mapper.ChartRangeSerializer;
import pl.zankowski.iextrading4j.client.mapper.CryptoEventReasonDeserializer;
import pl.zankowski.iextrading4j.client.mapper.CryptoEventReasonSerializer;
import pl.zankowski.iextrading4j.client.mapper.CryptoEventTypeDeserializer;
import pl.zankowski.iextrading4j.client.mapper.CryptoEventTypeSerializer;
import pl.zankowski.iextrading4j.client.mapper.CryptoSideDeserializer;
import pl.zankowski.iextrading4j.client.mapper.CryptoSideSerializer;
import pl.zankowski.iextrading4j.client.mapper.DeepChannelDeserializer;
import pl.zankowski.iextrading4j.client.mapper.DeepChannelSerializer;
import pl.zankowski.iextrading4j.client.mapper.DelistingReasonDeserializer;
import pl.zankowski.iextrading4j.client.mapper.DelistingReasonSerializer;
import pl.zankowski.iextrading4j.client.mapper.DirectIndirectDeserializer;
import pl.zankowski.iextrading4j.client.mapper.DirectIndirectSerializer;
import pl.zankowski.iextrading4j.client.mapper.DividendQualificationDeserializer;
import pl.zankowski.iextrading4j.client.mapper.DividendQualificationSerializer;
import pl.zankowski.iextrading4j.client.mapper.DividendTypeDeserializer;
import pl.zankowski.iextrading4j.client.mapper.DividendTypeIdDeserializer;
import pl.zankowski.iextrading4j.client.mapper.DividendTypeIdSerializer;
import pl.zankowski.iextrading4j.client.mapper.DividendTypeSerializer;
import pl.zankowski.iextrading4j.client.mapper.FinancialStatusDeserializer;
import pl.zankowski.iextrading4j.client.mapper.FinancialStatusSerializer;
import pl.zankowski.iextrading4j.client.mapper.FlagDeserializer;
import pl.zankowski.iextrading4j.client.mapper.FlagSerializer;
import pl.zankowski.iextrading4j.client.mapper.HackyBigDecimalDeserializer;
import pl.zankowski.iextrading4j.client.mapper.HackyLocalDateDeserializer;
import pl.zankowski.iextrading4j.client.mapper.HackyLocalDateTimeDeserializer;
import pl.zankowski.iextrading4j.client.mapper.IssueEventDeserializer;
import pl.zankowski.iextrading4j.client.mapper.IssueEventSerializer;
import pl.zankowski.iextrading4j.client.mapper.IssueSubTypeDeserializer;
import pl.zankowski.iextrading4j.client.mapper.IssueSubTypeSerializer;
import pl.zankowski.iextrading4j.client.mapper.IssueTypeDeserializer;
import pl.zankowski.iextrading4j.client.mapper.IssueTypeSerializer;
import pl.zankowski.iextrading4j.client.mapper.ListingCenterDeserializer;
import pl.zankowski.iextrading4j.client.mapper.ListingCenterSerializer;
import pl.zankowski.iextrading4j.client.mapper.LuldTierDeserializer;
import pl.zankowski.iextrading4j.client.mapper.LuldTierSerializer;
import pl.zankowski.iextrading4j.client.mapper.PaymentFrequencyDeserializer;
import pl.zankowski.iextrading4j.client.mapper.PaymentFrequencySerializer;
import pl.zankowski.iextrading4j.client.mapper.QualifiedDividendTypeDeserializer;
import pl.zankowski.iextrading4j.client.mapper.QualifiedDividendTypeSerializer;
import pl.zankowski.iextrading4j.client.mapper.SymbolTypeDeserializer;
import pl.zankowski.iextrading4j.client.mapper.SymbolTypeSerializer;
import pl.zankowski.iextrading4j.client.mapper.SystemEventTypeDeserializer;
import pl.zankowski.iextrading4j.client.mapper.SystemEventTypeSerializer;
import pl.zankowski.iextrading4j.client.mapper.TradingStatusReasonTypeDeserializer;
import pl.zankowski.iextrading4j.client.mapper.TradingStatusReasonTypeSerializer;
import pl.zankowski.iextrading4j.client.mapper.TradingStatusTypeDeserializer;
import pl.zankowski.iextrading4j.client.mapper.TradingStatusTypeSerializer;
import pl.zankowski.iextrading4j.client.properties.PropertiesReader;
import pl.zankowski.iextrading4j.client.properties.PropertyType;
import pl.zankowski.iextrading4j.client.socket.request.marketdata.deep.DeepChannel;

@Provider
public class IEXTradingMapperContextResolver
implements ContextResolver<ObjectMapper> {
    private final ObjectMapper objectMapper = this.initializeObjectMapper();

    public ObjectMapper getContext(Class<?> type) {
        return this.objectMapper;
    }

    private ObjectMapper initializeObjectMapper() {
        ObjectMapper customMapper = new ObjectMapper();
        customMapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        customMapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, PropertiesReader.getInstance().getBoolean(PropertyType.FAIL_ON_UNKNOWN_PROPERTIES).booleanValue());
        customMapper.configure(DeserializationFeature.ACCEPT_SINGLE_VALUE_AS_ARRAY, true);
        customMapper.registerModule((Module)new JavaTimeModule());
        customMapper.registerModule(this.iexTradingModule());
        return customMapper;
    }

    private Module iexTradingModule() {
        SimpleModule module = new SimpleModule("iexTradingModule");
        module.addDeserializer(BigDecimal.class, (JsonDeserializer)new HackyBigDecimalDeserializer());
        module.addDeserializer(LocalDate.class, (JsonDeserializer)new HackyLocalDateDeserializer());
        module.addDeserializer(LocalDateTime.class, (JsonDeserializer)new HackyLocalDateTimeDeserializer());
        module.addSerializer(CryptoEventType.class, (JsonSerializer)new CryptoEventTypeSerializer());
        module.addDeserializer(CryptoEventType.class, (JsonDeserializer)new CryptoEventTypeDeserializer());
        module.addSerializer(CryptoEventReason.class, (JsonSerializer)new CryptoEventReasonSerializer());
        module.addDeserializer(CryptoEventReason.class, (JsonDeserializer)new CryptoEventReasonDeserializer());
        module.addSerializer(CryptoSide.class, (JsonSerializer)new CryptoSideSerializer());
        module.addDeserializer(CryptoSide.class, (JsonDeserializer)new CryptoSideDeserializer());
        module.addSerializer(DeepChannel.class, (JsonSerializer)new DeepChannelSerializer());
        module.addDeserializer(DeepChannel.class, (JsonDeserializer)new DeepChannelDeserializer());
        module.addSerializer(ChartRange.class, (JsonSerializer)new ChartRangeSerializer());
        module.addDeserializer(ChartRange.class, (JsonDeserializer)new ChartRangeDeserializer());
        module.addSerializer(DelistingReason.class, (JsonSerializer)new DelistingReasonSerializer());
        module.addDeserializer(DelistingReason.class, (JsonDeserializer)new DelistingReasonDeserializer());
        module.addSerializer(DividendQualification.class, (JsonSerializer)new DividendQualificationSerializer());
        module.addDeserializer(DividendQualification.class, (JsonDeserializer)new DividendQualificationDeserializer());
        module.addSerializer(DividendType.class, (JsonSerializer)new DividendTypeSerializer());
        module.addDeserializer(DividendType.class, (JsonDeserializer)new DividendTypeDeserializer());
        module.addSerializer(DividendTypeId.class, (JsonSerializer)new DividendTypeIdSerializer());
        module.addDeserializer(DividendTypeId.class, (JsonDeserializer)new DividendTypeIdDeserializer());
        module.addSerializer(FinancialStatus.class, (JsonSerializer)new FinancialStatusSerializer());
        module.addDeserializer(FinancialStatus.class, (JsonDeserializer)new FinancialStatusDeserializer());
        module.addSerializer(Flag.class, (JsonSerializer)new FlagSerializer());
        module.addDeserializer(Flag.class, (JsonDeserializer)new FlagDeserializer());
        module.addSerializer(DirectIndirect.class, (JsonSerializer)new DirectIndirectSerializer());
        module.addDeserializer(DirectIndirect.class, (JsonDeserializer)new DirectIndirectDeserializer());
        module.addSerializer(IssueEvent.class, (JsonSerializer)new IssueEventSerializer());
        module.addDeserializer(IssueEvent.class, (JsonDeserializer)new IssueEventDeserializer());
        module.addSerializer(IssueSubType.class, (JsonSerializer)new IssueSubTypeSerializer());
        module.addDeserializer(IssueSubType.class, (JsonDeserializer)new IssueSubTypeDeserializer());
        module.addSerializer(IssueType.class, (JsonSerializer)new IssueTypeSerializer());
        module.addDeserializer(IssueType.class, (JsonDeserializer)new IssueTypeDeserializer());
        module.addSerializer(ListingCenter.class, (JsonSerializer)new ListingCenterSerializer());
        module.addDeserializer(ListingCenter.class, (JsonDeserializer)new ListingCenterDeserializer());
        module.addSerializer(LuldTier.class, (JsonSerializer)new LuldTierSerializer());
        module.addDeserializer(LuldTier.class, (JsonDeserializer)new LuldTierDeserializer());
        module.addSerializer(PaymentFrequency.class, (JsonSerializer)new PaymentFrequencySerializer());
        module.addDeserializer(PaymentFrequency.class, (JsonDeserializer)new PaymentFrequencyDeserializer());
        module.addSerializer(QualifiedDividendType.class, (JsonSerializer)new QualifiedDividendTypeSerializer());
        module.addDeserializer(QualifiedDividendType.class, (JsonDeserializer)new QualifiedDividendTypeDeserializer());
        module.addSerializer(SymbolType.class, (JsonSerializer)new SymbolTypeSerializer());
        module.addDeserializer(SymbolType.class, (JsonDeserializer)new SymbolTypeDeserializer());
        module.addSerializer(SystemEventType.class, (JsonSerializer)new SystemEventTypeSerializer());
        module.addDeserializer(SystemEventType.class, (JsonDeserializer)new SystemEventTypeDeserializer());
        module.addSerializer(TradingStatusType.class, (JsonSerializer)new TradingStatusTypeSerializer());
        module.addDeserializer(TradingStatusType.class, (JsonDeserializer)new TradingStatusTypeDeserializer());
        module.addSerializer(TradingStatusReasonType.class, (JsonSerializer)new TradingStatusReasonTypeSerializer());
        module.addDeserializer(TradingStatusReasonType.class, (JsonDeserializer)new TradingStatusReasonTypeDeserializer());
        return module;
    }
}

