/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.properties;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import pl.zankowski.iextrading4j.client.properties.PropertyType;

public class PropertiesReader {
    private static final String PROPERTIES_NAME = "iextrading.properties";
    private static final PropertiesReader INSTANCE = new PropertiesReader();
    private final Properties properties = new Properties();

    public PropertiesReader() {
        this.setDefaults();
        try (InputStream propertiesStream = PropertiesReader.class.getClassLoader().getResourceAsStream(PROPERTIES_NAME);){
            if (propertiesStream != null) {
                this.properties.load(propertiesStream);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static PropertiesReader getInstance() {
        return INSTANCE;
    }

    private void setDefaults() {
        for (PropertyType propertyType : PropertyType.values()) {
            this.properties.setProperty(propertyType.name(), propertyType.getDefaultValue());
        }
    }

    public String getString(PropertyType propertyType) {
        if (propertyType == null) {
            return null;
        }
        return this.properties.getProperty(propertyType.name());
    }

    public Boolean getBoolean(PropertyType propertyType) {
        return Boolean.valueOf(this.getString(propertyType));
    }
}

