/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.manager;

import com.google.common.collect.Maps;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.ws.rs.client.Entity;
import javax.ws.rs.client.Invocation;
import javax.ws.rs.core.Response;
import pl.zankowski.iextrading4j.api.exception.IEXTradingException;
import pl.zankowski.iextrading4j.client.IEXCloudToken;
import pl.zankowski.iextrading4j.client.rest.manager.MethodType;
import pl.zankowski.iextrading4j.client.rest.manager.PostEntity;
import pl.zankowski.iextrading4j.client.rest.manager.RestClient;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;
import pl.zankowski.iextrading4j.client.rest.manager.RestResponse;
import pl.zankowski.iextrading4j.client.rest.manager.RestResponseBuilder;

public class RestManager {
    private static final String TOKEN_QUERY_PARAM = "token";
    private static final int SUCCESS = 200;
    private static final int WRITE_SUCCESS = 201;
    private final RestClient restClient;

    public RestManager(RestClient restClient) {
        this.restClient = restClient;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R> RestResponse<R> executeRequest(RestRequest<R> restRequest) {
        String url = this.createURL(restRequest, this.restClient.getRestClientMetadata().getToken(), this.restClient.getRestClientMetadata().getUrl());
        Invocation.Builder target = this.restClient.getClient().target(url).request(new String[]{"application/json"});
        try (Response response = null;){
            switch (restRequest.getMethodType()) {
                case GET: {
                    response = target.get();
                    break;
                }
                case POST: {
                    PostEntity requestEntity = restRequest.getRequestEntity();
                    requestEntity.setToken(this.resolveToken(restRequest, this.restClient.getRestClientMetadata().getToken()));
                    response = target.post(Entity.entity((Object)requestEntity, (String)"application/json"));
                    break;
                }
                default: {
                    throw new IllegalStateException("Method Type not supported.");
                }
            }
            if (!this.isSuccessful(response)) {
                String errorMessage = (String)response.readEntity(String.class);
                throw new IEXTradingException(errorMessage, response.getStatus());
            }
            RestResponse<Object> restResponse = new RestResponseBuilder().withMessage(response.getStatusInfo().getReasonPhrase()).withResponse(response.readEntity(restRequest.getResponseType())).build();
            return restResponse;
        }
    }

    private boolean isSuccessful(Response response) {
        return response.getStatus() == 200 || response.getStatus() == 201;
    }

    private <R> String createURL(RestRequest<R> restRequest, IEXCloudToken token, String url) {
        return url + this.createPath(restRequest.getPath(), restRequest.getPathParams()) + this.createQueryParameters(restRequest.getQueryParams(), this.resolveUrlToken(restRequest, token));
    }

    private <R> String resolveUrlToken(RestRequest<R> restRequest, IEXCloudToken token) {
        return restRequest.getMethodType() != MethodType.GET ? null : this.resolveToken(restRequest, token);
    }

    private <R> String resolveToken(RestRequest<R> restRequest, IEXCloudToken token) {
        return token == null ? null : (restRequest.getUseSecretToken() != false ? token.getSecretToken() : token.getPublishableToken());
    }

    private String createPath(String originalPath, Map<String, String> pathParams) {
        String path = originalPath;
        for (Map.Entry<String, String> entry : pathParams.entrySet()) {
            path = path.replaceFirst("\\{" + entry.getKey() + "\\}", entry.getValue());
        }
        return path;
    }

    private String createQueryParameters(Map<String, String> queryParams, String publishableToken) {
        if (queryParams.isEmpty() && publishableToken == null) {
            return "";
        }
        HashMap paramsCopy = Maps.newHashMap(queryParams);
        if (publishableToken != null) {
            paramsCopy.put(TOKEN_QUERY_PARAM, publishableToken);
        }
        return paramsCopy.entrySet().stream().map(this::createQueryParam).collect(Collectors.joining("&", "?", ""));
    }

    private String createQueryParam(Map.Entry<String, String> queryParam) {
        return queryParam.getKey() + "=" + queryParam.getValue();
    }
}

