/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.manager;

import com.google.common.base.MoreObjects;
import com.google.common.base.Objects;
import java.util.Map;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.api.util.MapUtil;
import pl.zankowski.iextrading4j.client.rest.manager.MethodType;
import pl.zankowski.iextrading4j.client.rest.manager.PostEntity;

public class RestRequest<R> {
    private final GenericType<R> responseType;
    private final PostEntity requestEntity;
    private final String path;
    private final MethodType methodType;
    private final Map<String, String> headerParams;
    private final Map<String, String> queryParams;
    private final Map<String, String> pathParams;
    private final Boolean useSecretToken;

    public RestRequest(GenericType<R> responseType, PostEntity requestEntity, String path, MethodType methodType, Map<String, String> headerParams, Map<String, String> queryParams, Map<String, String> pathParams, Boolean useSecretToken) {
        this.responseType = responseType;
        this.requestEntity = requestEntity;
        this.path = path;
        this.methodType = methodType;
        this.headerParams = MapUtil.immutableMap(headerParams);
        this.queryParams = MapUtil.immutableMap(queryParams);
        this.pathParams = MapUtil.immutableMap(pathParams);
        this.useSecretToken = useSecretToken;
    }

    public GenericType<R> getResponseType() {
        return this.responseType;
    }

    public PostEntity getRequestEntity() {
        return this.requestEntity;
    }

    public String getPath() {
        return this.path;
    }

    public MethodType getMethodType() {
        return this.methodType;
    }

    public Map<String, String> getHeaderParams() {
        return this.headerParams;
    }

    public Map<String, String> getQueryParams() {
        return this.queryParams;
    }

    public Map<String, String> getPathParams() {
        return this.pathParams;
    }

    public Boolean getUseSecretToken() {
        return this.useSecretToken;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RestRequest that = (RestRequest)o;
        return Objects.equal(this.responseType, that.responseType) && Objects.equal((Object)this.requestEntity, (Object)that.requestEntity) && Objects.equal((Object)this.path, (Object)that.path) && this.methodType == that.methodType && Objects.equal(this.headerParams, that.headerParams) && Objects.equal(this.queryParams, that.queryParams) && Objects.equal(this.pathParams, that.pathParams) && Objects.equal((Object)this.useSecretToken, (Object)that.useSecretToken);
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.responseType, this.requestEntity, this.path, this.methodType, this.headerParams, this.queryParams, this.pathParams, this.useSecretToken});
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("responseType", this.responseType).add("requestEntity", (Object)this.requestEntity).add("path", (Object)this.path).add("methodType", (Object)this.methodType).add("headerParams", this.headerParams).add("queryParams", this.queryParams).add("pathParams", this.pathParams).add("useSecretToken", (Object)this.useSecretToken).toString();
    }
}

