/*
 * Decompiled with CFR 0.152.
 */
package pl.zankowski.iextrading4j.client.rest.manager;

import com.google.common.collect.Maps;
import java.util.Map;
import javax.ws.rs.core.GenericType;
import pl.zankowski.iextrading4j.client.rest.manager.IRestParamRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.manager.IRestPathRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.manager.IRestRequestBodyBuilder;
import pl.zankowski.iextrading4j.client.rest.manager.IRestRequestTypeBuilder;
import pl.zankowski.iextrading4j.client.rest.manager.IRestResponseTypeRequestBuilder;
import pl.zankowski.iextrading4j.client.rest.manager.MethodType;
import pl.zankowski.iextrading4j.client.rest.manager.PostEntity;
import pl.zankowski.iextrading4j.client.rest.manager.RestRequest;

public class RestRequestBuilder<R>
implements IRestPathRequestBuilder<R>,
IRestRequestTypeBuilder<R>,
IRestResponseTypeRequestBuilder<R>,
IRestParamRequestBuilder<R>,
IRestRequestBodyBuilder<R> {
    private GenericType<R> responseType;
    private PostEntity requestEntity;
    private String path;
    private MethodType methodType;
    private Map<String, String> headerParams;
    private Map<String, String> queryParams;
    private Map<String, String> pathParams;
    private Boolean useSecretToken = Boolean.FALSE;

    protected RestRequestBuilder() {
        this.headerParams = Maps.newHashMap();
        this.queryParams = Maps.newHashMap();
        this.pathParams = Maps.newHashMap();
    }

    public static <R> IRestPathRequestBuilder<R> builder() {
        return new RestRequestBuilder<R>();
    }

    @Override
    public IRestRequestTypeBuilder<R> withPath(String path) {
        this.path = path;
        return this;
    }

    @Override
    public IRestRequestTypeBuilder<R> addPathParam(String key, String value) {
        this.pathParams.put(key, value);
        return this;
    }

    @Override
    public IRestParamRequestBuilder<R> addHeaderParam(String key, String value) {
        this.headerParams.put(key, value);
        return this;
    }

    @Override
    public IRestParamRequestBuilder<R> addQueryParam(String key, String value) {
        this.queryParams.put(key, value);
        return this;
    }

    @Override
    public IRestParamRequestBuilder<R> addQueryParam(Map<String, String> queryParams) {
        this.queryParams.putAll(queryParams);
        return this;
    }

    @Override
    public IRestResponseTypeRequestBuilder<R> get() {
        this.methodType = MethodType.GET;
        return this;
    }

    @Override
    public IRestRequestBodyBuilder<R> post() {
        this.methodType = MethodType.POST;
        return this;
    }

    @Override
    public IRestResponseTypeRequestBuilder<R> withRequest(PostEntity requestEntity) {
        this.requestEntity = requestEntity;
        return this;
    }

    @Override
    public IRestParamRequestBuilder<R> withResponse(Class<R> responseType) {
        this.responseType = new GenericType(responseType);
        return this;
    }

    @Override
    public IRestParamRequestBuilder<R> withResponse(GenericType<R> responseType) {
        this.responseType = responseType;
        return this;
    }

    @Override
    public IRestParamRequestBuilder<R> withSecretToken() {
        this.useSecretToken = true;
        return this;
    }

    @Override
    public RestRequest<R> build() {
        return new RestRequest<R>(this.responseType, this.requestEntity, this.path, this.methodType, this.headerParams, this.queryParams, this.pathParams, this.useSecretToken);
    }
}

